/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.drop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.DropResults;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkDropMailSender;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.qubership.atp.tdm.websocket.bulkaction.BulkActionsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataDropHandler
extends BulkActionsHandler {
    private static final Logger log = LoggerFactory.getLogger(BulkDataDropHandler.class);
    private final TestDataService testDataService;

    public BulkDataDropHandler(@Qualifier(value="websocket") ExecutorService executorService, @Nonnull CatalogRepository catalogRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull TestDataService testDataService, @Nonnull BulkDropMailSender mailSender, @Nonnull CurrentTime currentTime, @Nonnull LockManager lockManager, @Nonnull TdmMdcHelper mdcHelper) {
        super(executorService, catalogRepository, environmentsService, mailSender, currentTime, lockManager, mdcHelper);
        this.testDataService = testDataService;
    }

    @Override
    public List<Future<BulkActionResult>> runBulkAction(@Nonnull WebSocketSession session, @Nonnull ExecutorService executor, @Nonnull List<LazyEnvironment> lazyEnvironments, @Nonnull BulkActionConfig config, long processId) {
        log.info("Bulk drop has been initiated, id: {}, config: {}", (Object)processId, (Object)config);
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndTableTitle(config.getProjectId(), config.getTableTitle());
        log.trace("Found: {} tables.", (Object)catalogList.size());
        ArrayList<Future<BulkActionResult>> futures = new ArrayList<Future<BulkActionResult>>();
        Map mdcMap = MDC.getCopyOfContextMap();
        catalogList.forEach(tableCatalog -> {
            Future<BulkActionResult> future = executor.submit(() -> {
                MdcUtils.setContextMap((Map)mdcMap);
                String envName = this.getEnvName(lazyEnvironments, tableCatalog.getEnvironmentId());
                try {
                    this.mdcHelper.putConfigFields((TestDataTableCatalog)tableCatalog);
                    DropResults dropResults = this.testDataService.deleteTestData(tableCatalog.getTableName());
                    BulkActionResult bulkActionResult = new BulkActionResult(tableCatalog.getTableTitle(), tableCatalog.getTableName(), envName, dropResults);
                    return bulkActionResult;
                }
                catch (Exception e) {
                    BulkActionResult bulkActionResult = new BulkActionResult(tableCatalog.getTableTitle(), tableCatalog.getTableName(), envName, e);
                    return bulkActionResult;
                }
                finally {
                    this.mdcHelper.removeConfigFields();
                }
            });
            futures.add(future);
        });
        return futures;
    }
}

