/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec;

import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.util.ArrayList;
import java.util.List;

public class RejoinTable
implements Table {
    private Table _table;
    private String _alias;
    private List<RejoinColumn> _columns;

    public RejoinTable(Table table, String alias) {
        this._table = table;
        this._alias = alias;
        this._columns = new ArrayList<RejoinColumn>(this._table.getColumns().size());
        for (Column column : this._table.getColumns()) {
            this._columns.add(new RejoinColumn(column));
        }
    }

    public Table getOriginalTable() {
        return this._table;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getTableNameSQL() {
        return this._table.getTableNameSQL();
    }

    public List<RejoinColumn> getColumns() {
        return this._columns;
    }

    @Override
    public List<? extends Constraint> getConstraints() {
        return this._table.getConstraints();
    }

    public RejoinColumn findColumnByName(String name) {
        for (RejoinColumn col : this.getColumns()) {
            if (name != col.getColumnNameSQL() && (name == null || !name.equals(col.getColumnNameSQL()))) continue;
            return col;
        }
        return null;
    }

    public RejoinColumn findColumn(Column origCol) {
        for (RejoinColumn col : this.getColumns()) {
            if (origCol != col.getOriginalColumn()) continue;
            return col;
        }
        return null;
    }

    public String toString() {
        return "Rejoin: " + this.getOriginalTable().toString() + "(" + this.getAlias() + ")";
    }

    public class RejoinColumn
    implements Column {
        private Column _column;

        private RejoinColumn(Column column) {
            this._column = column;
        }

        public Column getOriginalColumn() {
            return this._column;
        }

        @Override
        public RejoinTable getTable() {
            return RejoinTable.this;
        }

        @Override
        public String getColumnNameSQL() {
            return this._column.getColumnNameSQL();
        }

        @Override
        public String getTypeNameSQL() {
            return this._column.getTypeNameSQL();
        }

        @Override
        public Integer getTypeLength() {
            return this._column.getTypeLength();
        }

        @Override
        public List<?> getTypeQualifiers() {
            return this._column.getTypeQualifiers();
        }

        @Override
        public List<? extends Constraint> getConstraints() {
            return this._column.getConstraints();
        }

        @Override
        public Object getDefaultValue() {
            return this._column.getDefaultValue();
        }

        public String toString() {
            return "Rejoin: " + this.getOriginalColumn().toString() + "(" + this.getTable() + ")";
        }
    }
}

