/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.Matrix;

public final class MatrixInt
implements Matrix {
    private int[][] matrix;

    @Override
    public void setup(int width, int height) {
        this.matrix = new int[width][height];
    }

    @Override
    public void set(int i, int j, int x) {
        this.matrix[i][j] = x;
    }

    @Override
    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    @Override
    public void incrementPathBy(int i, int j, int n) {
        this.matrix[i][j] = this.matrix[i + 1][j + 1] + n;
    }

    @Override
    public void incrementByMaxPath(int i, int j) {
        this.matrix[i][j] = Math.max(this.matrix[i + 1][j], this.matrix[i][j + 1]);
    }

    @Override
    public boolean isGreaterX(int i, int j) {
        return this.matrix[i + 1][j] > this.matrix[i][j + 1];
    }

    @Override
    public boolean isGreaterY(int i, int j) {
        return this.matrix[i + 1][j] < this.matrix[i][j + 1];
    }

    @Override
    public boolean isSameXY(int i, int j) {
        return this.matrix[i + 1][j] == this.matrix[i][j + 1];
    }

    @Override
    public void release() {
        this.matrix = null;
    }
}

