/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.TransformerException;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModelCell;
import org.docx4j.finders.TcFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.table.TableModel;
import org.docx4j.model.table.TableModelRow;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractTableWriterModel
extends TableModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableWriterModel.class);

    public void addCell(Tc tc, Node content) {
        log.debug("Add tc row " + this.row + " col 1+" + this.col);
        this.addRow(new AbstractTableWriterModelCell(this, this.row, ++this.col, tc, content));
        if (tc.getTcPr() != null && tc.getTcPr().getGridSpan() != null && tc.getTcPr().getGridSpan().getVal() != null) {
            int gridSpan = tc.getTcPr().getGridSpan().getVal().intValue();
            this.addDummyCell(gridSpan, false, false);
        }
    }

    protected void addRow(AbstractTableWriterModelCell cell) {
        ((TableModelRow)this.rows.get(this.row)).add(cell);
    }

    public void build(AbstractWmlConversionContext conversionContext, Object node, Node content) throws TransformerException {
        Tbl tbl = null;
        try {
            tbl = (Tbl)node;
        }
        catch (ClassCastException e) {
            throw new TransformerException("Node is not of the type Tbl it is " + node.getClass().getName());
        }
        if (tbl.getTblPr() != null && tbl.getTblPr().getTblStyle() != null) {
            this.styleId = tbl.getTblPr().getTblStyle().getVal();
        }
        this.tblGrid = tbl.getTblGrid();
        this.tblPr = tbl.getTblPr();
        PropertyResolver pr = conversionContext.getPropertyResolver();
        this.effectiveTableStyle = pr.getEffectiveTableStyle(tbl.getTblPr());
        NodeList cellContents = content.getChildNodes();
        TableModel.TrFinder trFinder = new TableModel.TrFinder();
        new TraversalUtil(tbl, trFinder);
        this.ensureFoTableBody(trFinder.getTrList());
        int r = 0;
        for (Tr tr : trFinder.getTrList()) {
            this.startRow(tr);
            this.handleRow(cellContents, tr, r);
            ++r;
            if (!((TableModelRow)this.rows.get(this.row)).getRowContents().isEmpty()) continue;
            this.rows.remove(this.row);
            --this.row;
            --r;
        }
        CTTblPrBase tblPr = this.effectiveTableStyle.getTblPr();
        if (tblPr != null && tblPr.getTblCellSpacing() != null) {
            this.setBorderConflictResolutionRequired(false);
        }
        this.width = this.calcTableWidth();
    }

    private void ensureFoTableBody(List<Tr> rows) {
        Tr tr;
        int i;
        int numRows = rows.size();
        if (numRows == 0) {
            log.warn("Encountered table with no rows");
            return;
        }
        Tr lastRow = rows.get(numRows - 1);
        if (this.isHeaderRow(lastRow)) {
            List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore = lastRow.getTrPr().getCnfStyleOrDivIdOrGridBefore();
            JAXBElement<?> tblHeader = this.getElement(cnfStyleOrDivIdOrGridBefore, "tblHeader");
            cnfStyleOrDivIdOrGridBefore.remove(tblHeader);
        }
        int indexOfLastHeaderRow = -1;
        for (i = rows.size(); i > 0; --i) {
            tr = rows.get(i - 1);
            if (!this.isHeaderRow(tr)) continue;
            indexOfLastHeaderRow = i - 1;
            break;
        }
        for (i = 0; i < indexOfLastHeaderRow; ++i) {
            tr = rows.get(i);
            if (this.isHeaderRow(tr)) continue;
            TrPr trpr = tr.getTrPr();
            if (trpr == null) {
                trpr = Context.getWmlObjectFactory().createTrPr();
                tr.setTrPr(trpr);
            }
            BooleanDefaultTrue booleandefaulttrue = Context.getWmlObjectFactory().createBooleanDefaultTrue();
            JAXBElement<BooleanDefaultTrue> booleandefaulttrueWrapped = Context.getWmlObjectFactory().createCTTrPrBaseTblHeader(booleandefaulttrue);
            trpr.getCnfStyleOrDivIdOrGridBefore().add(booleandefaulttrueWrapped);
        }
    }

    protected void handleRow(NodeList cellContents, Tr tr, int r) {
        int gridAfter = this.getGridAfter(tr);
        int gridBefore = this.getGridBefore(tr);
        boolean headerRow = this.isHeaderRow(tr);
        log.debug("Processing r " + r);
        if (this.isBorderConflictResolutionRequired() && tr.getTblPrEx() != null && tr.getTblPrEx().getTblCellSpacing() != null) {
            this.setBorderConflictResolutionRequired(false);
        }
        if (headerRow && this.headerMaxRow < r) {
            this.headerMaxRow = r;
        }
        if (this.drawTableBorder) {
            this.drawTableBorder = gridBefore == 0 && gridAfter == 0;
        }
        TcFinder tcFinder = new TcFinder();
        new TraversalUtil(tr, tcFinder);
        if (gridBefore > 0) {
            this.addDummyCell(gridBefore, true, false);
        }
        int c = 0;
        log.debug("Processing c " + c);
        for (Tc tc : tcFinder.tcList) {
            Node wtrNode = cellContents.item(r);
            if (wtrNode == null) {
                log.warn("Couldn't find item " + r);
            }
            this.addCell(tc, this.getTc(wtrNode, c, new IntRef(0)));
            ++c;
        }
        if (gridAfter > 0) {
            this.addDummyCell(gridAfter, false, true);
        }
    }

    private Node getTc(Node wtrNode, int wanted, IntRef current) {
        for (int i = 0; i < wtrNode.getChildNodes().getLength(); ++i) {
            Node thisChild = wtrNode.getChildNodes().item(i);
            if (thisChild.getNodeType() != 1) continue;
            log.debug("Looking at " + thisChild.getLocalName() + "; have encountered " + current.i);
            if (thisChild.getLocalName().equals("tc")) {
                if (current.i == wanted) {
                    return thisChild;
                }
                current.increment();
                continue;
            }
            Node n = this.getTc(thisChild, wanted, current);
            if (n == null) continue;
            return n;
        }
        log.error("Couldn't find tc in: " + XmlUtils.w3CDomNodeToString(wtrNode));
        return null;
    }

    static class IntRef {
        int i;

        IntRef(int i) {
            this.i = i;
        }

        void increment() {
            ++this.i;
        }
    }
}

