/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.packages.Filetype;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.DefaultXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.OleObjectBinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaDataPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.samples.AbstractSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PartsList
extends AbstractSample {
    private static Logger log = LoggerFactory.getLogger(PartsList.class);
    public static HashMap<Part, Part> handled = new HashMap();

    public static void main(String[] args) throws Exception {
        boolean printContentTypes = true;
        try {
            PartsList.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/chart.docx";
        }
        OpcPackage opcPackage = OpcPackage.load(new File(inputfilepath), Filetype.ZippedPackage);
        PartsList.handlePkg(opcPackage, printContentTypes);
    }

    public static void handlePkg(OpcPackage opcPackage, boolean printContentTypes) {
        if (printContentTypes) {
            PartsList.printContentTypes(opcPackage);
        }
        RelationshipsPart rp = opcPackage.getRelationshipsPart();
        StringBuilder sb = new StringBuilder();
        PartsList.printInfo(rp.getPartName().getName(), null, rp, sb, "");
        PartsList.traverseRelationships(opcPackage, rp, sb, "    ");
        System.out.println(sb.toString());
    }

    public static void printContentTypes(OpcPackage p) {
        ContentTypeManager ctm = p.getContentTypeManager();
        System.out.println(ctm.toString());
    }

    public static void printInfo(String parentName, Relationship r, Part p, StringBuilder sb, String indent) {
        block18: {
            String relationshipType = "";
            if (p.getSourceRelationships().size() > 0) {
                relationshipType = p.getSourceRelationships().get(0).getType();
            }
            if (r == null) {
                sb.append("\n" + indent + "Part " + p.getPartName() + " [" + p.getClass().getName() + "] " + relationshipType);
            } else {
                sb.append("\n" + indent + parentName + "'s " + r.getId() + " is " + p.getPartName() + " [" + p.getClass().getName() + "] " + relationshipType);
            }
            if (p instanceof JaxbXmlPart) {
                Object o = ((JaxbXmlPart)p).getJaxbElement();
                if (o instanceof JAXBElement) {
                    sb.append(" containing JaxbElement:" + XmlUtils.JAXBElementDebug((JAXBElement)o));
                } else {
                    sb.append(" containing:" + o.getClass().getName());
                }
            } else if (p instanceof DefaultXmlPart) {
                try {
                    Document doc = ((DefaultXmlPart)p).getDocument();
                    try {
                        Object o = XmlUtils.unmarshal(doc);
                        if (o instanceof JAXBElement) {
                            sb.append(" containing JaxbElement:" + XmlUtils.JAXBElementDebug((JAXBElement)o));
                            break block18;
                        }
                        sb.append(" containing:" + o.getClass().getName());
                    }
                    catch (UnmarshalException e) {
                        sb.append(" containing raw root element:" + doc.getDocumentElement().getLocalName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (p instanceof OleObjectBinaryPart) {
            try {
                ((OleObjectBinaryPart)p).viewFile(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (p instanceof VbaDataPart) {
            System.out.println(((VbaDataPart)p).getXML());
        }
        if (p instanceof FontTablePart) {
            ((FontTablePart)p).processEmbeddings();
        }
    }

    public static void traverseRelationships(OpcPackage wordMLPackage, RelationshipsPart rp, StringBuilder sb, String indent) {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.info("\nFor Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget() + " type " + r.getType() + "\n");
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                sb.append("\n" + indent + "external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            Part part = rp.getPart(r);
            PartsList.printInfo(rp.getSourceP().getPartName().getName(), r, part, sb, indent);
            if (handled.get(part) != null) {
                sb.append(" [additional reference] ");
                continue;
            }
            handled.put(part, part);
            if (part.getRelationshipsPart(false) == null) continue;
            PartsList.traverseRelationships(wordMLPackage, part.getRelationshipsPart(false), sb, indent + "    ");
        }
    }
}

