/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.qubership.atp.ei.ntt.controllers.ModelItemController;
import org.qubership.atp.ei.ntt.converter.ConverterConstants;
import org.qubership.atp.ei.ntt.converter.MiAppendMethod;
import org.qubership.atp.ei.ntt.converter.ModelItemTextConverter;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.Reference;
import org.qubership.atp.ei.ntt.model.ScopeItem;
import org.qubership.atp.ei.ntt.model.TemplateProject;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.enums.ModelItemType;
import org.qubership.atp.ei.ntt.utils.NttModelLoader;

public class TextToMiConverter {
    private static ModelItemController MIC = ModelItemController.getInstance();
    private static NttModelLoader WSC = NttModelLoader.getInstance();
    private ModelItem parent;
    private int sizeDiff;
    private ModelItem[] structure;
    private List<ModelItem> children;
    private MiAppendMethod appendMethod;
    private boolean mayContainReference = false;
    private ModelItemTextConverter converter;
    private MiAppendMethod appendToTemplatesProj = new MiAppendMethod(){

        @Override
        public void append(String line, String flags, boolean isEnabled) {
            ModelItemType tempMiEnum;
            boolean isTemplate = false;
            ModelItemType modelItemType = TextToMiConverter.this.getMiEnum(line);
            if (line.startsWith("Template_") && !(tempMiEnum = TextToMiConverter.this.getMiEnum(line.substring("Template_".length()))).isLeaf()) {
                line = line.substring("Template_".length());
                modelItemType = tempMiEnum;
                isTemplate = true;
            }
            line = line.substring(TextToMiConverter.this.converter.getPrefix(modelItemType).length());
            if (TextToMiConverter.this.parent.getModelItemType().ordinal() >= modelItemType.ordinal()) {
                modelItemType = TextToMiConverter.this.parent.getModelItemType().next();
            }
            if (!(isTemplate || TextToMiConverter.this.structure[0] != null && TextToMiConverter.this.structure[0].getModelItemType().ordinal() < modelItemType.ordinal())) {
                if (!modelItemType.isLeaf()) {
                    isTemplate = true;
                } else {
                    TextToMiConverter.this.createMi(modelItemType.previous(), modelItemType.previous().getName() + ".auto", "", true, true);
                }
            }
            TextToMiConverter.this.createMi(modelItemType, line, flags, isTemplate, isEnabled);
        }

        @Override
        public void addNode(ModelItemType modelItemType, ModelItem modelItem, boolean isTemplate, boolean isReference) {
            int index = 0;
            if (!isTemplate) {
                index = modelItemType.ordinal() - TextToMiConverter.this.structure[0].getModelItemType().ordinal();
            }
            TextToMiConverter.this.addNode(modelItemType, modelItem, index);
        }
    };
    private MiAppendMethod regularTree = new MiAppendMethod(){
        private ModelItemType currentReference = null;

        @Override
        public void append(String line, String flags, boolean isEnabled) {
            ModelItemType modelItemType = TextToMiConverter.this.getMiEnum(line);
            if (!modelItemType.isLeaf()) {
                line = line.substring(TextToMiConverter.this.converter.getPrefix(modelItemType).length());
                if (TextToMiConverter.this.parent.getModelItemType().ordinal() >= modelItemType.ordinal()) {
                    modelItemType = TextToMiConverter.this.parent.getModelItemType().next();
                }
                if (TextToMiConverter.this.mayContainReference && line.startsWith("Template_") && this.canItBeReference(modelItemType)) {
                    int delimIndex;
                    int nameBeginIndex;
                    String refLine = line.substring("Template_".length());
                    String name = "";
                    int nameLastIndex = refLine.lastIndexOf("\"");
                    if (nameLastIndex != -1 && (nameBeginIndex = refLine.substring(0, nameLastIndex).lastIndexOf("\"")) != -1) {
                        name = refLine.substring(nameBeginIndex + 1, nameLastIndex);
                        refLine = refLine.substring(0, nameBeginIndex);
                    }
                    if ((delimIndex = refLine.indexOf("\\")) != -1) {
                        String templProjName = refLine.substring(0, delimIndex);
                        String templName = refLine.substring(templProjName.length() + 1);
                        TextToMiConverter.this.createReference(modelItemType, templProjName, templName.trim(), name, flags, isEnabled);
                        return;
                    }
                }
            }
            if (this.currentReference == null || modelItemType.ordinal() <= this.currentReference.ordinal()) {
                TextToMiConverter.this.createMi(modelItemType, line, flags, false, isEnabled);
            }
        }

        @Override
        public void addNode(ModelItemType modelItemType, ModelItem modelItem, boolean isTemplate, boolean isReference) {
            int index = modelItemType.ordinal() - TextToMiConverter.this.sizeDiff;
            TextToMiConverter.this.addNode(modelItemType, modelItem, index);
            if (isReference) {
                this.currentReference = modelItemType;
            } else if (this.currentReference != null && modelItemType.ordinal() <= this.currentReference.ordinal()) {
                this.currentReference = null;
            }
        }

        private boolean canItBeReference(ModelItemType miEnum) {
            if (this.currentReference != null) {
                return miEnum.ordinal() <= this.currentReference.ordinal();
            }
            return true;
        }
    };

    TextToMiConverter(ModelItemTextConverter converter, ModelItem parent, boolean isTemplatesTree) {
        this.converter = converter;
        this.sizeDiff = parent.getModelItemType().ordinal() + 1;
        this.structure = new ModelItem[ModelItemType.values().length - this.sizeDiff];
        this.children = new ArrayList<ModelItem>();
        this.parent = parent;
        if (!(isTemplatesTree || parent instanceof Reference || parent.isTemplate())) {
            this.mayContainReference = true;
        }
        this.appendMethod = parent instanceof TemplateProject ? this.appendToTemplatesProj : this.regularTree;
    }

    public void appendMi(String line) {
        boolean isEnabled = true;
        if (line.startsWith("//")) {
            isEnabled = false;
            line = line.substring("//".length()).trim();
        } else if (line.startsWith("!--")) {
            isEnabled = false;
            line = line.substring("!--".length()).trim();
        }
        if (line.isEmpty()) {
            return;
        }
        String[] str = this.getFlags(line.trim());
        line = str[0];
        String flags = str[1];
        this.appendMethod.append(line, flags, isEnabled);
    }

    public void flush() {
        if (this.structure[0] != null) {
            this.children.add(this.structure[0]);
        }
        MIC.clear(this.parent, new Object[0]);
        if (!this.children.isEmpty()) {
            WSC.addNode(this.parent, this.children.toArray(new TreeNode[this.children.size()]), new Object[0]);
            this.createScopeChanges();
        }
        if (this.appendMethod == this.appendToTemplatesProj) {
            WSC.clearReferences();
        }
    }

    private void createScopeChanges() {
        Iterator mapIterator = ModelItemTextConverter.getChangesMapForScope().keySet().iterator();
        while (mapIterator.hasNext()) {
            if (((ModelItem)mapIterator.next()).getModelItemType().ordinal() < this.children.get(0).getModelItemType().ordinal()) continue;
            mapIterator.remove();
        }
        List<ScopeItem> items = WSC.getScope().getScopeItems();
        for (ScopeItem item : items) {
            TreeNode parent = item.getModelItem();
            if (parent == null) continue;
            if (parent.getModelItemType().ordinal() < this.children.get(0).getModelItemType().ordinal()) {
                return;
            }
            ArrayList<String> path = new ArrayList<String>();
            do {
                path.add(parent.getName());
            } while ((parent = parent.getParent()) != null && parent.getModelItemType().ordinal() >= this.children.get(0).getModelItemType().ordinal());
            TreeNode found = this.getTnByPath(path, new ArrayList<TreeNode>(this.children));
            if (found == null) continue;
            ModelItemTextConverter.getChangesMapForScope().put((Object)item.getModelItem(), (Object)found);
        }
    }

    private TreeNode getTnByPath(List<String> path, List<TreeNode> where) {
        for (int j = 0; j < where.size(); ++j) {
            TreeNode current = where.get(j);
            if (!current.getName().equals(path.get(path.size() - 1))) continue;
            path.remove(path.size() - 1);
            return path.isEmpty() ? where.get(j) : this.getTnByPath(path, where.get(j).getChildren());
        }
        return null;
    }

    private String[] getFlags(String line) {
        Matcher m = ConverterConstants.FLAGS.matcher(line);
        String flags = "";
        if (m.matches()) {
            flags = m.group(2);
            line = m.group(1);
        }
        return new String[]{line, flags.trim()};
    }

    private ModelItemType getMiEnum(String lineWithPrefix) {
        for (int i = 0; i < ConverterConstants.PREFIXES.length; ++i) {
            if (!lineWithPrefix.startsWith(ConverterConstants.PREFIXES[i])) continue;
            return ModelItemType.values()[i];
        }
        return ModelItemType.ACTION;
    }

    private void setFlags(ModelItem item, String flags) {
        if (flags.isEmpty()) {
            return;
        }
        for (String s : flags.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            item.setFlag(s, true);
        }
    }

    private ModelItem createReference(ModelItemType modelItemType, String templProjName, String templName, String name, String flags, boolean isEnabled) {
        Reference ref = WSC.createReference(name, modelItemType, templProjName, templName);
        ref.setEnabled(isEnabled);
        this.setFlags(ref, flags);
        this.appendMethod.addNode(modelItemType, ref, false, true);
        return ref;
    }

    private void addNode(ModelItemType modelItemType, ModelItem modelItem, int index) {
        if (index == 0) {
            if (this.structure[0] != null) {
                this.children.add(this.structure[0]);
            }
        } else {
            int parentIndex = index - 1;
            if (this.structure[parentIndex] == null) {
                this.createMi(modelItemType.previous(), modelItemType.previous().getName() + ".auto", "", false, true);
            }
            this.structure[parentIndex].getChildren().add(modelItem);
            modelItem.setParent(this.structure[parentIndex]);
        }
        this.structure[index] = modelItem;
        for (int i = index + 1; i < this.structure.length; ++i) {
            this.structure[i] = null;
        }
    }

    private ModelItem createMi(ModelItemType modelItemType, String name, String flags, boolean isTemplate, boolean isEnabled) {
        ModelItem modelItem;
        if (modelItemType.isLeaf()) {
            modelItem = WSC.createTestAction(name, name);
        } else {
            modelItem = MIC.createSomeThing(modelItemType.getInterface(), name, new Object[0]);
            if (isTemplate) {
                modelItem = WSC.createTemplate(modelItem);
            }
        }
        modelItem.setEnabled(isEnabled);
        this.setFlags(modelItem, flags);
        this.appendMethod.addNode(modelItemType, modelItem, isTemplate, false);
        return modelItem;
    }
}

