/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.ei.ntt.ExportConverter;
import org.qubership.atp.ei.ntt.controllers.DataSetController;
import org.qubership.atp.ei.ntt.controllers.ModelItemController;
import org.qubership.atp.ei.ntt.dto.Action;
import org.qubership.atp.ei.ntt.dto.ActionParameter;
import org.qubership.atp.ei.ntt.dto.Compound;
import org.qubership.atp.ei.ntt.dto.Connection;
import org.qubership.atp.ei.ntt.dto.DataSetAttribute;
import org.qubership.atp.ei.ntt.dto.DataSetAttributeKey;
import org.qubership.atp.ei.ntt.dto.DataSetList;
import org.qubership.atp.ei.ntt.dto.DataSetListValue;
import org.qubership.atp.ei.ntt.dto.DataSetParameter;
import org.qubership.atp.ei.ntt.dto.Environment;
import org.qubership.atp.ei.ntt.dto.FileData;
import org.qubership.atp.ei.ntt.dto.MetaInfo;
import org.qubership.atp.ei.ntt.dto.System;
import org.qubership.atp.ei.ntt.dto.TestCase;
import org.qubership.atp.ei.ntt.dto.TestCaseDependency;
import org.qubership.atp.ei.ntt.dto.TestCaseFlags;
import org.qubership.atp.ei.ntt.dto.TestScenario;
import org.qubership.atp.ei.ntt.dto.TestScope;
import org.qubership.atp.ei.ntt.dto.enums.DirectiveEnum;
import org.qubership.atp.ei.ntt.dto.enums.Flags;
import org.qubership.atp.ei.ntt.impl.NttExportConverterResult;
import org.qubership.atp.ei.ntt.impl.NttExportScope;
import org.qubership.atp.ei.ntt.model.ContextVariable;
import org.qubership.atp.ei.ntt.model.DataSet;
import org.qubership.atp.ei.ntt.model.NttTestCase;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.ScopeItem;
import org.qubership.atp.ei.ntt.model.TestAction;
import org.qubership.atp.ei.ntt.model.TestStep;
import org.qubership.atp.ei.ntt.model.TestSuite;
import org.qubership.atp.ei.ntt.model.enums.ScopeSectionType;
import org.qubership.atp.ei.ntt.model.impl.ContextVariableImpl;
import org.qubership.atp.ei.ntt.model.impl.ProjectModel;
import org.qubership.atp.ei.ntt.model.impl.ScopeItemModel;
import org.qubership.atp.ei.ntt.model.impl.ScopeModel;
import org.qubership.atp.ei.ntt.model.impl.WorkspaceModel;
import org.qubership.atp.ei.ntt.settings.model.dal.SettingsResource;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentItemLinkDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentItemLinksSectionDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentListDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentListsSectionDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServerDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServerTypesDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServersSettingsDal;
import org.qubership.atp.ei.ntt.utils.CommonUtils;
import org.qubership.atp.ei.ntt.utils.DependenceTransformer;
import org.qubership.atp.ei.ntt.utils.NttModelLoader;
import org.qubership.atp.ei.ntt.utils.VariablesCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NttProjectConverter
implements ExportConverter {
    private static final Logger log = LoggerFactory.getLogger(NttProjectConverter.class);
    private static final Map<String, String> atp2NttFlagMaps = new HashMap<String, String>();
    private static final UUID SSH_CONNECTION_ID = UUID.fromString("24136d83-5ffb-487f-9bb4-e73be3a89aa2");
    private static final UUID DB_CONNECTION_ID = UUID.fromString("46ca25d6-058e-471a-9b5e-c13e4b481227");
    private static final UUID HTTP_CONNECTION_ID = UUID.fromString("2a0eab16-0fe7-4a12-8155-78c0c151abdf");
    private static Map<String, String> macroRegexReplacement = new HashMap<String, String>();
    private final ObjectMapper objectMapper;
    private final ModelItemController modelItemController;
    private final NttModelLoader nttActionsCreator;
    private final WorkspaceModel nttWorkspaceModel;
    private final VariablesCompiler variablesCompiler;
    private NttExportScope nttScopeMaps;
    private Path modelLocationPath;
    private Path rootForFiles;

    public NttProjectConverter(Path modelLocationPath) {
        WorkspaceModel.reset();
        this.nttWorkspaceModel = WorkspaceModel.getInstance();
        this.modelItemController = ModelItemController.getInstance();
        this.nttActionsCreator = NttModelLoader.getInstance();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.variablesCompiler = new VariablesCompiler();
        this.nttScopeMaps = new NttExportScope();
        this.modelLocationPath = modelLocationPath;
        this.rootForFiles = modelLocationPath.resolve("files");
    }

    private void createScopesForExistingScopes() {
        log.debug("start createScopesForExistingScopes()");
        List<UUID> scopeIds = this.nttScopeMaps.getNttTestSuite2atpTestScope().values().stream().distinct().collect(Collectors.toList());
        scopeIds.forEach(atpScopeId -> {
            log.trace("loop scopeIds: {}", atpScopeId);
            TestScope atpScope = this.loadObject((UUID)atpScopeId, (Class)TestScope.class);
            ScopeModel scope = new ScopeModel();
            String scopeName = atpScope.getName();
            scope.setName(this.getSafeProjectName(scopeName));
            this.nttScopeMaps.getNttScopes().add(scope);
            HashMap<UUID, ScopeItem> testCase2ScopeItems = new HashMap<UUID, ScopeItem>();
            HashMap<UUID, HashSet<UUID>> dependenciesGraph = new HashMap<UUID, HashSet<UUID>>();
            List<TestSuite> testSuites = this.nttScopeMaps.getNttTestSuite2atpTestScope().entrySet().stream().filter(testSuiteIdEntry -> ((UUID)testSuiteIdEntry.getValue()).equals(atpScopeId)).map(Map.Entry::getKey).collect(Collectors.toList());
            ArrayList testCases0 = new ArrayList();
            testSuites.forEach(testSuite1 -> testCases0.addAll(testSuite1.getTestCases()));
            for (NttTestCase nttTestCase : testCases0) {
                this.buildScopeItem(atpScope, nttTestCase, testCase2ScopeItems, dependenciesGraph);
            }
            Map<UUID, UUID> singleDependencyGraph = new DependenceTransformer().transform(dependenciesGraph);
            for (Map.Entry<UUID, UUID> dependency : singleDependencyGraph.entrySet()) {
                if (dependency.getValue() == null) continue;
                ScopeItem scopeItem1 = (ScopeItem)testCase2ScopeItems.get(dependency.getKey());
                ScopeItem scopeItem2 = (ScopeItem)testCase2ScopeItems.get(dependency.getValue());
                scopeItem1.setDependency(scopeItem2);
            }
            scope.setScopeItems(new ArrayList<ScopeItem>(testCase2ScopeItems.values()));
        });
        log.debug("end createScopesForExistingScopes()");
    }

    private void buildScopeItem(TestScope atpScope, NttTestCase testCase, Map<UUID, ScopeItem> testCase2ScopeItems, Map<UUID, HashSet<UUID>> dependenciesGraph) {
        UUID atpTestCaseId = this.nttScopeMaps.getNttTestCase2atpTestCase().get(testCase);
        ScopeItem scopeItem = this.buildScopeItem(atpTestCaseId, testCase);
        ScopeSectionType scopeSectionType = ScopeSectionType.ACTIONS;
        if (atpScope.getPrerequisitesCases() != null && atpScope.getPrerequisitesCases().contains(atpTestCaseId)) {
            scopeSectionType = ScopeSectionType.PREREQUISITES;
        } else if (atpScope.getValidationCases() != null && atpScope.getValidationCases().contains(atpTestCaseId)) {
            scopeSectionType = ScopeSectionType.VALIDATION;
        }
        scopeItem.setStage(scopeSectionType);
        UUID testCaseId = atpTestCaseId;
        testCase2ScopeItems.put(testCaseId, scopeItem);
        HashSet dependsOn = new HashSet();
        List<TestCaseDependency> atpDependsOn = this.loadObject(atpTestCaseId, TestCase.class).getDependsOn();
        if (atpDependsOn != null) {
            UUID atpScopeId = atpScope.getUuid();
            atpDependsOn.stream().filter(testCaseDependency -> testCaseDependency.getTestScopeId().equals(atpScopeId)).forEach(testCaseDependency -> dependsOn.add(testCaseDependency.getTestCaseId()));
        }
        dependenciesGraph.put(testCaseId, new HashSet(dependsOn));
    }

    private ScopeItem buildScopeItem(UUID atpTestCaseId, NttTestCase testCase) {
        UUID dataSetId = this.loadObject(atpTestCaseId, TestCase.class).getDatasetUuid();
        DataSet dataSet = this.nttScopeMaps.getDataSet2NttDataSetMap().get(dataSetId);
        return new ScopeItemModel(testCase, dataSet);
    }

    private void extractFlagsForSuites() {
        log.debug("start extractFlagsForSuites()");
        this.nttScopeMaps.getNttTestSuite2atpTestScope().forEach((testSuite, atpScopeId) -> {
            ArrayList flags = new ArrayList();
            List<Flags> atpFlags = this.loadObject((UUID)atpScopeId, (Class)TestScope.class).getFlags();
            if (atpFlags != null) {
                atpFlags.forEach(flag -> flags.add(flag.getName()));
            }
            for (String flag2 : flags) {
                String nttFlag = atp2NttFlagMaps.get(flag2.toLowerCase());
                if (nttFlag == null) continue;
                testSuite.setFlag(nttFlag);
            }
        });
        log.debug("end extractFlagsForSuites()");
    }

    private void exportTestCases() {
        log.debug("start exportTestCases()");
        this.nttScopeMaps.getNttTestCase2atpTestCase().forEach((testCase, testCaseId) -> this.exportTestCase((UUID)testCaseId, (NttTestCase)testCase));
        log.debug("end exportTestCases()");
    }

    private void extractFlagsForTestCases() throws Exception {
        log.debug("start extractFlagsForTestCases()");
        List<UUID> cases = this.getListOfObjects(TestCase.class, new UUID[0]);
        cases.forEach(testCaseId -> {
            List<TestCaseFlags> atpFlags = this.loadObject((UUID)testCaseId, (Class)TestCase.class).getFlags();
            if (atpFlags != null) {
                atpFlags.stream().forEach(testCaseFlags -> {
                    UUID scopeId = testCaseFlags.getTestScopeId();
                    if (!this.nttScopeMaps.getNttTestSuite2atpTestScope().values().contains(scopeId)) {
                        return;
                    }
                    ArrayList flags = new ArrayList();
                    if (testCaseFlags.getFlags() != null) {
                        testCaseFlags.getFlags().forEach(flag1 -> flags.add(flag1.getName()));
                    }
                    ArrayList listOfSuites = new ArrayList();
                    this.nttScopeMaps.getNttTestSuite2atpTestScope().entrySet().stream().filter(testSuiteUUIDEntry -> scopeId.equals(testSuiteUUIDEntry.getValue())).forEach(testSuiteUUIDEntry -> listOfSuites.add((TestSuite)testSuiteUUIDEntry.getKey()));
                    NttTestCase nttTestCase = (NttTestCase)this.nttScopeMaps.getNttTestCase2atpTestCase().entrySet().stream().filter(testCaseUUIDEntry -> listOfSuites.contains(((NttTestCase)testCaseUUIDEntry.getKey()).getParent())).findFirst().get().getKey();
                    for (String flag : flags) {
                        String nttFlag = atp2NttFlagMaps.get(flag.toLowerCase());
                        if (nttFlag == null) continue;
                        nttTestCase.setFlag(nttFlag);
                    }
                });
            }
        });
        log.debug("end extractFlagsForTestCases()");
    }

    private String replaceAtpMacrosToNtt(String step) {
        if (step == null) {
            return step;
        }
        String result = step;
        for (Map.Entry<String, String> entry : macroRegexReplacement.entrySet()) {
            result = result.replaceAll(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private NttTestCase exportTestCase(UUID testCaseId, NttTestCase nttTestCase) {
        log.debug("start exportTestCases(testCaseId: {}, nttTestCase: {})", (Object)testCaseId, (Object)nttTestCase);
        UUID testScenarioId = this.loadObject(testCaseId, TestCase.class).getTestScenarioUuid();
        List<MetaInfo> steps = this.loadObject(testScenarioId, TestScenario.class).getMetainfo();
        if (steps == null) {
            return nttTestCase;
        }
        List<TestStep> nttTestSteps = nttTestCase.getTestSteps();
        ArrayList<String> flags = new ArrayList<String>();
        ArrayList<TestAction> directiveActions = new ArrayList<TestAction>();
        for (MetaInfo step : steps) {
            String stepText;
            TestStep nttTestStep = null;
            if (MetaInfo.Type.FLAG == step.getType()) {
                flags.add(this.getFlagText(step));
            } else if (MetaInfo.Type.DIRECTIVE == step.getType()) {
                TestAction directiveAction = this.handleDirectiveAsAction(step, flags);
                if (directiveAction != null) {
                    directiveActions.add(directiveAction);
                }
            } else if (MetaInfo.Type.ACTION == step.getType()) {
                stepText = this.getActionText(step);
                nttTestStep = this.modelItemController.create(TestStep.class, stepText, new Object[0]);
                String finalValue = this.replaceAtpMacrosToNtt(stepText);
                TestAction nttTestAction = this.nttActionsCreator.createTestAction(finalValue, null);
                List nttActions = nttTestStep.getActions();
                nttActions.addAll(directiveActions);
                directiveActions.clear();
                nttActions.add(nttTestAction);
            } else if (MetaInfo.Type.COMPOUND == step.getType()) {
                stepText = this.getCompoundText(step);
                nttTestStep = this.modelItemController.create(TestStep.class, stepText, new Object[0]);
                List<TestAction> compoundActions = this.compounds(step, 1);
                List nttActions = nttTestStep.getActions();
                nttActions.addAll(directiveActions);
                directiveActions.clear();
                nttActions.addAll(compoundActions);
            } else {
                if (!StringUtils.isNotEmpty((String)step.getOtherTextValue())) continue;
                nttTestStep = this.modelItemController.create(TestStep.class, step.getOtherTextValue(), new Object[0]);
            }
            if (MetaInfo.Type.ACTION == step.getType() || MetaInfo.Type.COMPOUND == step.getType()) {
                for (String flag : flags) {
                    nttTestStep.setFlag(flag);
                }
                flags.clear();
            }
            if (nttTestStep == null) continue;
            nttTestSteps.add(nttTestStep);
        }
        log.debug("end exportTestCases(..): {}", (Object)nttTestCase);
        return nttTestCase;
    }

    private TestAction getUseDirectiveAction(MetaInfo step) {
        ArrayList<String> useDirective = this.getDirectiveValues(step);
        String directiveStr = this.convertUseDirectiveToActionSwitch(useDirective);
        if (directiveStr == null) {
            directiveStr = "//@Use(" + useDirective + ")";
        }
        return this.nttActionsCreator.createTestAction(directiveStr, null);
    }

    private String getFlagByDirectiveName(String directiveName) {
        if (directiveName == null) {
            return null;
        }
        return atp2NttFlagMaps.get(directiveName.replace("@", "").replace("_", " ").toLowerCase());
    }

    private String getActionText(MetaInfo step) {
        UUID actionId = step.getStepId();
        Action action = this.loadObject(actionId, Action.class);
        action.setParameters(step.getParameters());
        Action result = this.variablesCompiler.precompileStringParameters(action);
        return result.getName();
    }

    private String getCompoundText(MetaInfo step) {
        UUID actionId = step.getStepId();
        Compound compound = this.loadObject(actionId, Compound.class);
        Action action = new Action();
        action.setParameters(step.getParameters());
        action.setName(compound.getName());
        Action result = new VariablesCompiler().precompileStringParameters(action);
        return result.getName();
    }

    private ArrayList<String> getDirectiveValues(MetaInfo step) {
        List<ActionParameter> params = step.getParameters();
        ArrayList<String> values = new ArrayList<String>();
        if (params == null || params.isEmpty()) {
            return values;
        }
        params.stream().filter(actionParameter -> "value".equals(actionParameter.getName())).forEach(actionParameter -> values.add(actionParameter.getValue()));
        return values;
    }

    private String getFlagText(MetaInfo step) {
        return step.toString();
    }

    private boolean isUseDirective(MetaInfo step) {
        return DirectiveEnum.USE.getId().equals(step.getStepId());
    }

    private String getSafeProjectName(String name) {
        return CommonUtils.getSafeFilename(name);
    }

    private String convertUseDirectiveToActionSwitch(ArrayList<String> useDirectiveValues) {
        String actionText = null;
        if (useDirectiveValues != null && !useDirectiveValues.isEmpty()) {
            actionText = String.format("Switch to \"%s\" server", useDirectiveValues.get(0));
        }
        return actionText;
    }

    private List<TestAction> compounds(MetaInfo step, int level) {
        ArrayList<TestAction> resultActions = new ArrayList<TestAction>();
        Compound compound = this.loadObject(step.getStepId(), Compound.class);
        Map<String, Object> context = this.getCompoundContext(step);
        List<MetaInfo> subTestSteps = compound.getMetainfo();
        for (MetaInfo subStep : subTestSteps) {
            TestAction subTestAction;
            String finalValue;
            String subStepFinalValue;
            if (MetaInfo.Type.FLAG == subStep.getType()) {
                String flag = this.getFlagText(subStep);
                TestAction subTestAction2 = this.nttActionsCreator.createTestAction("//" + flag, null);
                resultActions.add(subTestAction2);
                continue;
            }
            if (MetaInfo.Type.DIRECTIVE == subStep.getType()) {
                TestAction directiveAction = this.handleDirectiveAsAction(subStep, null);
                if (directiveAction == null) continue;
                resultActions.add(directiveAction);
                continue;
            }
            if (MetaInfo.Type.ACTION == subStep.getType()) {
                subStepFinalValue = this.getActionText(subStep);
                subStepFinalValue = this.variablesCompiler.precompileVariables(subStepFinalValue, context);
                finalValue = this.replaceAtpMacrosToNtt(subStepFinalValue);
                subTestAction = this.nttActionsCreator.createTestAction(finalValue, null);
                resultActions.add(subTestAction);
                continue;
            }
            if (MetaInfo.Type.COMPOUND == subStep.getType()) {
                subStep.getParameters().addAll(step.getParameters());
                subStepFinalValue = this.getCompoundText(subStep);
                finalValue = this.replaceAtpMacrosToNtt(subStepFinalValue);
                finalValue = "//{ compound (level " + level + "): " + finalValue;
                subTestAction = this.nttActionsCreator.createTestAction(finalValue, null);
                resultActions.add(subTestAction);
                resultActions.addAll(this.compounds(subStep, level + 1));
                finalValue = "//} compound (level " + level + "): " + subStepFinalValue;
                subTestAction = this.nttActionsCreator.createTestAction(finalValue, null);
                resultActions.add(subTestAction);
                continue;
            }
            TestAction subTestAction3 = this.nttActionsCreator.createTestAction(StringUtils.defaultIfEmpty((String)subStep.getOtherTextValue(), (String)""), null);
            resultActions.add(subTestAction3);
        }
        return resultActions;
    }

    private Map<String, Object> getCompoundContext(MetaInfo step) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        step.getParameters().forEach(parameter -> result.put(parameter.getName(), parameter.getValue()));
        return result;
    }

    private TestAction handleDirectiveAsAction(MetaInfo step, List<String> flags) {
        TestAction directiveAction;
        if (this.isUseDirective(step)) {
            directiveAction = this.getUseDirectiveAction(step);
        } else {
            String flag;
            String directiveName = DirectiveEnum.getNameById(step.getStepId());
            String directiveStr = "// " + directiveName;
            directiveAction = this.nttActionsCreator.createTestAction(directiveStr, null);
            if (flags != null && (flag = this.getFlagByDirectiveName(directiveName)) != null) {
                flags.add(flag);
            }
        }
        return directiveAction;
    }

    private void createSuitesAndTestCases() throws Exception {
        log.debug("start createProjects()");
        HashMap tastCaseToTestSuites = new HashMap();
        List<UUID> scopes = this.getListOfObjects(TestScope.class, new UUID[0]);
        scopes.forEach(testScopeId -> {
            List<UUID> prerequisitesCases;
            List<UUID> validationCases;
            TestScope nttTestScope = this.loadObject((UUID)testScopeId, (Class)TestScope.class);
            List<UUID> executionCases = nttTestScope.getExecutionCases();
            if (executionCases != null) {
                executionCases.forEach(testCaseId -> tastCaseToTestSuites.computeIfAbsent(testCaseId, t -> new ArrayList()).add(testScopeId));
            }
            if ((validationCases = nttTestScope.getValidationCases()) != null) {
                validationCases.forEach(testCaseId -> tastCaseToTestSuites.computeIfAbsent(testCaseId, t -> new ArrayList()).add(testScopeId));
            }
            if ((prerequisitesCases = nttTestScope.getPrerequisitesCases()) != null) {
                prerequisitesCases.forEach(testCaseId -> tastCaseToTestSuites.computeIfAbsent(testCaseId, t -> new ArrayList()).add(testScopeId));
            }
        });
        List<UUID> cases = this.getListOfObjects(TestCase.class, new UUID[0]);
        cases.forEach(testCaseId -> {
            TestCase atpTestCase = this.loadObject((UUID)testCaseId, (Class)TestCase.class);
            UUID atpDataSetListId = atpTestCase.getDatasetStorageUuid();
            Project project = this.nttScopeMaps.getDataSetList2NttProjectMap().get(atpDataSetListId);
            if (project == null) {
                project = this.nttScopeMaps.getDataSetList2NttProjectMap().get(null);
            }
            List<TestSuite> nttTestSuites = project.getTestSuites();
            List testSuiteIds = (List)tastCaseToTestSuites.get(testCaseId);
            Map atp2NttSuitesMap = this.nttScopeMaps.getProject2NttSuitesMap().computeIfAbsent(atpDataSetListId, k -> new HashMap());
            if (testSuiteIds == null || testSuiteIds.isEmpty()) {
                TestSuite nttSuite = (TestSuite)atp2NttSuitesMap.get(null);
                if (nttSuite == null) {
                    nttSuite = this.modelItemController.create(TestSuite.class, "Single Test Cases", new Object[0]);
                    nttTestSuites.add(nttSuite);
                    atp2NttSuitesMap.put(null, nttSuite);
                    nttSuite.setParent(project);
                }
                String name = atpTestCase.getName();
                NttTestCase nttTestCase = this.modelItemController.create(NttTestCase.class, name, new Object[0]);
                List<NttTestCase> nttSuiteTestCases = nttSuite.getTestCases();
                nttSuiteTestCases.add(nttTestCase);
                nttTestCase.setParent(nttSuite);
                this.nttScopeMaps.getNttTestCase2atpTestCase().put(nttTestCase, (UUID)testCaseId);
            } else {
                for (UUID testSuiteId : testSuiteIds) {
                    TestSuite nttSuite = (TestSuite)atp2NttSuitesMap.get(testSuiteId);
                    if (nttSuite == null) {
                        TestScope testSuite = this.loadObject(testSuiteId, TestScope.class);
                        nttSuite = this.modelItemController.create(TestSuite.class, testSuite.getName(), new Object[0]);
                        nttTestSuites.add(nttSuite);
                        atp2NttSuitesMap.put(testSuiteId, nttSuite);
                        nttSuite.setParent(project);
                        this.nttScopeMaps.getNttTestSuite2atpTestScope().put(nttSuite, testSuiteId);
                    }
                    String name = atpTestCase.getName();
                    NttTestCase nttTestCase = this.modelItemController.create(NttTestCase.class, name, new Object[0]);
                    List<NttTestCase> nttSuiteTestCases = nttSuite.getTestCases();
                    nttSuiteTestCases.add(nttTestCase);
                    nttTestCase.setParent(nttSuite);
                    this.nttScopeMaps.getNttTestCase2atpTestCase().put(nttTestCase, (UUID)testCaseId);
                }
            }
        });
        log.debug("end createProjects()");
    }

    private void insertVariablesInNttDataSets() {
        List<UUID> parameters = this.getListOfObjects(DataSetParameter.class, new UUID[0]);
        ArrayList dataSetReferenceParameters = new ArrayList();
        parameters.forEach(id -> {
            DataSetParameter parameter = this.loadObject((UUID)id, (Class)DataSetParameter.class);
            UUID dataSetId = parameter.getDataSet();
            DataSet nttDataSet = this.nttScopeMaps.getDataSet2NttDataSetMap().get(dataSetId);
            if (nttDataSet == null) {
                return;
            }
            UUID attrId = parameter.getAttribute();
            DataSetAttribute attribute = this.getAttribute(attrId);
            if (4 == attribute.getAttributeType()) {
                dataSetReferenceParameters.add(parameter);
                return;
            }
            this.addValueInNttDataSet(nttDataSet, attribute, parameter);
        });
        dataSetReferenceParameters.forEach(dataSetReferenceParameter -> {
            UUID dataSet = dataSetReferenceParameter.getDataSet();
            if (dataSet == null) {
                return;
            }
            DataSet nttDataSet = this.nttScopeMaps.getDataSet2NttDataSetMap().get(dataSet);
            if (nttDataSet == null || dataSetReferenceParameter.getDataSetReferenceValue() == null) {
                return;
            }
            List<UUID> parameters2 = this.getListOfObjects(DataSetParameter.class, dataSetReferenceParameter.getDataSetReferenceValue());
            UUID dataSetReferenceAttributeId = dataSetReferenceParameter.getAttribute();
            DataSetAttribute dataSetReferenceAttribute = this.getAttribute(dataSetReferenceAttributeId);
            parameters2.forEach(id0 -> {
                DataSetParameter parameter = this.loadObject((UUID)id0, (Class)DataSetParameter.class);
                UUID attrId = parameter.getAttribute();
                DataSetAttribute attribute = this.getAttribute(attrId);
                attribute.setName(dataSetReferenceAttribute.getName() + "." + attribute.getName());
                this.addValueInNttDataSet(nttDataSet, attribute, parameter);
            });
        });
    }

    private void addValueInNttDataSet(DataSet nttDataSet, DataSetAttribute attribute, DataSetParameter parameter) {
        Path file;
        ContextVariable variable = nttDataSet.getVariableByName(attribute.getName());
        if (variable != null) {
            return;
        }
        variable = new ContextVariableImpl();
        variable.setName(attribute.getName());
        nttDataSet.getVariables().add(variable);
        if (parameter.getStringValue() != null) {
            variable.setValue(this.replaceAtpMacrosToNtt(parameter.getStringValue()));
        } else if (parameter.getListValue() != null) {
            DataSetListValue listValue = this.loadObject(parameter.getListValue(), DataSetListValue.class);
            variable.setValue(listValue.getText());
        } else if (parameter.getFileValueId() == null && parameter.getDataSetReferenceValue() == null && (file = this.getFileForVariable(parameter.getId())) != null) {
            Path nttPath = file.subpath(this.rootForFiles.getNameCount(), file.getNameCount());
            nttDataSet.getProject().getFiles().put(nttPath, file);
            variable.setValue(Paths.get("./files/", new String[0]).resolve(nttPath).toString());
        }
    }

    private DataSetAttribute getAttribute(UUID attrId) {
        DataSetAttribute attribute = null;
        try {
            attribute = this.loadObject(attrId, DataSetAttribute.class);
        }
        catch (Exception e) {
            DataSetAttributeKey attributeKey = this.loadObject(attrId, DataSetAttributeKey.class);
            attribute = this.loadObject(attributeKey.getAttribute(), DataSetAttribute.class);
            StringBuilder attrKeyName = new StringBuilder();
            List<UUID> keys = this.getPath(attributeKey.getKey());
            keys.forEach(keyId -> {
                DataSetAttribute rootAttribute = this.loadObject((UUID)keyId, (Class)DataSetAttribute.class);
                attrKeyName.append(rootAttribute.getName());
                attrKeyName.append(".");
            });
            attribute.setName(attrKeyName.toString() + attribute.getName());
        }
        return attribute;
    }

    private List<UUID> getPath(String key) {
        String[] splitResult;
        LinkedList<UUID> result = new LinkedList<UUID>();
        for (String splitPart : splitResult = key.split("_")) {
            result.add(UUID.fromString(splitPart));
        }
        return result;
    }

    private <T> List<UUID> getListOfObjects(Class<T> clazz, UUID ... parentIds) {
        String folderName = clazz.getSimpleName();
        Path dirWithObjects = this.getFolderWithObjects(folderName, parentIds);
        return this.getListOfObjectIdByFolder(dirWithObjects);
    }

    private List<UUID> getListOfObjectIdByFolder(Path dirWithObjects) {
        ArrayList<UUID> res = new ArrayList<UUID>();
        if (dirWithObjects == null || !Files.exists(dirWithObjects, new LinkOption[0])) {
            return res;
        }
        try (Stream<Path> result = Files.find(dirWithObjects, 5, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
            result.forEach(path -> res.add(UUID.fromString(path.getFileName().toString().split("\\.")[0])));
        }
        catch (Exception e) {
            log.error("Error on collecting list of objects by files from folder {}", (Object)dirWithObjects, (Object)e);
            return res;
        }
        return res;
    }

    private Path getFolderWithObjects(String folderName, UUID ... parentIds) {
        log.debug("start getFolderWithObjects(folderName: {}, additionalPaths: {})", (Object)folderName, (Object)parentIds);
        Path res = this.modelLocationPath.resolve(folderName);
        if (parentIds != null) {
            for (UUID parentId : parentIds) {
                res = res.resolve(parentId.toString());
            }
        }
        return res;
    }

    private Path getFileForVariable(UUID id) {
        Path fileDataPath;
        try (Stream<Path> stream = Files.find(this.rootForFiles, 5, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().contains(id.toString() + ".json"), new FileVisitOption[0]);){
            fileDataPath = stream.findFirst().orElse(null);
        }
        if (fileDataPath != null) {
            FileData fileData = this.loadFileAsObject(fileDataPath, FileData.class, id);
            return fileDataPath.getParent().resolve(CommonUtils.getIdentifierForFilePath(fileData.getParameterUuid().toString(), id));
        }
        log.debug("File for attribute with id {} not found.", (Object)id);
        return null;
    }

    private void createProjects(Map<UUID, String> dataSetListIdNameMap, Map<UUID, String> dataSetIdNameMap, Map<UUID, UUID> dataSetIdParentIdMap) {
        log.debug("start createProjects(dataSetListIdNameMap: {}, dataSetIdNameMap: {}, dataSetIdParentIdMap: {})", new Object[]{dataSetListIdNameMap, dataSetIdNameMap, dataSetIdParentIdMap});
        for (UUID dataSetListId : dataSetListIdNameMap.keySet()) {
            this.nttScopeMaps.getDataSetList2NttProjectMap().computeIfAbsent(dataSetListId, id -> new ProjectModel(this.getSafeProjectName((String)dataSetListIdNameMap.get(dataSetListId))));
        }
        for (UUID atpDataSetId : dataSetIdParentIdMap.keySet()) {
            UUID dataSetListId = dataSetIdParentIdMap.get(atpDataSetId);
            Project dataSetsProject = this.nttScopeMaps.getDataSetList2NttProjectMap().get(dataSetListId);
            DataSet nttDataSet = DataSetController.getInstance().createEmptyDataSet(dataSetsProject, new Object[0]);
            String atpDataSetName = dataSetIdNameMap.get(atpDataSetId);
            nttDataSet.setName(this.getSafeProjectName(atpDataSetName));
            this.nttScopeMaps.getDataSet2NttDataSetMap().put(atpDataSetId, nttDataSet);
        }
        ProjectModel defaultProject = new ProjectModel("Default Project");
        this.nttScopeMaps.getDataSetList2NttProjectMap().put(null, defaultProject);
        this.nttWorkspaceModel.getProjects().add(defaultProject);
        log.debug("end createProjects(.., .., ..)");
    }

    private void createProjects() throws Exception {
        List<UUID> dataSets = this.getListOfObjects(org.qubership.atp.ei.ntt.dto.DataSet.class, new UUID[0]);
        for (UUID atpDataSetId : dataSets) {
            org.qubership.atp.ei.ntt.dto.DataSet dataSet = this.loadObject(atpDataSetId, org.qubership.atp.ei.ntt.dto.DataSet.class);
            UUID dataSetListId = dataSet.getDataSetList();
            DataSetList dataSetList = this.loadObject(dataSetListId, DataSetList.class);
            Project dataSetsProject = this.nttScopeMaps.getDataSetList2NttProjectMap().computeIfAbsent(dataSetListId, id -> new ProjectModel(this.getSafeProjectName(dataSetList.getName())));
            DataSet nttDataSet = DataSetController.getInstance().createEmptyDataSet(dataSetsProject, new Object[0]);
            String atpDataSetName = this.loadObject(atpDataSetId, org.qubership.atp.ei.ntt.dto.DataSet.class).getName();
            nttDataSet.setName(this.getSafeProjectName(atpDataSetName));
            this.nttScopeMaps.getDataSet2NttDataSetMap().put(atpDataSetId, nttDataSet);
        }
        ProjectModel defaultProject = new ProjectModel("Default Project");
        this.nttScopeMaps.getDataSetList2NttProjectMap().put(null, defaultProject);
        this.nttWorkspaceModel.getProjects().add(defaultProject);
    }

    public NttExportConverterResult convertDataSet() throws Exception {
        this.createProjects();
        this.insertVariablesInNttDataSets();
        return new NttExportConverterResult(new ArrayList<Project>(this.nttScopeMaps.getDataSetList2NttProjectMap().values()), null, null, false, this.modelLocationPath);
    }

    public NttExportConverterResult convertCatalog(Map<UUID, String> dataSetListIdNameMap, Map<UUID, String> dataSetIdNameMap, Map<UUID, UUID> dataSetIdParentIdMap) throws Exception {
        log.debug("start convertCatalog(dataSetListIdNameMap: {}, dataSetIdNameMap: {}, dataSetIdParentIdMap: {})", new Object[]{dataSetListIdNameMap, dataSetIdNameMap, dataSetIdParentIdMap});
        this.createProjects(dataSetListIdNameMap, dataSetIdNameMap, dataSetIdParentIdMap);
        this.createSuitesAndTestCases();
        this.exportTestCases();
        this.extractFlagsForTestCases();
        this.extractFlagsForSuites();
        this.createScopesForExistingScopes();
        NttExportConverterResult result = new NttExportConverterResult(new ArrayList<Project>(this.nttScopeMaps.getDataSetList2NttProjectMap().values()), this.nttScopeMaps.getNttScopes(), null, true, this.modelLocationPath);
        log.debug("end convertCatalog(.., .., ..)");
        return result;
    }

    public NttExportConverterResult convertEnvironment(Map<UUID, String> categoryMap) throws Exception {
        SettingsResource settingResource = new SettingsResource();
        this.nttScopeMaps.setNttEnvironments(settingResource);
        ServerTypesDal serverTypes = settingResource.getChild(ServerTypesDal.class);
        ServersSettingsDal servers = settingResource.getChild(ServersSettingsDal.class);
        EnvironmentListsSectionDal envs = settingResource.getChild(EnvironmentListsSectionDal.class);
        EnvironmentItemLinksSectionDal envLinks = settingResource.getChild(EnvironmentItemLinksSectionDal.class);
        List<UUID> listId = this.getListOfObjects(Environment.class, new UUID[0]);
        for (UUID id : listId) {
            Environment atpEnv = this.loadObject(id, Environment.class);
            EnvironmentListDal env = new EnvironmentListDal();
            env.setName(atpEnv.getName());
            envs.getEnvironmentLists().add(env);
            List<System> systems = atpEnv.getSystems();
            if (systems == null) continue;
            for (System system : systems) {
                String serverType = categoryMap.get(system.getSystemCategoryId());
                if (!serverTypes.getTypes().contains(serverType)) {
                    serverTypes.getTypes().add(serverType);
                }
                ServerDal server = new ServerDal();
                server.setAlias(system.getName());
                server.setType(serverType);
                servers.getServerList().add(server);
                EnvironmentItemLinkDal envLink = new EnvironmentItemLinkDal();
                envLink.setEnvironment(env.getName());
                envLink.setServer(server.getAlias());
                envLink.setType(server.getType());
                envLinks.getEnvironmentItemLinks().add(envLink);
                List<Connection> connections = system.getConnections();
                if (connections == null) continue;
                for (Connection connection : connections) {
                    if (connection.getParameters() == null || connection.getParameters().isEmpty()) continue;
                    Map<String, String> params = connection.getParameters();
                    if (SSH_CONNECTION_ID.equals(connection.getSourceTemplateId())) {
                        server.setSshHost(params.get("ssh_host"));
                        server.setSshKey(params.get("ssh_key"));
                        server.setSshUser(params.get("ssh_login"));
                        server.setDbPassword(params.get("ssh_password"));
                    } else if (DB_CONNECTION_ID.equals(connection.getSourceTemplateId())) {
                        server.setDbConnectionUrl(params.get("jdbc_url"));
                        server.setDbPassword(params.get("db_password"));
                        server.setDbPort(params.get("db_port"));
                        server.setDbServer(params.get("db_host"));
                        server.setDbSid(params.get("db_name"));
                        server.setDbType(params.get("db_type"));
                        server.setDbUser(params.get("db_login"));
                    } else if (HTTP_CONNECTION_ID.equals(connection.getSourceTemplateId())) {
                        server.setInstance(params.get("url"));
                        server.setUrl(params.get("url"));
                    }
                    server.setUnclassifiedServerParameters(connection.getParameters());
                }
            }
        }
        return new NttExportConverterResult(null, null, this.nttScopeMaps.getNttEnvironments(), false, this.modelLocationPath);
    }

    private <T> T loadObject(UUID id, Class<T> clazz) {
        log.debug("start loadObject(id: {}, clazz: {})", (Object)id, clazz);
        Path dirWithObjects = this.getFolderWithObjects(clazz.getSimpleName(), new UUID[0]);
        Path res = this.findFileOnDisk(dirWithObjects, id);
        return this.loadFileAsObject(res, clazz, id);
    }

    private <T> T loadFileAsObject(Path file, Class<T> clazz, UUID id) {
        Object result;
        log.debug("start loadFileAsObject(id: {}, clazz: {})", (Object)file, clazz);
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            result = this.objectMapper.readValue(in, clazz);
        }
        catch (Exception e) {
            log.error("Cannot read data from file {}, id {}, class {}", new Object[]{file, id, clazz, e});
            throw new RuntimeException(String.format("Cannot read data from file %s", file), e);
        }
        log.debug("end (loadFileAsObject: {}, clazz: {})", (Object)file, clazz);
        return (T)result;
    }

    private Path findFileOnDisk(Path workDir, UUID id) {
        Optional<Path> res;
        log.debug("start findFileOnDisk(workDir: {}, id: {})", (Object)workDir, (Object)id);
        String fileName = id.toString();
        try (Object result = Files.find(workDir, 10, (path, basicFileAttributes) -> path.getFileName().toString().contains(fileName), new FileVisitOption[0]);){
            res = result.findFirst();
        }
        if (!res.isPresent()) {
            return null;
        }
        result = res.get();
        log.debug("end findFileOnDisk(.., ..): {}", result);
        return result;
    }

    static {
        macroRegexReplacement.put("\\$RAND\\('([0-9]*)'\\)", "%RANDOM#$1%");
        macroRegexReplacement.put("\\$DATE\\('(.*?)'(, '.*?')?\\)", "%DATE#$1%");
        atp2NttFlagMaps.put("warn if fail", "Warn if fail");
        atp2NttFlagMaps.put("skip on fail", "Skip if an exception has occurred in any previous item");
        atp2NttFlagMaps.put("stop on fail", "Stop if an exception has occurred on this item");
        atp2NttFlagMaps.put("terminate if fail", "Stop if an exception has occurred on this item");
        atp2NttFlagMaps.put("skip if dependencies fail", "Skip if an exception has occurred in any previous item");
    }
}

