/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import javax.annotation.Nonnull;

public final class CermFileSystem {
    public static final String DIR_APPLICATION = CermFileSystem.getAppDir();
    @Nonnull
    public static final File APP_DIR = new File(DIR_APPLICATION);
    public static final String DIR_ACTIONS = DIR_APPLICATION + "/actions/";
    public static final String DIR_CONFIG = DIR_APPLICATION + "/config/";
    public static final String DIR_DOCS = DIR_APPLICATION + "/docs/";
    public static final String DIR_PROJECTS = DIR_APPLICATION + "/projects/";
    public static final String DIR_RESOURCES = DIR_APPLICATION + "/resources/";
    public static final String DIR_ACTIONS_DEPENDENCIES = DIR_ACTIONS + "dependencies/";
    public static final String DIR_ACTIONS_LIBRARIES = DIR_ACTIONS + "libraries/";
    public static final String DESKTOP_SETTINGS_FILE_NAME = DIR_CONFIG + "desktop.xml";
    public static final String LOG4J_CONFIG_FILE_NAME = DIR_CONFIG + "log4j.xml";
    public static final String EXEC_SETTINGS_FILE_NAME = DIR_CONFIG + "settings.xml";
    public static final String DEFAULT_TEST_PROPS_FILE_NAME = DIR_CONFIG + "test.properties";
    public static final String DIR_DOC_CHANGELOG = DIR_DOCS + "changelog/";
    public static final String DIR_DOC_MANUAL = DIR_DOCS + "manual/";
    public static final String DIR_RES_COMPONENTS = DIR_RESOURCES + "components/";
    public static final String DIR_RES_DEPENDENCIES = DIR_RESOURCES + "dependencies/";
    public static final String DIR_RES_PYTHON = DIR_RESOURCES + "python/";
    public static final String DIR_EDITOR = DIR_RES_COMPONENTS + "editor/";
    public static final String DIR_PYTHON_SCRIPTS = DIR_RES_PYTHON + "scripts/";
    public static final String EDITOR_MAIN_FILE = DIR_EDITOR + "ntt/editor.html";
    public static final String MANO_FINDER_FILE = "config/finders/mano.element.finder.xml";
    public static final String GWT_FINDER_FILE = "config/finders/gwt.element.finder.xml";
    public static final String TUI_FINDER_FILE = "config/finders/tui.element.finder.xml";
    public static final String CBC_FINDER_FILE = "config/finders/cbc.element.finder.xml";

    @Nonnull
    public static String getAppDir() {
        try {
            Class<CermFileSystem> clazz = CermFileSystem.class;
            String pathToJar = clazz.getResource(clazz.getSimpleName() + ".class").getPath().split("!", 2)[0];
            File file = new File(new URI(new URL(pathToJar).toExternalForm())).getParentFile().getParentFile().getParentFile();
            return file.getAbsolutePath();
        }
        catch (Throwable e) {
            String path;
            File probeFile = new File(".");
            try {
                path = URLDecoder.decode(probeFile.getCanonicalPath(), Charsets.UTF_8.name());
            }
            catch (IOException ex) {
                path = probeFile.getAbsolutePath();
            }
            return path;
        }
    }
}

