/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FilenameUtils;
import org.qubership.atp.ei.ntt.controllers.DataSetController;
import org.qubership.atp.ei.ntt.controllers.ModelItemController;
import org.qubership.atp.ei.ntt.converter.ModelItemTextConverter;
import org.qubership.atp.ei.ntt.converter.TextType;
import org.qubership.atp.ei.ntt.model.ContextVariable;
import org.qubership.atp.ei.ntt.model.DataSet;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.Reference;
import org.qubership.atp.ei.ntt.model.Scope;
import org.qubership.atp.ei.ntt.model.Template;
import org.qubership.atp.ei.ntt.model.TemplateProject;
import org.qubership.atp.ei.ntt.model.TestAction;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.Workspace;
import org.qubership.atp.ei.ntt.model.enums.ModelItemType;
import org.qubership.atp.ei.ntt.model.impl.ProjectModel;
import org.qubership.atp.ei.ntt.model.impl.TemplateProjectModel;
import org.qubership.atp.ei.ntt.model.impl.WorkspaceModel;
import org.qubership.atp.ei.ntt.scope.ScopeDao;
import org.qubership.atp.ei.ntt.scope.ScopeDaoFactory;
import org.qubership.atp.ei.ntt.settings.model.dal.SettingsResource;
import org.qubership.atp.ei.ntt.settings.model.dal.support.DaoFactory;
import org.qubership.atp.ei.ntt.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NttModelLoader {
    private static final Logger log = LoggerFactory.getLogger(NttModelLoader.class);
    private static NttModelLoader instance;
    private static final ModelItemController modelItemController;
    private static final int MAX_SIZE = 0x500000;

    public static synchronized NttModelLoader getInstance() {
        if (instance == null) {
            instance = new NttModelLoader();
        }
        return instance;
    }

    private NttModelLoader() {
    }

    public void addNode(TreeNode parent, TreeNode[] child, Object ... helpArgs) {
        if (parent == null || child == null) {
            return;
        }
        modelItemController.add(parent, child, helpArgs);
    }

    public void clearReferences() {
        for (Project proj : this.getProjects(false)) {
            this.clearReferences(proj);
        }
    }

    private void clearReferences(TreeNode treeNode) {
        for (TreeNode node : treeNode.getChildren()) {
            if (node instanceof Reference) {
                ((Reference)node).setTemplate(null);
            }
            this.clearReferences(node);
        }
    }

    public List<Project> getProjects(boolean isTemplate) {
        if (isTemplate) {
            return this.getWorkspace().getTemplateProjects();
        }
        return this.getWorkspace().getProjects();
    }

    public Workspace getWorkspace() {
        return WorkspaceModel.getInstance();
    }

    public Scope getScope() {
        return this.getWorkspace().getScope();
    }

    public Reference createReference(String name, ModelItemType miEnum, String templateProjName, String templateName) {
        Reference referenceModel = modelItemController.createSomeThing(Reference.class, name, new Object[0]);
        referenceModel.setTemplate(miEnum, templateProjName, templateName);
        referenceModel.setReferenceId(CommonUtils.generateId());
        return referenceModel;
    }

    public TestAction createTestAction(String name, String description) {
        TestAction action = modelItemController.createSomeThing(TestAction.class, name, new Object[0]);
        action.setActionId(CommonUtils.generateId());
        action.setDescription(description);
        return action;
    }

    public Template createTemplate(ModelItem modelForTemplate) {
        Template template = this.createTemplateCore(modelForTemplate);
        modelForTemplate.setParent(template);
        return template;
    }

    private Template createTemplateCore(ModelItem modelForTemplate) {
        Template template = modelItemController.createSomeThing(Template.class, "", new Object[0]);
        template.setModelItem(modelForTemplate);
        template.setTemplateId(CommonUtils.generateId());
        return template;
    }

    public Project loadProject(File file) {
        ProjectModel project = new ProjectModel();
        project.setName(FilenameUtils.removeExtension((String)file.getName()));
        ModelItemTextConverter.getInstance().setChildrenFromText((ModelItem)project, file, false);
        String dsFilename = FilenameUtils.removeExtension((String)file.getPath()) + ".cds";
        DataSetController.getInstance().load(project, new ArrayList<String>(Collections.singletonList(dsFilename)));
        List<Project> projects = NttModelLoader.getInstance().getProjects(false);
        projects.add(project);
        log.debug("Loaded NTT projects: {}", projects);
        return project;
    }

    public Project loadProjectTemplate(File file) {
        TemplateProjectModel project = new TemplateProjectModel();
        project.setName(FilenameUtils.removeExtension((String)file.getName()));
        ModelItemTextConverter.getInstance().setChildrenFromText((ModelItem)project, file, true);
        String dsFilename = FilenameUtils.removeExtension((String)file.getPath()) + ".ctds";
        DataSetController.getInstance().load(project, new ArrayList<String>(Collections.singletonList(dsFilename)));
        NttModelLoader.getInstance().getProjects(true).add(project);
        return project;
    }

    public void saveProject(Project project, Path directoryPath) throws IOException {
        if (project == null) {
            return;
        }
        boolean isTemplate = project instanceof TemplateProject;
        String fileName = CommonUtils.getSafeFilename(project.getName());
        Path directory = this.createFolder(directoryPath.resolve("AT_configuration"));
        String projectFileText = isTemplate ? ModelItemTextConverter.getInstance().convertTemplateToText(project, TextType.FILE).getText() : ModelItemTextConverter.getInstance().convertMiToText(project, TextType.FILE).getText();
        log.debug("result: {}", (Object)projectFileText);
        if (projectFileText != null) {
            if (projectFileText.length() >= 0x500000) {
                throw new IOException("Maximum file size exceeded: 5242880!");
            }
            String projectFileExtension = isTemplate ? ".ctpr" : ".cpr";
            Path projectFile = directory.resolve(fileName + projectFileExtension);
            Files.write(projectFile, projectFileText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public void saveDataSet(Project project, Path directoryPath) throws IOException {
        if (project == null) {
            return;
        }
        String fileName = CommonUtils.getSafeFilename(project.getName());
        Path directory = this.createFolder(directoryPath.resolve("AT_configuration"));
        String dataSetFileExtension = project instanceof TemplateProject ? ".ctds" : ".cds";
        Path dataSetFile = directory.resolve(fileName + dataSetFileExtension);
        StringBuilder buf = new StringBuilder();
        for (DataSet dataSet : project.getDataSets()) {
            buf.append("dsName=").append(dataSet.getName()).append("\n").append("\n");
            for (ContextVariable variable : dataSet.getVariables()) {
                buf.append("name=").append(variable.getName()).append("; description=").append(variable.getDescription()).append("; value=").append(variable.getValue()).append("\n");
            }
            buf.append("\n");
        }
        String dataSetFileText = buf.toString();
        log.debug("dataSetFileText: {}", (Object)dataSetFileText);
        Files.write(dataSetFile, dataSetFileText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path filesDirectory = this.createFolder(directoryPath.resolve("files"));
        Map<Path, Path> files = project.getFiles();
        for (Map.Entry<Path, Path> entry : files.entrySet()) {
            Path atpFileContainer = entry.getValue();
            Path newFileFullPath = filesDirectory.resolve(entry.getKey());
            this.createFolder(newFileFullPath.getParent());
            Files.copy(atpFileContainer, newFileFullPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Path createFolder(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    public void saveScope(Scope scope, Path directoryPath) throws IOException {
        Path directory = this.createFolder(directoryPath.resolve("AT_configuration"));
        String scopeName = CommonUtils.getSafeFilename(scope.getName());
        Path scopeFile = directory.resolve(scopeName + ".xml");
        ScopeDaoFactory scopeDaoFactory = ScopeDaoFactory.getInstance();
        ScopeDao scopeDao = scopeDaoFactory.getScopeDao(scope);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ScopeDao.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)scopeDao, scopeFile.toFile());
        }
        catch (JAXBException e) {
            log.info("Error save scope {}", (Object)scopeName, (Object)e);
        }
    }

    public void saveEnvironmentSettings(SettingsResource settingResource, Path workDir) throws IOException {
        Path directory = this.createFolder(workDir.resolve("config"));
        Path settingFile = Files.createFile(directory.resolve("new_settings.xml"), new FileAttribute[0]);
        DaoFactory factory = DaoFactory.getInstance();
        settingResource.setFileSettings(settingFile.toFile());
        factory.save(settingResource);
    }

    static {
        modelItemController = ModelItemController.getInstance();
    }
}

