/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.service.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.tdm.env.configurator.api.dto.environments.BaseSearchRequestDto;
import org.qubership.atp.tdm.env.configurator.api.dto.environments.EnvironmentDto;
import org.qubership.atp.tdm.env.configurator.api.dto.environments.EnvironmentFullVer1ViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.environments.SystemNameViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.ConnectionFullVer1ViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.EnvironmentNameViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.EnvironmentResDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.ProjectFullVer1ViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.ProjectNameViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.SystemEnvironmentsViewDto;
import org.qubership.atp.tdm.env.configurator.api.dto.project.SystemFullVer1ViewDto;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertFullProjectByIdException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertFullSystemByNameException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertFullSystemBySysIdException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazyEnvironmentByEnvIdtException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazyEnvironmentByNameException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazyEnvironmentsException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazyProjectByIdException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazyProjectByNameException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazyProjectsException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazySystemBySysIdException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazySystemsByEnvIdByNameException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazySystemsByEnvIdException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvConvertLazySystemsByProjectIdException;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvResetCachesException;
import org.qubership.atp.tdm.env.configurator.model.Connection;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.env.configurator.model.System;
import org.qubership.atp.tdm.env.configurator.service.DtoConvertService;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.env.configurator.service.client.EnvironmentFeignClient;
import org.qubership.atp.tdm.env.configurator.service.client.ProjectEnvironmentFeignClient;
import org.qubership.atp.tdm.env.configurator.service.client.SystemEnvironmentFeignClient;
import org.qubership.atp.tdm.env.configurator.utils.CacheNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentsServiceImpl
implements EnvironmentsService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsServiceImpl.class);
    private final EnvironmentFeignClient environmentFeignClient;
    private final ProjectEnvironmentFeignClient projectEnvFeignClient;
    private final SystemEnvironmentFeignClient systemEnvFeignClient;
    private final DtoConvertService dtoConvertService;
    private final CacheManager cacheManager;

    @Override
    @Cacheable(value={"tdmFullProjectCache"})
    public Project getFullProject(@Nonnull UUID projectId) {
        Project project;
        log.info("Loading project by id: [{}]", (Object)projectId);
        ResponseEntity<ProjectFullVer1ViewDto> fullProjectRes = this.projectEnvFeignClient.getProject(projectId, true);
        try {
            project = this.dtoConvertService.convert(fullProjectRes.getBody(), Project.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert full project: %s.", projectId), (Throwable)e);
            throw new TdmEnvConvertFullProjectByIdException(projectId.toString());
        }
        log.info("Project successfully loaded.");
        return project;
    }

    @Override
    @Cacheable(value={"tdmLazyProjectCache"})
    public LazyProject getLazyProjectById(@Nonnull UUID projectId) {
        LazyProject lazyProjects;
        log.info("Loading lazy project by Id.");
        ResponseEntity<ProjectFullVer1ViewDto> projectsResponse = this.projectEnvFeignClient.getShortProject(projectId, false);
        try {
            lazyProjects = this.dtoConvertService.convert(projectsResponse.getBody(), LazyProject.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy project: %s.", projectId), (Throwable)e);
            throw new TdmEnvConvertLazyProjectByIdException(projectId.toString());
        }
        log.info("Lazy project by Id successfully loaded.");
        return lazyProjects;
    }

    @Override
    @Cacheable(value={"tdmLazyProjectByNameCache"})
    public LazyProject getLazyProjectByName(@Nonnull String projectName) {
        LazyProject lazyProject;
        log.info("Loading lazy project by name: {}.", (Object)projectName);
        ResponseEntity<ProjectFullVer1ViewDto> projectsResponse = this.projectEnvFeignClient.getShortProjectByName(projectName, false);
        try {
            lazyProject = this.dtoConvertService.convert(projectsResponse.getBody(), LazyProject.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy project with name: %s. ", projectName), (Throwable)e);
            throw new TdmEnvConvertLazyProjectByNameException(projectName);
        }
        log.info("Lazy project by name successfully loaded.");
        return lazyProject;
    }

    @Override
    @Cacheable(value={"tdmLazyProjectsCache"})
    public List<LazyProject> getLazyProjects() {
        List<LazyProject> lazyProjects;
        log.info("Loading lazy projects.");
        ResponseEntity<List<ProjectNameViewDto>> projectsResponse = this.projectEnvFeignClient.getAllShort(false);
        try {
            lazyProjects = this.dtoConvertService.convertList((List)projectsResponse.getBody(), LazyProject.class);
        }
        catch (Exception e) {
            log.error("Error while convert lazy projects.", (Throwable)e);
            throw new TdmEnvConvertLazyProjectsException();
        }
        log.info("Lazy projects successfully loaded.");
        return lazyProjects;
    }

    @Override
    @Cacheable(value={"tdmLazyEnvironmentByIdCache"})
    public LazyEnvironment getLazyEnvironment(@Nonnull UUID environmentId) {
        LazyEnvironment environment;
        log.info("Loading lazy environment by environment id: [{}]", (Object)environmentId);
        ResponseEntity<EnvironmentFullVer1ViewDto> envLazyRes = this.environmentFeignClient.getEnvironment(environmentId, false);
        try {
            environment = this.dtoConvertService.convert(envLazyRes.getBody(), LazyEnvironment.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy environment by envID: %s.", environmentId), (Throwable)e);
            throw new TdmEnvConvertLazyEnvironmentByEnvIdtException(environmentId.toString());
        }
        log.info("Lazy environment successfully loaded.");
        return environment;
    }

    @Override
    @Cacheable(value={"tdmConnectionsBySystemIdCache"})
    public String getEnvNameById(@Nonnull UUID environmentId) {
        log.info("Loading environment name by environment id: [{}]", (Object)environmentId);
        ResponseEntity<String> environmentNameById = this.environmentFeignClient.getEnvironmentNameById(environmentId);
        String body = (String)environmentNameById.getBody();
        return body;
    }

    @Override
    @Cacheable(value={"tdmLazyEnvironmentsCache"})
    public List<LazyEnvironment> getLazyEnvironments(@Nonnull UUID projectId) {
        List<LazyEnvironment> lazyEnvironments;
        log.info("Loading lazy environments by project id: [{}]", (Object)projectId);
        ResponseEntity<List<EnvironmentResDto>> envResponse = this.projectEnvFeignClient.getEnvironments(projectId, false);
        try {
            lazyEnvironments = this.dtoConvertService.convertList((List)envResponse.getBody(), LazyEnvironment.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy environments by project: %s.", projectId), (Throwable)e);
            throw new TdmEnvConvertLazyEnvironmentsException(projectId.toString());
        }
        log.info("Lazy environments successfully loaded.");
        return lazyEnvironments;
    }

    @Override
    @Cacheable(value={"tdmLazyEnvironmentsShortCache"})
    public List<LazyEnvironment> getLazyEnvironmentsShort(@Nonnull UUID projectId) {
        List<LazyEnvironment> lazyEnvironments;
        log.info("Loading lazy environments by project id: [{}]", (Object)projectId);
        ResponseEntity<List<EnvironmentNameViewDto>> envResponse = this.projectEnvFeignClient.getEnvironmentsShort(projectId);
        try {
            lazyEnvironments = this.dtoConvertService.convertList((List)envResponse.getBody(), LazyEnvironment.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy environments by project: %s.", projectId), (Throwable)e);
            throw new TdmEnvConvertLazyEnvironmentsException(projectId.toString());
        }
        log.info("Lazy environments successfully loaded.");
        return lazyEnvironments;
    }

    @Override
    @Cacheable(value={"tdmLazyEnvironmentByNameCache"})
    public LazyEnvironment getLazyEnvironmentByName(@Nonnull UUID projectId, @Nonnull String environmentName) {
        LazyEnvironment lazyEnvironment;
        ArrayList<String> envNames = new ArrayList<String>();
        envNames.add(environmentName);
        BaseSearchRequestDto baseSearchRequestDto = new BaseSearchRequestDto();
        baseSearchRequestDto.setProjectId(projectId);
        baseSearchRequestDto.setNames(envNames);
        ResponseEntity<List<EnvironmentDto>> body = this.environmentFeignClient.findBySearchRequest(baseSearchRequestDto, false);
        try {
            lazyEnvironment = this.dtoConvertService.convertList((List)body.getBody(), LazyEnvironment.class).stream().filter(env -> env.getName().equals(environmentName.trim())).findFirst().orElseThrow(() -> new TdmEnvConvertLazyEnvironmentByNameException(environmentName, projectId.toString()));
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy environment with name: %s. Project ID: %s", environmentName, projectId), (Throwable)e);
            throw new TdmEnvConvertLazyEnvironmentByNameException(environmentName, projectId.toString());
        }
        return lazyEnvironment;
    }

    @Override
    @Cacheable(value={"tdmFullSystemByNameCache"})
    public System getFullSystemByName(@Nonnull UUID projectId, @Nonnull UUID environmentId, @Nonnull String systemName) {
        System system;
        log.info("Loading full systems for project id: [{}] by environment id: [{}] and systemName: [{}]", new Object[]{projectId, environmentId, systemName});
        ResponseEntity<SystemFullVer1ViewDto> systemResponse = this.systemEnvFeignClient.getSystemByName(environmentId, systemName, true);
        try {
            system = this.dtoConvertService.convert(systemResponse.getBody(), System.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert full system with name: [%s].", systemName), (Throwable)e);
            throw new TdmEnvConvertFullSystemByNameException(systemName);
        }
        log.info("Full systems by name successfully loaded.");
        return system;
    }

    @Override
    @Cacheable(value={"tdmFullSystemByIdCache"})
    public System getFullSystemById(UUID systemId) {
        System system;
        log.info("Loading full system by system ID: {}", (Object)systemId);
        ResponseEntity<SystemFullVer1ViewDto> systemResponse = this.systemEnvFeignClient.getSystem(systemId, true);
        try {
            system = this.dtoConvertService.convert(systemResponse.getBody(), System.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert full system by System ID: %s.", systemId), (Throwable)e);
            throw new TdmEnvConvertFullSystemBySysIdException(systemId.toString());
        }
        log.info("Full systems by system ID successfully loaded.");
        return system;
    }

    @Override
    @Cacheable(value={"tdmConnectionsBySystemIdCache"})
    public List<Connection> getConnectionsSystemById(UUID systemId) {
        List<Connection> connections;
        log.info("Loading connections by system ID: {}", (Object)systemId);
        ResponseEntity<List<ConnectionFullVer1ViewDto>> systemConnections = this.systemEnvFeignClient.getSystemConnections(systemId, false);
        try {
            connections = this.dtoConvertService.convertList((List)systemConnections.getBody(), Connection.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert full system by System ID: %s.", systemId), (Throwable)e);
            throw new TdmEnvConvertFullSystemBySysIdException(systemId.toString());
        }
        log.info("Full systems by system ID successfully loaded.");
        return connections;
    }

    @Override
    @Cacheable(value={"tdmLazySystemCache"})
    public LazySystem getLazySystemById(@Nonnull UUID systemId) {
        LazySystem lazySystem;
        log.info("Loading lazy system by system ID: {}", (Object)systemId);
        ResponseEntity<SystemFullVer1ViewDto> system = this.systemEnvFeignClient.getShortSystem(systemId, false);
        try {
            lazySystem = this.dtoConvertService.convert(system.getBody(), LazySystem.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy system by System ID: %s.", systemId), (Throwable)e);
            throw new TdmEnvConvertLazySystemBySysIdException(systemId.toString());
        }
        log.info("Lazy systems by system ID successfully loaded.");
        return lazySystem;
    }

    @Override
    @Cacheable(value={"tdmLazySystemByNameCache"})
    public LazySystem getLazySystemByName(@Nonnull UUID projectId, @Nonnull UUID environmentId, @Nonnull String systemName) {
        LazySystem lazySystem;
        log.info("Loading lazy systems for project id: [{}] by environment id: [{}] and systemName: [{}]", new Object[]{projectId, environmentId, systemName});
        ResponseEntity<SystemFullVer1ViewDto> systemResponse = this.systemEnvFeignClient.getSystemByName(environmentId, systemName, false);
        try {
            lazySystem = this.dtoConvertService.convert(systemResponse.getBody(), LazySystem.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert full system with name: [%s].", systemName), (Throwable)e);
            throw new TdmEnvConvertFullSystemByNameException(systemName);
        }
        log.info("Full systems by name successfully loaded.");
        return lazySystem;
    }

    @Override
    @Cacheable(value={"tdmLazySystemsCache"})
    public List<LazySystem> getLazySystems(@Nonnull UUID environmentId) {
        log.info("Loading lazy systems by env ID: [{}]", (Object)environmentId);
        ResponseEntity<List<SystemNameViewDto>> systemsRes = this.environmentFeignClient.getSystemsShort(environmentId);
        log.info("Lazy systems by envID successfully loaded.");
        try {
            return this.dtoConvertService.convertList((List)systemsRes.getBody(), LazySystem.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy systems by envID: %s.", environmentId), (Throwable)e);
            throw new TdmEnvConvertLazySystemsByEnvIdException(environmentId.toString());
        }
    }

    @Override
    @Cacheable(value={"tdmLazySystemsByNameCache"})
    public List<LazySystem> getLazySystems(@Nonnull UUID environmentId, @Nonnull String defaultSystem) {
        List<LazySystem> lazySystems;
        log.info("Loading lazy systems by environment id: [{}], defaultSystem: [{}]", (Object)environmentId, (Object)defaultSystem);
        ResponseEntity<List<SystemNameViewDto>> systemsRes = this.environmentFeignClient.getSystemsShort(environmentId);
        try {
            List<LazySystem> systems = this.dtoConvertService.convertList((List)systemsRes.getBody(), LazySystem.class);
            lazySystems = this.sortByDefault(systems, defaultSystem);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy systems by envID: %s and name: %s.", environmentId, defaultSystem), (Throwable)e);
            throw new TdmEnvConvertLazySystemsByEnvIdByNameException(environmentId.toString(), defaultSystem);
        }
        log.info("Lazy systems by envId and name successfully loaded.");
        return lazySystems;
    }

    @Override
    @Cacheable(value={"tdmAllShortLazySystemsByProjectCache"})
    public List<LazySystem> getLazySystemsByProjectWithEnvIds(@Nonnull UUID projectId) {
        List<LazySystem> lazySystems;
        log.info("Loading lazy systems by project ID: [{}]", (Object)projectId);
        ResponseEntity<List<SystemEnvironmentsViewDto>> allShortName = this.projectEnvFeignClient.getAllShortSystemsOnProject(projectId);
        try {
            lazySystems = this.dtoConvertService.convertList((List)allShortName.getBody(), LazySystem.class);
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy systems by project ID: %s.", projectId), (Throwable)e);
            throw new TdmEnvConvertLazySystemsByProjectIdException(projectId.toString());
        }
        log.info("Lazy systems by project ID successfully loaded.");
        return lazySystems;
    }

    @Override
    @Cacheable(value={"tdmLazySystemsByProjectCache"})
    public List<LazySystem> getLazySystemsByProjectIdWithConnections(@Nonnull UUID projectId) {
        List<LazySystem> systems;
        log.info("Loading lazy systems by project ID: [{}]", (Object)projectId);
        List body = (List)this.projectEnvFeignClient.getProjectSystems(projectId, null, false).getBody();
        try {
            systems = this.dtoConvertService.convertList(body, LazySystem.class);
        }
        catch (AtpException ae) {
            throw ae;
        }
        catch (Exception e) {
            log.error(String.format("Error while convert lazy systems by project ID: %s.", projectId), (Throwable)e);
            throw new TdmEnvConvertLazySystemsByProjectIdException(projectId.toString());
        }
        log.info("Lazy systems by project ID successfully loaded");
        return systems;
    }

    @Override
    public boolean resetCaches() {
        log.info("Reset caches.");
        try {
            Field[] fields;
            for (Field field : fields = CacheNames.class.getDeclaredFields()) {
                Cache cache = this.cacheManager.getCache(field.get(String.class).toString());
                if (!Objects.nonNull(cache)) continue;
                cache.clear();
            }
        }
        catch (Exception e) {
            log.error("An error occurred while resetting caches.", (Throwable)e);
            throw new TdmEnvResetCachesException();
        }
        log.info("Environment caches have been cleared.");
        return true;
    }

    private List<LazySystem> sortByDefault(@Nonnull List<LazySystem> lazySystems, String defaultSystem) {
        for (int i = 0; i < lazySystems.size(); ++i) {
            LazySystem lazySystem = lazySystems.get(i);
            if (!lazySystem.getName().equals(defaultSystem)) continue;
            Collections.swap(lazySystems, i, 0);
            break;
        }
        return lazySystems;
    }

    public EnvironmentsServiceImpl(EnvironmentFeignClient environmentFeignClient, ProjectEnvironmentFeignClient projectEnvFeignClient, SystemEnvironmentFeignClient systemEnvFeignClient, DtoConvertService dtoConvertService, CacheManager cacheManager) {
        this.environmentFeignClient = environmentFeignClient;
        this.projectEnvFeignClient = projectEnvFeignClient;
        this.systemEnvFeignClient = systemEnvFeignClient;
        this.dtoConvertService = dtoConvertService;
        this.cacheManager = cacheManager;
    }
}

