/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.config;

import org.qubership.atp.common.logging.config.AtpFeignLoggerFactory;
import org.qubership.atp.common.logging.config.LoggingProperties;
import org.qubership.atp.common.logging.filter.LoggingFilter;
import org.qubership.atp.common.logging.interceptor.RestTemplateLogInterceptor;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.cloud.openfeign.FeignLoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoggingConfiguration {
    @Bean
    public LoggingProperties headerProperties() {
        return new LoggingProperties();
    }

    @Bean
    public LoggingFilter getLogFilter(LoggingProperties loggingProperties) {
        return new LoggingFilter(loggingProperties);
    }

    @Bean
    public FeignLoggerFactory getFeignLoggerFactory(LoggingProperties loggingProperties) {
        return new AtpFeignLoggerFactory(loggingProperties);
    }

    @Bean
    public RestTemplateLogInterceptor restTemplateLogInterceptor(LoggingProperties loggingProperties) {
        return new RestTemplateLogInterceptor(loggingProperties);
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

