/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.config;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class LoggingProperties {
    @Value(value="#{new Boolean('${atp.logging.controller.headers:false}')}")
    private Boolean logControllerHeaders;
    @Value(value="#{new Boolean('${atp.logging.feignclient.headers:false}')}")
    private Boolean logFeignHeaders;
    @Value(value="#{new Boolean('${atp.logging.resttemplate.headers:false}')}")
    private Boolean logRestTemplateHeaders;
    @Value(value="#{'${atp.logging.controller.headers.ignore:Authorization}'.split(' ')}")
    private List<String> ignoreControllerHeaders;
    @Value(value="#{'${atp.logging.feignclient.headers.ignore:Authorization}'.split(' ')}")
    private List<String> ignoreFeignHeaders;
    @Value(value="#{'${atp.logging.resttemplate.headers.ignore:Authorization}'.split(' ')}")
    private List<String> ignoreRestTemplateHeaders;
    @Value(value="#{'${atp.logging.controller.uri.ignore:/sse/.* /deployment/readiness /deployment/liveness}'.split(' ')}")
    private List<String> ignoreUriList;
    private List<Pattern> ignoreControllerHeaderPatterns;
    private List<Pattern> ignoreFeignHeaderPatterns;
    private List<Pattern> ignoreRestTemplateHeaderPatterns;
    private List<Pattern> ignoreUriListPatterns;

    public List<Pattern> getIgnoreControllerHeaders() {
        if (Objects.isNull(this.ignoreControllerHeaderPatterns)) {
            this.ignoreControllerHeaderPatterns = this.compile(this.ignoreControllerHeaders);
        }
        return this.ignoreControllerHeaderPatterns;
    }

    public List<Pattern> getIgnoreFeignHeaderPatterns() {
        if (Objects.isNull(this.ignoreFeignHeaderPatterns)) {
            this.ignoreFeignHeaderPatterns = this.compile(this.ignoreFeignHeaders);
        }
        return this.ignoreFeignHeaderPatterns;
    }

    public List<Pattern> getIgnoreRestTemplateHeaderPatterns() {
        if (Objects.isNull(this.ignoreRestTemplateHeaderPatterns)) {
            this.ignoreRestTemplateHeaderPatterns = this.compile(this.ignoreRestTemplateHeaders);
        }
        return this.ignoreRestTemplateHeaderPatterns;
    }

    public List<Pattern> getIgnoreUriListPatterns() {
        if (Objects.isNull(this.ignoreUriListPatterns)) {
            this.ignoreUriListPatterns = this.compile(this.ignoreUriList);
        }
        return this.ignoreUriListPatterns;
    }

    private List<Pattern> compile(List<String> ignoreHeaders) {
        return ignoreHeaders.stream().filter(StringUtils::isNotEmpty).map(Pattern::compile).collect(Collectors.toList());
    }

    public Boolean logControllerHeaders() {
        return this.logControllerHeaders;
    }

    public Boolean logFeignHeaders() {
        return this.logFeignHeaders;
    }

    public Boolean logRestTemplateHeaders() {
        return this.logRestTemplateHeaders;
    }
}

