/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.common.logging.adapter.AtpHttpRequest;
import org.qubership.atp.common.logging.adapter.AtpHttpResponse;
import org.qubership.atp.common.logging.utils.RegexUtil;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public class Util {
    private static final String MESSAGE = "Body content logging is not allowed for current content type";

    public static Map<String, Collection<String>> filterHeaders(HttpHeaders headers, List<Pattern> patterns) {
        Map<String, Collection<String>> headersMap = headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return RegexUtil.removeByKeyRegexPatterns(headersMap, patterns);
    }

    public static HttpHeaders getHttpHeaders(Map<String, Collection<String>> map) {
        HashMap headers = new HashMap();
        map.forEach((key, value) -> headers.put(key, new ArrayList(value)));
        MultiValueMap multiValueMap = CollectionUtils.toMultiValueMap(headers);
        return new HttpHeaders(multiValueMap);
    }

    public static List<String> getLogRequestData(AtpHttpRequest request, Boolean isLoggedHeaders, List<Pattern> ignoreHeadersPattern) {
        byte[] body = request.getBody();
        return Util.composeLogs(isLoggedHeaders, ignoreHeadersPattern, request.getMethod(), request.getUri(), isLoggedHeaders != false ? request.getHeaders() : null, Objects.nonNull(body) ? new String(body, Charset.defaultCharset()) : "");
    }

    public static List<String> getLogHttpServletRequestData(HttpServletRequest request, Boolean isLoggedHeaders, List<Pattern> ignoreHeadersPattern) {
        return Util.composeLogs(isLoggedHeaders, ignoreHeadersPattern, request.getMethod(), request.getRequestURI(), isLoggedHeaders != false ? Util.getHeaders(request) : null, MESSAGE);
    }

    private static List<String> composeLogs(Boolean isLoggedHeaders, List<Pattern> ignoreHeadersPattern, String requestMethod, String requestUri, HttpHeaders requestHeaders, String bodyText) {
        ArrayList<String> logs = new ArrayList<String>();
        logs.add("HTTP REQUEST DATA:");
        logs.add(String.format("METHOD: %s", requestMethod));
        logs.add(String.format("URL: %s", requestUri));
        if (isLoggedHeaders.booleanValue()) {
            logs.add(String.format("HEADERS: %s", Util.filterHeaders(requestHeaders, ignoreHeadersPattern)));
        }
        logs.add(String.format("BODY: %s", bodyText));
        logs.add(String.format("END HTTP (%s-byte body)", bodyText.length()));
        return logs;
    }

    public static HttpHeaders getHeaders(HttpServletRequest request) {
        HashSet headerNames = new HashSet(Collections.list(request.getHeaderNames()));
        Map<String, Collection<String>> headers = headerNames.stream().collect(Collectors.toMap(Function.identity(), header -> Collections.list(request.getHeaders(header))));
        return Util.getHttpHeaders(headers);
    }

    public static HttpHeaders getHeaders(HttpServletResponse response) {
        HashSet headerNames = new HashSet(response.getHeaderNames());
        Map<String, Collection<String>> headers = headerNames.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletResponse)response).getHeaders(arg_0)));
        return Util.getHttpHeaders(headers);
    }

    public static List<String> getLogResponseData(AtpHttpResponse response, String body, Boolean isLoggedHeaders, List<Pattern> ignorePattern) throws IOException {
        return Util.getLogResponseData(response.getHeaders(), response.getStatusCode(), body, isLoggedHeaders, ignorePattern);
    }

    public static List<String> getLogResponseData(HttpHeaders headers, HttpStatus status, String body, Boolean isLoggedHeaders, List<Pattern> ignoreHeadersPattern) {
        ArrayList<String> logs = new ArrayList<String>();
        logs.add("HTTP RESPONSE DATA:");
        logs.add(String.format("HTTP STATUS: %s %s", status.value(), status.getReasonPhrase()));
        if (isLoggedHeaders.booleanValue()) {
            logs.add(String.format("HEADERS: %s", Util.filterHeaders(headers, ignoreHeadersPattern)));
        }
        logs.add(String.format("BODY: %s", body));
        logs.add(String.format("END HTTP (%s-byte body)", body.length()));
        return logs;
    }

    public static void logMessage(Logger logger, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    private Util() {
    }
}

