/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt.impl;

import java.util.regex.Matcher;
import org.qubership.atp.crypt.Constants;
import org.qubership.atp.crypt.api.CryptoProvider;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptorImpl
implements Decryptor {
    private static final Logger log = LoggerFactory.getLogger(DecryptorImpl.class);
    private final String transformation;
    private final Object key;
    private final CryptoProvider provider;

    public DecryptorImpl(String transformation, CryptoProvider provider, Object key) {
        this.transformation = transformation;
        this.provider = provider;
        this.key = key;
    }

    @Override
    public boolean isEncrypted(String data) {
        return this.provider.isEncrypted(data);
    }

    @Override
    public String decrypt(String encryptedData) throws AtpDecryptException {
        return this.decrypt(encryptedData, this.key);
    }

    @Override
    public String decrypt(String encryptedData, Object key) throws AtpDecryptException {
        try {
            return this.provider.decrypt(this.transformation, encryptedData, key);
        }
        catch (Exception e) {
            log.error("Exception on decrypting data", (Throwable)e);
            throw new AtpDecryptException("Decrypting failed.", e);
        }
    }

    @Override
    public String decryptIfEncrypted(String encryptedData, Object key) throws AtpDecryptException {
        if (this.isEncrypted(encryptedData)) {
            return this.decrypt(encryptedData, key);
        }
        return encryptedData;
    }

    @Override
    public String decryptIfEncrypted(String encryptedData) throws AtpDecryptException {
        return this.decryptIfEncrypted(encryptedData, this.key);
    }

    @Override
    public String decryptEncryptedPlacesInString(String text) throws AtpDecryptException {
        Matcher matcher = Constants.TEMPLATE_PATTERN.matcher(text);
        while (matcher.find()) {
            String encryptedValue = matcher.group();
            text = text.replace(encryptedValue, this.decrypt(encryptedValue));
        }
        return text;
    }
}

