/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import java.util.Properties;
import java.util.UUID;
import javax.servlet.Filter;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.qubership.atp.integration.configuration.filters.AuditLoggingFilter;
import org.qubership.atp.integration.configuration.helpers.HttpRequestParseHelper;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.helpers.KafkaAdminHelper;
import org.qubership.atp.integration.configuration.protos.KafkaAuditLoggingMessage;
import org.qubership.atp.integration.configuration.serializers.KafkaProtobufSerializer;
import org.qubership.atp.integration.configuration.service.AuditLoggingService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@ConditionalOnProperty(value={"atp.audit.logging.enable"}, havingValue="true")
@EnableAspectJAutoProxy
@ComponentScans(value={@ComponentScan(value={"org.qubership.atp.integration.configuration"}), @ComponentScan(value={"org.qubership.atp.integration.configuration.*"})})
public class AuditLoggingConfiguration {
    @Value(value="${atp.audit.logging.topic.name}")
    private String topic;
    @Value(value="${atp.audit.logging.topic.partitions:1}")
    private int partitions;
    @Value(value="${atp.audit.logging.topic.replicas:3}")
    private short replicas;
    @Value(value="${atp.reporting.kafka.producer.bootstrap-server}")
    private String bootstrapServers;

    @Bean
    public KafkaProducer<UUID, KafkaAuditLoggingMessage.AuditLoggingMessage> auditLoggingKafkaProducer(KafkaAdminHelper kafkaAdminHelper) {
        kafkaAdminHelper.createOrUpdateTopic(this.topic, this.partitions, this.replicas);
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", this.bootstrapServers);
        properties.setProperty("key.serializer", UUIDSerializer.class.getName());
        properties.setProperty("value.serializer", KafkaProtobufSerializer.class.getName());
        return new KafkaProducer(properties);
    }

    @Bean
    public AuditLoggingService auditLoggingService(Producer<UUID, KafkaAuditLoggingMessage.AuditLoggingMessage> producer, JwtParseHelper jwtHelper, HttpRequestParseHelper requestHelper) {
        return new AuditLoggingService(producer, jwtHelper, requestHelper);
    }

    @Bean
    public Filter auditLoggingFilter(AuditLoggingService auditLoggingService, JwtParseHelper jwtHelper) {
        return new AuditLoggingFilter(auditLoggingService, jwtHelper);
    }
}

