/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.KafkaMailSenderConfiguration;
import org.qubership.atp.integration.configuration.configuration.MultipartSupportConfiguration;
import org.qubership.atp.integration.configuration.feign.MailSenderFeignClient;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.qubership.atp.integration.configuration.service.MailSenderService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@Import(value={KafkaMailSenderConfiguration.class, MultipartSupportConfiguration.class})
public class MailSenderConfiguration {
    @Bean
    @ConditionalOnProperty(name={"kafka.mails.enable"}, havingValue="false", matchIfMissing=true)
    public MailSenderService mailSenderService(MailSenderFeignClient mailSenderFeignClient) {
        return new MailSenderService(null, mailSenderFeignClient);
    }

    @Bean
    @ConditionalOnProperty(name={"kafka.mails.enable"}, havingValue="true")
    public MailSenderService mailSenderServiceWithKafka(KafkaTemplate<UUID, MailRequest> kafkaTemplate, MailSenderFeignClient mailSenderFeignClient) {
        return new MailSenderService(kafkaTemplate, mailSenderFeignClient);
    }
}

