/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.filters;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.mdc.MdcField;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483648)
public class MdcHttpFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MdcHttpFilter.class);
    private final JwtParseHelper jwtParseHelper;
    private final List<String> businessIds;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        MDC.clear();
        this.businessIds.forEach(idName -> this.processHeaders(request, (String)idName));
        this.processUserId(request);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean processHeaders(HttpServletRequest request, String idName) {
        return MdcUtils.put(idName, MdcUtils.getHeaderFromRequest(request, MdcUtils.convertIdNameToHeader(idName)));
    }

    private void processUserId(HttpServletRequest request) {
        String authToken = request.getHeader("Authorization");
        if (authToken != null && StringUtils.startsWithIgnoreCase((CharSequence)authToken, (CharSequence)"Bearer ")) {
            try {
                if (!this.jwtParseHelper.isM2Mtoken(authToken)) {
                    UUID userId = this.jwtParseHelper.getUserIdFromToken(authToken);
                    MdcUtils.put(MdcField.USER_ID.toString(), userId);
                }
            }
            catch (Exception e) {
                log.error("Error while getting userId from token", (Throwable)e);
            }
        }
    }

    public MdcHttpFilter(JwtParseHelper jwtParseHelper, List<String> businessIds) {
        this.jwtParseHelper = jwtParseHelper;
        this.businessIds = businessIds;
    }
}

