/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaAdmin;

public class KafkaAdminHelper {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminHelper.class);
    private final KafkaAdmin kafkaAdmin;

    public void createOrUpdateTopic(String topic, int partitions, short replicas) {
        try {
            log.info("Start createOrUpdateTopic: create or update topic [name={}, partitions={}, replicationFactor={}]", new Object[]{topic, partitions, replicas});
            AdminClient client = AdminClient.create((Map)this.kafkaAdmin.getConfigurationProperties());
            ListTopicsResult listTopicsResult = client.listTopics();
            Set existingTopics = (Set)listTopicsResult.names().get();
            if (existingTopics.contains(topic)) {
                log.debug("createOrUpdateTopic: update topic [name={}, partitions={}]", (Object)topic, (Object)partitions);
                HashMap<String, NewPartitions> newPartitionSet = new HashMap<String, NewPartitions>();
                newPartitionSet.put(topic, NewPartitions.increaseTo((int)partitions));
                client.createPartitions(newPartitionSet).all().get();
            } else {
                log.debug("createOrUpdateTopic: create new topic [name={}, partitions={}]", (Object)topic, (Object)partitions);
                client.createTopics(Collections.singleton(new NewTopic(topic, partitions, replicas)), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get();
            }
        }
        catch (Exception ex) {
            log.error("Cannot create topic [name={}, partitions={}, replicas={}]", new Object[]{topic, partitions, replicas});
        }
    }

    public KafkaAdminHelper(KafkaAdmin kafkaAdmin) {
        this.kafkaAdmin = kafkaAdmin;
    }
}

