/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.ProjectingMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;

public class RecordMessagingMessageListenerAdapter<K, V>
extends MessagingMessageListenerAdapter<K, V>
implements AcknowledgingConsumerAwareMessageListener<K, V> {
    private KafkaListenerErrorHandler errorHandler;

    public RecordMessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, null);
    }

    public RecordMessagingMessageListenerAdapter(Object bean, Method method, @Nullable KafkaListenerErrorHandler errorHandler) {
        super(bean, method);
        this.errorHandler = errorHandler;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        GenericMessage message = this.isConversionNeeded() ? this.toMessagingMessage(record, acknowledgment, consumer) : NULL_MESSAGE;
        if (this.logger.isDebugEnabled() && !(this.getMessageConverter() instanceof ProjectingMessageConverter)) {
            this.logger.debug((CharSequence)("Processing [" + message + "]"));
        }
        try {
            Object result = this.invokeHandler(record, acknowledgment, (Message<?>)message, consumer);
            if (result != null) {
                this.handleResult(result, record, message);
            }
        }
        catch (ListenerExecutionFailedException e) {
            if (this.errorHandler != null) {
                try {
                    Object result;
                    if (message.equals(NULL_MESSAGE)) {
                        message = new GenericMessage(record);
                    }
                    if ((result = this.errorHandler.handleError((Message<?>)message, e, consumer, acknowledgment)) != null) {
                        this.handleResult(result, record, message);
                    }
                }
                catch (Exception ex) {
                    throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener error handler threw an exception for the incoming message", message.getPayload()), ex);
                }
            }
            throw e;
        }
    }
}

