/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.monitoring.undertow.metrics;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.lang.NonNull;
import io.undertow.server.session.SessionManagerStatistics;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowMetrics;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;

public class UndertowSessionMetrics
extends UndertowMetrics {
    private static final String METRIC_NAME_SESSIONS_ACTIVE_MAX = ".sessions.active.max";
    private static final String METRIC_NAME_SESSIONS_ACTIVE_CURRENT = ".sessions.active.current";
    private static final String METRIC_NAME_SESSIONS_CREATED = ".sessions.created";
    private static final String METRIC_NAME_SESSIONS_EXPIRED = ".sessions.expired";
    private static final String METRIC_NAME_SESSIONS_REJECTED = ".sessions.rejected";
    private static final String METRIC_NAME_SESSIONS_ALIVE_MAX = ".sessions.alive.max";

    public UndertowSessionMetrics(UndertowWebServer undertowWebServer) {
        super(undertowWebServer);
    }

    public UndertowSessionMetrics(UndertowWebServer undertowWebServer, String namePrefix) {
        super(undertowWebServer, namePrefix);
    }

    public UndertowSessionMetrics(UndertowWebServer undertowWebServer, String namePrefix, Iterable<Tag> tags) {
        super(undertowWebServer, namePrefix, tags);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry registry, UndertowWebServer undertowWebServer, String namePrefix, Iterable<Tag> tags) {
        if (undertowWebServer instanceof UndertowServletWebServer) {
            SessionManagerStatistics statistics = ((UndertowServletWebServer)undertowWebServer).getDeploymentManager().getDeployment().getSessionManager().getStatistics();
            this.registerSessionStatistics(registry, statistics, namePrefix, tags);
        }
    }

    private void registerSessionStatistics(MeterRegistry registry, SessionManagerStatistics statistics, String namePrefix, Iterable<Tag> tags) {
        Gauge.builder((String)(namePrefix + METRIC_NAME_SESSIONS_ACTIVE_MAX), (Object)statistics, SessionManagerStatistics::getMaxActiveSessions).tags(tags).baseUnit("sessions").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_SESSIONS_ACTIVE_CURRENT), (Object)statistics, SessionManagerStatistics::getActiveSessionCount).tags(tags).baseUnit("sessions").register(registry);
        FunctionCounter.builder((String)(namePrefix + METRIC_NAME_SESSIONS_CREATED), (Object)statistics, SessionManagerStatistics::getCreatedSessionCount).tags(tags).baseUnit("sessions").register(registry);
        FunctionCounter.builder((String)(namePrefix + METRIC_NAME_SESSIONS_EXPIRED), (Object)statistics, SessionManagerStatistics::getExpiredSessionCount).tags(tags).baseUnit("sessions").register(registry);
        FunctionCounter.builder((String)(namePrefix + METRIC_NAME_SESSIONS_REJECTED), (Object)statistics, SessionManagerStatistics::getRejectedSessions).tags(tags).baseUnit("sessions").register(registry);
        TimeGauge.builder((String)(namePrefix + METRIC_NAME_SESSIONS_ALIVE_MAX), (Object)statistics, (TimeUnit)TimeUnit.SECONDS, SessionManagerStatistics::getHighestSessionCount).tags(tags).register(registry);
    }
}

