/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RepresentationConfigurable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.record.annotations.BsonId;
import org.bson.codecs.record.annotations.BsonProperty;
import org.bson.codecs.record.annotations.BsonRepresentation;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;

final class RecordCodec<T extends Record>
implements Codec<T> {
    private static final Logger LOGGER = Loggers.getLogger((String)"RecordCodec");
    private final Class<T> clazz;
    private final Constructor<?> canonicalConstructor;
    private final List<ComponentModel> componentModels;
    private final ComponentModel componentModelForId;
    private final Map<String, ComponentModel> fieldNameToComponentModel;

    RecordCodec(Class<T> clazz, CodecRegistry codecRegistry) {
        this.clazz = (Class)Assertions.notNull((String)"class", clazz);
        this.canonicalConstructor = (Constructor)Assertions.notNull((String)"canonicalConstructor", RecordCodec.getCanonicalConstructor(clazz));
        this.componentModels = RecordCodec.getComponentModels(clazz, codecRegistry);
        this.fieldNameToComponentModel = this.componentModels.stream().collect(Collectors.toMap(ComponentModel::getFieldName, Function.identity()));
        this.componentModelForId = RecordCodec.getComponentModelForId(clazz, this.componentModels);
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        Object[] constructorArguments = new Object[this.componentModels.size()];
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            ComponentModel componentModel = this.fieldNameToComponentModel.get(fieldName);
            if (componentModel == null) {
                reader.skipValue();
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace(String.format("Found property not present in the ClassModel: %s", fieldName));
                continue;
            }
            constructorArguments[componentModel.index] = decoderContext.decodeWithChildContext(componentModel.codec, reader);
        }
        reader.readEndDocument();
        try {
            return (T)((Record)this.canonicalConstructor.newInstance(constructorArguments));
        }
        catch (ReflectiveOperationException e) {
            throw new CodecConfigurationException(String.format("Unable to invoke canonical constructor of record class %s", this.clazz.getName()), (Throwable)e);
        }
    }

    public void encode(BsonWriter writer, T record, EncoderContext encoderContext) {
        writer.writeStartDocument();
        if (this.componentModelForId != null) {
            this.writeComponent(writer, record, this.componentModelForId);
        }
        for (ComponentModel componentModel : this.componentModels) {
            if (componentModel == this.componentModelForId) continue;
            this.writeComponent(writer, record, componentModel);
        }
        writer.writeEndDocument();
    }

    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private void writeComponent(BsonWriter writer, T record, ComponentModel componentModel) {
        try {
            Object componentValue = componentModel.getValue((Record)record);
            if (componentValue != null) {
                writer.writeName(componentModel.getFieldName());
                componentModel.codec.encode(writer, componentValue, EncoderContext.builder().build());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new CodecConfigurationException(String.format("Unable to access value of component %s for record %s", componentModel.getComponentName(), this.clazz.getName()), (Throwable)e);
        }
    }

    private static <T> List<ComponentModel> getComponentModels(Class<T> clazz, CodecRegistry codecRegistry) {
        RecordComponent[] recordComponents = clazz.getRecordComponents();
        ArrayList<ComponentModel> componentModels = new ArrayList<ComponentModel>(recordComponents.length);
        for (int i = 0; i < recordComponents.length; ++i) {
            componentModels.add(new ComponentModel(recordComponents[i], codecRegistry, i));
        }
        return componentModels;
    }

    @Nullable
    private static <T> ComponentModel getComponentModelForId(Class<T> clazz, List<ComponentModel> componentModels) {
        List<ComponentModel> componentModelsForId = componentModels.stream().filter(componentModel -> componentModel.getFieldName().equals("_id")).toList();
        if (componentModelsForId.size() > 1) {
            throw new CodecConfigurationException(String.format("Record %s has more than one _id component", clazz.getName()));
        }
        return componentModelsForId.stream().findFirst().orElse(null);
    }

    private static <T> Constructor<?> getCanonicalConstructor(Class<T> clazz) {
        Object[] recordComponentTypes = (Class[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!Arrays.equals(constructor.getParameterTypes(), recordComponentTypes)) continue;
            return constructor;
        }
        throw new AssertionError((Object)String.format("Could not find canonical constructor for record %s", clazz.getName()));
    }

    private static Class<?> toWrapper(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        return clazz;
    }

    private static final class ComponentModel {
        private final RecordComponent component;
        private final Codec<?> codec;
        private final int index;
        private final String fieldName;

        private ComponentModel(RecordComponent component, CodecRegistry codecRegistry, int index) {
            this.component = component;
            this.codec = ComponentModel.computeCodec(component, codecRegistry);
            this.index = index;
            this.fieldName = ComponentModel.computeFieldName(component);
        }

        String getComponentName() {
            return this.component.getName();
        }

        String getFieldName() {
            return this.fieldName;
        }

        Object getValue(Record record) throws InvocationTargetException, IllegalAccessException {
            return this.component.getAccessor().invoke((Object)record, new Object[0]);
        }

        private static Codec<?> computeCodec(RecordComponent component, CodecRegistry codecRegistry) {
            Codec codec = codecRegistry.get(RecordCodec.toWrapper(component.getType()));
            BsonRepresentation bsonRepresentationAnnotation = component.getAnnotation(BsonRepresentation.class);
            if (bsonRepresentationAnnotation != null) {
                if (codec instanceof RepresentationConfigurable) {
                    RepresentationConfigurable representationConfigurable = (RepresentationConfigurable)codec;
                    codec = representationConfigurable.withRepresentation(bsonRepresentationAnnotation.value());
                } else {
                    throw new CodecConfigurationException(String.format("Codec for %s must implement RepresentationConfigurable to support BsonRepresentation", codec.getEncoderClass()));
                }
            }
            return codec;
        }

        private static String computeFieldName(RecordComponent component) {
            if (component.isAnnotationPresent(BsonId.class)) {
                return "_id";
            }
            if (component.isAnnotationPresent(BsonProperty.class)) {
                return component.getAnnotation(BsonProperty.class).value();
            }
            return component.getName();
        }
    }
}

