/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.scheduler;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.qubership.atp.tdm.model.DeletedTablesHistory;
import org.qubership.atp.tdm.model.ProjectInformation;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.DeletedTablesHistoryRepository;
import org.qubership.atp.tdm.repo.ProjectInformationRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TableCleanerJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(TableCleanerJob.class);
    @Autowired
    private CatalogRepository catalogRepository;
    @Autowired
    private ProjectInformationRepository projectInformationRepository;
    @Autowired
    private TestDataService testDataService;
    @Autowired
    private DeletedTablesHistoryRepository deletedTablesHistoryRepository;
    @Value(value="${default.table.expiration.months:1}")
    private int defaultExpirationMonths;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date dt = new Date();
        List projectInformationList = this.projectInformationRepository.findAll();
        if (projectInformationList.isEmpty()) {
            this.catalogRepository.findByLastUsageBefore(TableCleanerJob.minusMonths(dt, this.defaultExpirationMonths)).forEach(table -> this.deleteTable((TestDataTableCatalog)table, dt));
        } else {
            this.projectInformationRepository.findAll().forEach(project -> {
                long expirationMonths = project.getExpirationMonthsTimeout() == 0L ? (long)this.defaultExpirationMonths : project.getExpirationMonthsTimeout();
                this.catalogRepository.findByProjectIdAndLastUsageBefore(project.getProjectId(), TableCleanerJob.minusMonths(dt, expirationMonths)).forEach(table -> this.deleteTable((TestDataTableCatalog)table, dt));
            });
            this.catalogRepository.findByProjectIdNotInAndLastUsageBefore(this.projectInformationRepository.findAll().stream().map(ProjectInformation::getProjectId).collect(Collectors.toList()), TableCleanerJob.minusMonths(dt, this.defaultExpirationMonths)).forEach(table -> this.deleteTable((TestDataTableCatalog)table, dt));
        }
    }

    private void deleteTable(@NonNull TestDataTableCatalog table, Date date) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        log.info("Delete expired table: name:[{}], title:[{}], env:[{}], system[{}], project[{}], last usage [{}]", new Object[]{table.getTableName(), table.getTableTitle(), table.getEnvironmentId(), table.getSystemId(), table.getProjectId(), table.getLastUsage()});
        this.testDataService.deleteTestData(table.getTableName());
        this.deletedTablesHistoryRepository.save(new DeletedTablesHistory(table.getTableName(), table.getProjectId(), table.getTableTitle(), table.getSystemId(), table.getEnvironmentId(), date));
    }

    private static Date minusMonths(Date dt, long month) {
        LocalDate localDate = dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate newDate = localDate.minusMonths(month);
        return Date.from(newDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

