/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.statistics;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.tdm.utils.scheduler.ScheduleConfig;

@Entity
public class TestDataTableUsersMonitoring
implements ScheduleConfig {
    @Id
    @Column(name="project_id")
    private UUID projectId;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="cron_expression")
    private String cronExpression;
    @Column(name="recipients")
    private String recipients;
    @Column(name="html_report")
    private boolean htmlReport;
    @Column(name="csv_report")
    private boolean csvReport;
    @Column(name="days_count")
    private int daysCount;

    @Override
    public UUID getId() {
        return this.projectId;
    }

    @Override
    public String getSchedule() {
        return this.cronExpression;
    }

    @Override
    public boolean isScheduled() {
        return this.enabled && StringUtils.isNotEmpty((String)this.cronExpression);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public boolean isHtmlReport() {
        return this.htmlReport;
    }

    public boolean isCsvReport() {
        return this.csvReport;
    }

    public int getDaysCount() {
        return this.daysCount;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public void setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
    }

    public void setCsvReport(boolean csvReport) {
        this.csvReport = csvReport;
    }

    public void setDaysCount(int daysCount) {
        this.daysCount = daysCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDataTableUsersMonitoring)) {
            return false;
        }
        TestDataTableUsersMonitoring other = (TestDataTableUsersMonitoring)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isHtmlReport() != other.isHtmlReport()) {
            return false;
        }
        if (this.isCsvReport() != other.isCsvReport()) {
            return false;
        }
        if (this.getDaysCount() != other.getDaysCount()) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$cronExpression = this.getCronExpression();
        String other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        String this$recipients = this.getRecipients();
        String other$recipients = other.getRecipients();
        return !(this$recipients == null ? other$recipients != null : !this$recipients.equals(other$recipients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestDataTableUsersMonitoring;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isHtmlReport() ? 79 : 97);
        result = result * 59 + (this.isCsvReport() ? 79 : 97);
        result = result * 59 + this.getDaysCount();
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
        String $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : $recipients.hashCode());
        return result;
    }

    public String toString() {
        return "TestDataTableUsersMonitoring(projectId=" + this.getProjectId() + ", enabled=" + this.isEnabled() + ", cronExpression=" + this.getCronExpression() + ", recipients=" + this.getRecipients() + ", htmlReport=" + this.isHtmlReport() + ", csvReport=" + this.isCsvReport() + ", daysCount=" + this.getDaysCount() + ")";
    }
}

