/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl.loader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.qubership.atp.tdm.exceptions.internal.TdmTestDataParsingException;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestDataExcelLoader {
    private static final Logger log = LoggerFactory.getLogger(TestDataExcelLoader.class);
    private final OPCPackage xlsxPackage;
    private final TestDataTable testDataTable = new TestDataTable();
    private final Map<Integer, String> columns = new HashMap<Integer, String>();
    private List<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();

    public TestDataExcelLoader(OPCPackage pkg) {
        this.xlsxPackage = pkg;
    }

    public TestDataTable process() throws Exception {
        log.info("Excel parsing started.");
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        try (InputStream stream = (InputStream)xssfReader.getSheetsData().next();){
            this.processSheet(strings, new TestDataSheetContentsHandler(), stream);
        }
        this.testDataTable.setColumns(this.columns.values().stream().map(c -> new TestDataTableColumn(new TestDataTableColumnIdentity("", (String)c))).collect(Collectors.toList()));
        this.testDataTable.setData(this.rows);
        log.info("Excel parsing finished.");
        return this.testDataTable;
    }

    private void processSheet(ReadOnlySharedStringsTable strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream inputStream) throws Exception {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(inputStream);
        try {
            XMLReader sheetParser = TestDataExcelLoader.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(null, null, strings, sheetHandler, formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (SAXException e) {
            log.error("SAX parser couldn't handle your excel file.", (Throwable)e);
            throw new TdmTestDataParsingException();
        }
    }

    public static XMLReader newXMLReader() throws SAXException {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return saxFactory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new SAXException("Unable to create safe XMLReader", e);
        }
    }

    private class TestDataSheetContentsHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private final String[] systemColumns = new String[]{"SELECTED", "OCCUPIED_DATE", "OCCUPIED_BY", "CREATED_WHEN"};
        private List<Integer> workCol = new ArrayList<Integer>();
        private Map<String, Object> row;
        private int currentRow = -1;

        private TestDataSheetContentsHandler() {
        }

        public void startRow(int rowNum) {
            this.currentRow = rowNum;
            if (this.currentRow > 0) {
                this.row = new HashMap<String, Object>();
            }
        }

        public void endRow(int rowNum) {
            if (this.currentRow > 0) {
                TestDataExcelLoader.this.rows.add(this.row);
            }
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            int currentCol = new CellReference(cellReference).getCol() + 1;
            if (this.currentRow == 0) {
                if (!Arrays.asList(this.systemColumns).contains(formattedValue)) {
                    TestDataExcelLoader.this.columns.put(currentCol, formattedValue);
                    this.workCol.add(currentCol);
                }
            } else if (this.workCol.contains(currentCol)) {
                this.row.put((String)TestDataExcelLoader.this.columns.get(currentCol), formattedValue);
            }
        }

        public void headerFooter(String s, boolean b, String s1) {
        }
    }
}

