/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.mailsender;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.qubership.atp.integration.configuration.service.MailSenderService;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.file.TdmMultipartFileException;
import org.qubership.atp.tdm.exceptions.internal.TdmGetImageFromHighchartException;
import org.qubership.atp.tdm.model.mail.charts.ChartSeries;
import org.qubership.atp.tdm.model.statistics.TestAvailableDataMonitoring;
import org.qubership.atp.tdm.model.statistics.available.AvailableDataByColumnStats;
import org.qubership.atp.tdm.model.statistics.available.TableAvailableDataStats;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.client.HighchartsFeignClient;
import org.qubership.atp.tdm.utils.AvailableStatisticUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class AvailableDataStatisticsMailSender {
    private static final Logger log = LoggerFactory.getLogger(AvailableDataStatisticsMailSender.class);
    private static final String IMAGE_TEMPLATE = "<img src=\"cid:%s\" />";
    private final String mailSenderFrom;
    private final HighchartsFeignClient highchartsFeignClient;
    private final Configuration configuration;
    private final StatisticsService statisticsService;
    private final MailSenderService mailSender;
    private final String mailSenderSubject;
    private final String mailSenderTemplate;
    private final String mailSenderPath;
    private final EnvironmentsService environmentsService;
    private final String highchartJsonPath;
    private final String highchartJsonTemplate;

    @Autowired
    private AvailableDataStatisticsMailSender(@Nonnull Configuration configuration, @Nonnull StatisticsService statisticsService, @Nonnull MailSenderService mailSender, @Nonnull EnvironmentsService environmentsService, @Value(value="${mail.sender.available.statistics.subject}") String mailSenderSubject, @Value(value="${mail.sender.from}") String mailSenderFrom, @Value(value="${mail.sender.available.statistics.template}") String mailSenderTemplate, @Value(value="${highcharts.template.path}") String highchartJsonTemplatePath, @Value(value="${mail.sender.available.statistics.path}") String mailSenderPath, @Value(value="${highcharts.template}") String highchartJsonTemplate, HighchartsFeignClient highchartsFeignClient) {
        this.configuration = configuration;
        this.statisticsService = statisticsService;
        this.mailSender = mailSender;
        this.mailSenderSubject = mailSenderSubject;
        this.mailSenderTemplate = mailSenderTemplate;
        this.mailSenderPath = mailSenderPath;
        this.environmentsService = environmentsService;
        this.highchartJsonPath = highchartJsonTemplatePath;
        this.highchartJsonTemplate = highchartJsonTemplate;
        this.highchartsFeignClient = highchartsFeignClient;
        this.mailSenderFrom = mailSenderFrom;
    }

    public void send(UUID systemId, UUID environmentId) {
        log.info("Sending available data statistic for environmentId {} and systemId {}", (Object)environmentId, (Object)systemId);
        TestAvailableDataMonitoring monitoring = this.statisticsService.getAvailableDataMonitoringConfig(systemId, environmentId);
        log.trace("Monitoring config: {}", (Object)monitoring);
        String projectName = this.environmentsService.getLazyProjectById(this.environmentsService.getLazyEnvironment(environmentId).getProjectId()).getName();
        MailRequest mailRequest = new MailRequest();
        mailRequest.setFrom(this.mailSenderFrom);
        mailRequest.setTo(monitoring.getRecipients());
        mailRequest.setSubject(String.format(this.mailSenderSubject, projectName));
        try {
            AvailableDataByColumnStats statistics = this.statisticsService.getAvailableDataInColumn(systemId, environmentId);
            log.trace("Statistic: {}", (Object)statistics);
            String environmentName = this.environmentsService.getEnvNameById(environmentId);
            List<MultipartFile> images = this.buildImages(statistics);
            String content = this.buildMessageContent(this.configuration, statistics, environmentName, monitoring.getThreshold(), images.stream().map(image -> String.format(IMAGE_TEMPLATE, image.getOriginalFilename())).collect(Collectors.toList()));
            log.trace("Message content: {}", (Object)content);
            mailRequest.setContent(content);
            this.mailSender.sendWithInline(mailRequest, images);
        }
        catch (Exception e) {
            String content = e.getMessage();
            mailRequest.setContent(content);
            this.mailSender.send(mailRequest);
        }
    }

    private String buildMessageContent(Configuration freemarkerConfig, final AvailableDataByColumnStats messageContent, final String environmentName, final int threshold, final List<String> highcharts) {
        log.debug("Build message content: message content {}, environmentName {}, threshold {}, highcharts {}", new Object[]{messageContent, environmentName, threshold, highcharts});
        try {
            freemarkerConfig.setDirectoryForTemplateLoading(new File(this.mailSenderPath));
            Template template = freemarkerConfig.getTemplate(this.mailSenderTemplate);
            StringWriter writer = new StringWriter();
            template.process((Object)new HashMap<String, Object>(){
                {
                    this.put("environment", environmentName);
                    this.put("statistic", messageContent);
                    this.put("threshold", threshold);
                    this.put("highcharts", highcharts);
                }
            }, (Writer)writer);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
        catch (TemplateException | IOException bmc) {
            String errorMsg = "Error observed while building message content for Test Data users monitoring. ";
            String content = errorMsg + bmc.getMessage();
            log.error(errorMsg, bmc);
            return content;
        }
    }

    private List<MultipartFile> buildImages(AvailableDataByColumnStats statistics) {
        log.debug("Building image for stats: {}", (Object)statistics);
        ArrayList<MultipartFile> images = new ArrayList<MultipartFile>();
        ArrayList<String> currentCategories = new ArrayList<String>();
        ArrayList<ChartSeries> chartSeriesList = new ArrayList<ChartSeries>();
        int currentColumnCount = 0;
        Iterator<TableAvailableDataStats> statsIterator = statistics.getStatistics().iterator();
        while (statsIterator.hasNext()) {
            ChartSeries series;
            TableAvailableDataStats stats = statsIterator.next();
            if (currentColumnCount == 0) {
                currentCategories.addAll(stats.getOptions().keySet());
                currentColumnCount = stats.getOptions().size();
                series = new ChartSeries(false, new ArrayList<Integer>(stats.getOptions().values()), stats.getTableTitle(), AvailableStatisticUtils.getColorByIndex(statistics.getStatistics().indexOf(stats)));
                chartSeriesList.add(series);
            } else if (currentColumnCount + stats.getOptions().size() < 30) {
                currentCategories.add("");
                currentCategories.addAll(stats.getOptions().keySet());
                ArrayList<Integer> valueList = new ArrayList<Integer>(Collections.nCopies(currentColumnCount + 1, 0));
                currentColumnCount += stats.getOptions().size() + 1;
                valueList.addAll(stats.getOptions().values());
                ChartSeries series2 = new ChartSeries(false, valueList, stats.getTableTitle(), AvailableStatisticUtils.getColorByIndex(statistics.getStatistics().indexOf(stats)));
                chartSeriesList.add(series2);
            } else {
                try {
                    images.add(this.getImageFromHighchartService(currentCategories, chartSeriesList));
                }
                catch (Exception e) {
                    log.error("Cannot create MultipartFile for categories {} and chart series list {}", new Object[]{currentCategories, chartSeriesList, e});
                    throw e;
                }
                currentCategories.clear();
                chartSeriesList.clear();
                currentCategories.addAll(stats.getOptions().keySet());
                currentColumnCount = stats.getOptions().size();
                series = new ChartSeries(false, new ArrayList<Integer>(stats.getOptions().values()), stats.getTableTitle(), AvailableStatisticUtils.getColorByIndex(statistics.getStatistics().indexOf(stats)));
                chartSeriesList.add(series);
            }
            if (statsIterator.hasNext()) continue;
            try {
                images.add(this.getImageFromHighchartService(currentCategories, chartSeriesList));
            }
            catch (Exception e) {
                log.error("Cannot create MultipartFile for categories {} and chart series list {}", new Object[]{currentCategories, chartSeriesList, e});
                throw e;
            }
        }
        return images;
    }

    private MultipartFile getImageFromHighchartService(List<String> categories, List<ChartSeries> chartSeriesList) {
        log.debug("Getting image from highchart service for categories {} and chart series list {}", categories, chartSeriesList);
        ResponseEntity<Resource> response = this.highchartsFeignClient.create(AvailableStatisticUtils.buildHighChartConfigurationBody(this.highchartJsonPath + this.highchartJsonTemplate, categories, chartSeriesList));
        if (!response.getStatusCode().is2xxSuccessful()) {
            String errorMessage = String.format("Status code isn't successfull: %s", response.getStatusCode().value());
            log.error(errorMessage);
            throw new TdmGetImageFromHighchartException(errorMessage);
        }
        String fileName = System.currentTimeMillis() + ".png";
        MockMultipartFile multipartFileToSend = null;
        try (InputStream stream = ((Resource)response.getBody()).getInputStream();){
            multipartFileToSend = new MockMultipartFile("application", fileName, MediaType.APPLICATION_OCTET_STREAM.toString(), stream);
        }
        catch (Exception e) {
            log.error(String.format("Cannot create multipart file: %s", e.getMessage()), (Throwable)e);
            throw new TdmMultipartFileException(e.getMessage());
        }
        return multipartFileToSend;
    }
}

