package org.qubership.atp.tdm.controllers.api.dto.statistics;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.tdm.controllers.api.dto.statistics.ConsumedStatisticsItemDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ConsumedStatisticsDto
 */

@JsonTypeName("ConsumedStatistics")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:42:48.018280015Z[Etc/UTC]")
public class ConsumedStatisticsDto {

  @JsonProperty("dates")
  @Valid
  private List<String> dates = null;

  @JsonProperty("items")
  @Valid
  private List<ConsumedStatisticsItemDto> items = null;

  public ConsumedStatisticsDto dates(List<String> dates) {
    this.dates = dates;
    return this;
  }

  public ConsumedStatisticsDto addDatesItem(String datesItem) {
    if (this.dates == null) {
      this.dates = new ArrayList<>();
    }
    this.dates.add(datesItem);
    return this;
  }

  /**
   * Get dates
   * @return dates
  */
  
  @Schema(name = "dates", required = false)
  public List<String> getDates() {
    return dates;
  }

  public void setDates(List<String> dates) {
    this.dates = dates;
  }

  public ConsumedStatisticsDto items(List<ConsumedStatisticsItemDto> items) {
    this.items = items;
    return this;
  }

  public ConsumedStatisticsDto addItemsItem(ConsumedStatisticsItemDto itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
  */
  @Valid 
  @Schema(name = "items", required = false)
  public List<ConsumedStatisticsItemDto> getItems() {
    return items;
  }

  public void setItems(List<ConsumedStatisticsItemDto> items) {
    this.items = items;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsumedStatisticsDto consumedStatistics = (ConsumedStatisticsDto) o;
    return Objects.equals(this.dates, consumedStatistics.dates) &&
        Objects.equals(this.items, consumedStatistics.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dates, items);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsumedStatisticsDto {\n");
    sb.append("    dates: ").append(toIndentedString(dates)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

