/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.ei;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.tdm.ei.AbstractExportImportTest;
import org.qubership.atp.tdm.ei.TdmImportExecutor;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class TdmImportExecutorTest
extends AbstractExportImportTest {
    private final String validImportFile = "src/test/resources/ei-resources/valid-import";
    private final String thereIsNoProjectInEnvServiceImportFile = "src/test/resources/ei-resources/incorrect-imports/thereIsNoProject";
    private final String thereIsNoEnvironmentInEnvServiceImportFile = "src/test/resources/ei-resources/incorrect-imports/thereIsNoEnvironment";
    private final String thereIsNoSystemInEnvServiceImportFile = "src/test/resources/ei-resources/incorrect-imports/thereIsNoSystem";
    private static final UUID projectId = UUID.fromString("6b90558d-f0c7-448a-b701-f04d95ad655d");
    private static final UUID environmentId = UUID.fromString("9fd33044-d693-4b24-8d9b-67277e120631");
    private static final UUID systemId = UUID.fromString("eef70313-1ccc-4be7-ba3c-787654abf863");
    private static final List<LazyProject> projectsList = new ArrayList<LazyProject>();
    private static final List<LazyEnvironment> environmentsList = new ArrayList<LazyEnvironment>();
    private static final List<LazySystem> systemsList = new ArrayList<LazySystem>();
    @Autowired
    TdmImportExecutor importExecutor;
    @Autowired
    JdbcTemplate jdbcTemplate;
    private static final LazyEnvironment lazyEnvironment = new LazyEnvironment(){
        {
            this.setName("Lazy Environment");
            this.setId(environmentId);
        }
    };
    private static final LazyProject lazyProject = new LazyProject(){
        {
            this.setName("Lazy Project");
            this.setId(projectId);
        }
    };
    private static final LazySystem lazySystem = new LazySystem(){
        {
            this.setName("Lazy System");
            this.setId(systemId);
        }
    };

    @BeforeEach
    public void setUp() {
        projectsList.add(lazyProject);
        environmentsList.add(lazyEnvironment);
        systemsList.add(lazySystem);
        Mockito.when((Object)this.environmentsService.getLazyProjects()).thenReturn(projectsList);
        Mockito.when((Object)this.environmentsService.getLazyEnvironments((UUID)ArgumentMatchers.any())).thenReturn(environmentsList);
        Mockito.when((Object)this.environmentsService.getLazySystems((UUID)ArgumentMatchers.any())).thenReturn(systemsList);
        Mockito.when((Object)this.environmentsService.getEnvNameById((UUID)ArgumentMatchers.any())).thenReturn((Object)"test");
        Mockito.when((Object)this.environmentsService.getLazyEnvironmentsShort((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(lazyEnvironment));
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(dbConnection));
    }

    @Test
    public void importData_importFile_importedSuccessfully() throws Exception {
        this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/valid-import", new String[0]));
        this.importExecutor.importData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/valid-import", new String[0]));
        Assertions.assertEquals((int)6, (int)this.jdbcTemplate.queryForList("select * from tdm_test_data_export_import").size());
    }

    @Test
    public void validateData_validateImportingFile_fileIsValid() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/valid-import", new String[0]));
        Assertions.assertTrue((boolean)validationResult.isValid());
    }

    @Test
    public void validateData_validateImportingFile_thereAreNoMessagesInValidationResult() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/valid-import", new String[0]));
        Assertions.assertTrue((boolean)validationResult.getMessages().isEmpty());
    }

    @Test
    public void validateData_validateImportingFile_thereIsNoProjectInEnvsService() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/incorrect-imports/thereIsNoProject", new String[0]));
        Assertions.assertEquals((Object)"Project with id:[13fec4c4-9c27-42e2-a4b3-250415525603] wasn't found in env service.", validationResult.getMessages().get(0));
    }

    @Test
    public void validateData_validateImportingFile_thereIsNoProjectInEnvsServiceFileIsIncorrect() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/incorrect-imports/thereIsNoProject", new String[0]));
        Assertions.assertFalse((boolean)validationResult.isValid());
    }

    @Test
    public void validateData_validateImportingFile_thereIsNoEnvironmentInEnvsService() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/incorrect-imports/thereIsNoEnvironment", new String[0]));
        Assertions.assertEquals((Object)"Environment with id:[da027247-bb3b-41cf-a8e8-247a368065e1] wasn't found in env service.", validationResult.getMessages().get(0));
    }

    @Test
    public void validateData_validateImportingFile_thereIsNoEnvironmentInEnvsServiceFileIsIncorrect() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/incorrect-imports/thereIsNoEnvironment", new String[0]));
        Assertions.assertFalse((boolean)validationResult.isValid());
    }

    @Test
    public void validateData_validateImportingFile_thereIsNoSystemInEnvsService() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/incorrect-imports/thereIsNoSystem", new String[0]));
        Assertions.assertEquals((Object)"System with id:[dc42601e-54c5-4511-bd5b-bc588b343051] wasn't found in env service.", validationResult.getMessages().get(0));
    }

    @Test
    public void validateData_validateImportingFile_thereIsNoSystemInEnvsServiceFileIsIncorrect() throws Exception {
        ValidationResult validationResult = this.importExecutor.validateData(new ExportImportData(exportImportProjectId, new ExportScope(), ExportFormat.ATP), Paths.get("src/test/resources/ei-resources/incorrect-imports/thereIsNoSystem", new String[0]));
        Assertions.assertFalse((boolean)validationResult.isValid());
    }
}

