/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.matchers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class JsonMatcher
extends TypeSafeMatcher<String> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper INDENT_OUTPUT = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final String er;

    private JsonMatcher(String er) {
        this.er = er;
    }

    public static JsonMatcher isMinified(String prettyEr) throws IOException {
        return JsonMatcher.is(JsonMatcher.doMinifiedOutput(prettyEr));
    }

    private static JsonMatcher is(String er) {
        return new JsonMatcher(er);
    }

    private static String tryDoIndentOutput(String json) {
        try {
            return INDENT_OUTPUT.writeValueAsString((Object)OBJECT_MAPPER.readTree(json));
        }
        catch (Throwable ignore) {
            return json;
        }
    }

    private static String doMinifiedOutput(String json) throws IOException {
        return OBJECT_MAPPER.writeValueAsString((Object)OBJECT_MAPPER.readTree(json));
    }

    protected boolean matchesSafely(String ar) {
        return Objects.equals(this.er, ar);
    }

    public void describeTo(Description description) {
        description.appendText("json: ").appendText(JsonMatcher.tryDoIndentOutput(this.er));
    }

    protected void describeMismatchSafely(String ar, Description mismatchDescription) {
        mismatchDescription.appendText("was: ").appendText(JsonMatcher.tryDoIndentOutput(ar));
    }
}

