/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.refresh.RefreshResults;
import org.qubership.atp.tdm.model.refresh.TestDataRefreshConfig;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;

public class DataRefreshServiceTest
extends AbstractTestDataTest {
    private static final UUID projectId = UUID.randomUUID();
    private static final Project project = new Project(){
        {
            this.setName("Test Data Refresh Project");
            this.setId(projectId);
            this.setEnvironments(Collections.singletonList(environment));
        }
    };
    @MockBean
    private MetricService metricServiceMock;
    @Autowired
    private DataRefreshService dataRefreshService;

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.environmentsService.getLazyProjectById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
        Mockito.when((Object)this.environmentsService.getLazyEnvironment((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
        Mockito.when((Object)this.environmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void saveRefreshConfig_saveConfig_dataRefreshConfigigSaved() throws Exception {
        Integer queryTimeout = 30;
        String query = "select sim from tdm_test_data_refresh_unoccupied_table";
        String tableTitle = "TDM Test Data Refresh Save Config";
        String tableName = "tdm_test_data_refresh_save_config";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName, query);
        TestDataRefreshConfig config = new TestDataRefreshConfig(UUID.randomUUID(), false, "0 0/5 * * * ?", false, queryTimeout);
        this.dataRefreshService.saveRefreshConfig(tableName, queryTimeout, config);
        TestDataTableCatalog catalog = this.catalogRepository.findByTableName(tableName);
        Assertions.assertEquals((Object)config.getId(), (Object)catalog.getRefreshConfigId());
        TestDataRefreshConfig actualConfig = this.dataRefreshService.getRefreshConfig(config.getId());
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)config, (Object)actualConfig);
    }

    @Test
    public void runRefresh_runEnabledRefreshConfig_returnsRefreshResults() throws Exception {
        Integer queryTimeout = 30;
        this.createTestDataTable("tdm_test_data_refresh_source_table");
        String tableTitle = "TDM Test Data Run Refresh";
        String tableName = "tdm_test_data_run_refresh";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.createTestDataTable(tableName);
        Mockito.when((Object)this.environmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
        this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), system.getName(), tableTitle, "select SIM from tdm_test_data_refresh_source_table", queryTimeout);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        TestDataRefreshConfig config = new TestDataRefreshConfig(UUID.randomUUID(), true, "0 0/5 * * * ?", false, queryTimeout);
        this.dataRefreshService.saveRefreshConfig(tableName, queryTimeout, config);
        RefreshResults refreshResults = this.dataRefreshService.runRefresh(config.getId());
        this.deleteTestDataTableIfExists("tdm_test_data_refresh_source_table");
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)new RefreshResults(6), (Object)refreshResults);
    }

    @Test
    public void runRefresh_runDisabledRefreshConfig_returnsEmptyRefreshResults() throws Exception {
        Integer queryTimeout = 30;
        String query = "select sim from tdm_test_data_refresh_unoccupied_table";
        String tableName = "tdm_test_data_run_refresh_disabled";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Test Data Run Refresh Disabled", tableName, query);
        Mockito.when((Object)this.environmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
        TestDataRefreshConfig config = new TestDataRefreshConfig(UUID.randomUUID(), false, "0 0/5 * * * ?", false, queryTimeout);
        this.dataRefreshService.saveRefreshConfig(tableName, queryTimeout, config);
        RefreshResults refreshResults = this.dataRefreshService.runRefresh(config.getId());
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)new RefreshResults(0), (Object)refreshResults);
    }

    @Test
    public void runRefresh_runUnoccupiedRefresh_returnsRefreshResults() {
        TestDataTable sourceTable = this.createTestDataTable("tdm_test_data_refresh_unoccupied_table");
        String query = "select sim from tdm_test_data_refresh_unoccupied_table";
        String tableName = "tdm_test_data_unoccupied_refresh";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Test Data Run Refresh Disabled", tableName, query);
        TestDataTable table = this.testDataService.getTestData(tableName);
        int countOccupiedRows = 2;
        List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser1DRST", rowIdsToOccupy);
        Mockito.when((Object)this.environmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
        int actualOccupiedRows = this.testDataService.getTestData(tableName, null, null, null, null, Boolean.valueOf(true)).getData().size();
        Assertions.assertEquals((int)countOccupiedRows, (int)actualOccupiedRows);
        int actualRows = this.testDataService.getTestData(tableName).getRecords() + countOccupiedRows;
        this.deleteTestDataTableIfExists("tdm_test_data_refresh_unoccupied_table");
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((int)sourceTable.getData().size(), (int)actualRows);
    }

    @Test
    public void refreshConfig_saveConfigWithOutTableNams_returnError() {
        String tableName = "";
        String cron = "0 0 9 ? * *";
        try {
            TestDataRefreshConfig config = new TestDataRefreshConfig(UUID.randomUUID(), true, cron, false, Integer.valueOf(30));
            this.dataRefreshService.saveRefreshConfig(tableName, Integer.valueOf(30), config);
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Table Name is null", (Object)e.getMessage());
        }
    }
}

