/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.qubership.atp.tdm.AbstractTest;
import org.qubership.atp.tdm.service.SchedulerService;
import org.qubership.atp.tdm.utils.scheduler.ScheduleConfig;
import org.springframework.beans.factory.annotation.Autowired;

public class SchedulerServiceTest
extends AbstractTest {
    private static final String SCHED_GROUP = "SchedulerService";
    @Autowired
    private SchedulerService schedulerService;

    @Test
    public void schedulerService_reschedule_scheduleRescheduled() throws SchedulerException {
        UUID configId = UUID.randomUUID();
        FakeScheduleConfig config = new FakeScheduleConfig(configId, "0 0/1 * * * ?", true);
        JobDetail job = JobBuilder.newJob(Job.class).withIdentity(configId.toString(), SCHED_GROUP).build();
        this.schedulerService.reschedule(job, (ScheduleConfig)config, SCHED_GROUP);
        Assertions.assertTrue((boolean)this.schedulerService.checkExists(job.getKey()));
    }

    @Test
    public void schedulerService_rescheduleDisabledJob_scheduleRescheduled() {
        UUID configId = UUID.randomUUID();
        FakeScheduleConfig config = new FakeScheduleConfig(configId, "0 0/1 * * * ?", true);
        JobDetail job = JobBuilder.newJob(Job.class).withIdentity(configId.toString(), SCHED_GROUP).build();
        this.schedulerService.reschedule(job, (ScheduleConfig)config, SCHED_GROUP);
        Assertions.assertTrue((boolean)this.schedulerService.checkExists(job.getKey()));
        config.setEnabled(false);
        this.schedulerService.reschedule(job, (ScheduleConfig)config, SCHED_GROUP);
        Assertions.assertFalse((boolean)this.schedulerService.checkExists(job.getKey()));
    }

    @Test
    public void schedulerService_deleteJob_jobDeleted() throws Exception {
        UUID configId = UUID.randomUUID();
        FakeScheduleConfig config = new FakeScheduleConfig(configId, "0 0/1 * * * ?", true);
        JobDetail job = JobBuilder.newJob(Job.class).withIdentity(configId.toString(), SCHED_GROUP).build();
        this.schedulerService.reschedule(job, (ScheduleConfig)config, SCHED_GROUP);
        Thread.sleep(3000L);
        Assertions.assertTrue((boolean)this.schedulerService.checkExists(job.getKey()));
    }

    private class FakeScheduleConfig
    implements ScheduleConfig {
        private UUID id;
        private String schedule;
        private boolean enabled;

        public FakeScheduleConfig(UUID id, String schedule, boolean enabled) {
            this.id = id;
            this.schedule = schedule;
            this.enabled = enabled;
        }

        public boolean isScheduled() {
            return this.enabled && StringUtils.isNotEmpty((String)this.schedule);
        }

        public UUID getId() {
            return this.id;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FakeScheduleConfig)) {
                return false;
            }
            FakeScheduleConfig other = (FakeScheduleConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$schedule = this.getSchedule();
            String other$schedule = other.getSchedule();
            return !(this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FakeScheduleConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $schedule = this.getSchedule();
            result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerServiceTest.FakeScheduleConfig(id=" + this.getId() + ", schedule=" + this.getSchedule() + ", enabled=" + this.isEnabled() + ")";
        }
    }
}

