/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.notification.environments;

import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentEventType;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentsEventKafkaListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Disabled
public class EnvironmentEventKafkaListenerTest
extends AbstractTestDataTest {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final int delayForReceiveNotification = 5;
    @SpyBean
    EnvironmentsEventKafkaListener kafkaListener;
    @Value(value="${kafka.environments.topic}")
    private String topic;
    @Autowired
    public KafkaTemplate<String, String> kafkaTemplate;

    @Test
    public void envKafkaListener_sendSomeMessage_catchSentMessage() {
        this.kafkaTemplate.send(this.topic, (Object)this.createMessageToDeleteTable(EnvironmentEventType.DELETE));
        ((EnvironmentsEventKafkaListener)Mockito.verify((Object)this.kafkaListener, (VerificationMode)Mockito.timeout((long)5000L))).listen(this.createMessageToDeleteTable(EnvironmentEventType.DELETE));
    }

    @Test
    public void envKafkaListener_deleteTablesByEnvironment_catalogRepoHasNoDeletedTable() throws InterruptedException {
        this.createTestDataTableCatalog(UUID.randomUUID(), systemId, environmentId, "Test Table", "table_name_project");
        long elementsBeforeDeleting = this.catalogRepository.findByEnvironmentId(environmentId).size();
        this.kafkaTemplate.send(this.topic, (Object)this.createMessageToDeleteTable(EnvironmentEventType.DELETE));
        this.latch.await(5L, TimeUnit.SECONDS);
        List catalogList = this.catalogRepository.findByEnvironmentId(environmentId);
        long elementsAfterDeleting = catalogList.size();
        Assertions.assertEquals((long)1L, (long)(elementsBeforeDeleting - elementsAfterDeleting));
    }

    @Test
    public void envKafkaListener_deleteTablesBySystem_catalogRepoHasNoDeletedTable() throws InterruptedException {
        this.createTestDataTableCatalog(UUID.randomUUID(), systemId, environmentId, "Test Table1", "table_name_project1");
        this.createTestDataTableCatalog(UUID.randomUUID(), systemId, environmentId, "Test Table2", "table_name_project2");
        long elementsBeforeDeleting = this.catalogRepository.findBySystemId(systemId).size();
        this.kafkaTemplate.send(this.topic, (Object)this.createMessageToDeleteTable(EnvironmentEventType.DELETE));
        this.latch.await(5L, TimeUnit.SECONDS);
        List catalogList = this.catalogRepository.findBySystemId(systemId);
        long elementsAfterDeleting = catalogList.size();
        Assertions.assertEquals((long)2L, (long)(elementsBeforeDeleting - elementsAfterDeleting));
    }

    @Test
    public void envKafkaListener_deleteTableBySystem_testDataTableRepoHasNoDeletedTable() {
        Assertions.assertThrows(BadSqlGrammarException.class, () -> {
            TestDataTableCatalog catalog1 = this.createTestDataTableCatalog(UUID.randomUUID(), systemId, environmentId, "Test Table1", "table_name_project1");
            this.createTestDataTable(catalog1.getTableName());
            Assertions.assertNotNull((Object)this.testDataService.getTestData(catalog1.getTableName()));
            this.kafkaTemplate.send(this.topic, (Object)this.createMessageToDeleteTable(EnvironmentEventType.DELETE));
            this.latch.await(5L, TimeUnit.SECONDS);
            this.testDataService.getTestData(catalog1.getTableName());
        });
    }

    private String createMessageToDeleteTable(EnvironmentEventType eventType) {
        UUID entityId = environmentId;
        String data = "{\"id\": \"" + entityId + "\",\"eventType\": \"" + eventType + "\"}";
        return data;
    }

    @TestConfiguration
    static class KafkaTestContainersConfiguration {
        @Value(value="${spring.kafka.consumer.bootstrap-servers}")
        String bootstrapServer;

        KafkaTestContainersConfiguration() {
        }

        @Bean
        public KafkaTemplate<String, String> kafkaTemplate(ProducerFactory<String, String> producerFactory) {
            return new KafkaTemplate(producerFactory);
        }

        @Bean
        public ProducerFactory<String, String> producerFactory() {
            HashMap<String, Object> configProps = new HashMap<String, Object>();
            configProps.put("bootstrap.servers", this.bootstrapServer);
            configProps.put("key.serializer", StringSerializer.class);
            configProps.put("value.serializer", StringSerializer.class);
            return new DefaultKafkaProducerFactory(configProps);
        }
    }
}

