/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.model.CommonResults;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkCleanupMailSender;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.websocket.bulkaction.cleanup.BulkDataCleanupHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataCleanupHandlerTest
extends AbstractTestDataTest {
    private final List<LazyEnvironment> lazyEnvironments = Lists.newArrayList((Object[])new LazyEnvironment[]{LazyEnvironment.builder().id(environmentId).name("Test Environment").build()});
    @Autowired
    ExecutorService executorService;
    @Autowired
    CleanupConfigRepository cleanupConfigRepository;
    @Autowired
    BulkCleanupMailSender bulkCleanupMailSender;
    WebSocketSession session;
    BulkDataCleanupHandler bulkDataCleanupHandler;

    @BeforeEach
    public void setUp() throws Exception {
        this.bulkDataCleanupHandler = new BulkDataCleanupHandler(this.executorService, this.catalogRepository, this.environmentsService, this.cleanupService, this.cleanupConfigRepository, this.bulkCleanupMailSender, this.currentTime, this.lockManager, this.tdmMdcHelper);
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void runBulkActionTest_saveDataConfigAndCleanupTable_returnBulkActionIsCorrect() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = this.currentTime.getCurrentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_cleanup_date_config_cleanup_results";
        final String tableTitle = "TDM Cleanup Date Config Cleanup Results";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        this.createDateCleanupConfig(catalog);
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)new CleanupResults(tableName, 6, 0));
        List futures = this.bulkDataCleanupHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult actualBulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertEquals((Object)expectedBulkActionResult, (Object)actualBulkActionResult);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void runBulkActionTest_saveDataConfigAndCleanupTable_testDataTableHasNotCleanup() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = this.currentTime.getCurrentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_cleanup_date_config_not_empty_table";
        final String tableTitle = "TDM Cleanup Date Config Not Empty Table";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        TestDataTableCatalog tableCatalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        this.createDateCleanupConfigToDay(tableCatalog);
        Assertions.assertFalse((boolean)this.testDataService.getTestData(tableName).getData().isEmpty());
        List futures = this.bulkDataCleanupHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult bulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        boolean result = this.testDataService.getTestData(tableName).getData().isEmpty();
        Assertions.assertTrue((boolean)result);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void runBulkActionTest_saveSqlConfigAndCleanupTable_bulkActionResultIsCorrect() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = this.currentTime.getCurrentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_cleanup_sql_config_cleanup_results";
        final String tableTitle = "TDM Cleanup SQL Config Cleanup Results";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        TestDataTableCatalog tableCatalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        this.createSqlCleanupConfig(tableCatalog, true);
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)new CleanupResults(tableName, 6, 6));
        List futures = this.bulkDataCleanupHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult actualBulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertEquals((Object)expectedBulkActionResult, (Object)actualBulkActionResult);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void runBulkActionTest_saveSqlConfigAndCleanupTable_cleanupTestDataTable() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = this.currentTime.getCurrentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_cleanup_sql_config_empty_table";
        final String tableTitle = "TDM Cleanup SQL Config Empty Table";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        TestDataTableCatalog tableCatalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        this.createSqlCleanupConfig(tableCatalog, true);
        Assertions.assertFalse((boolean)this.testDataService.getTestData(tableName).getData().isEmpty());
        List futures = this.bulkDataCleanupHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult bulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        boolean result = this.testDataService.getTestData(tableName).getData().isEmpty();
        Assertions.assertTrue((boolean)result);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void getEnvName_findEnvironmentNameByExistEnvironmentId_returnEnvironmentNameIsCorrect() {
        String actualEnvironmentName = this.bulkDataCleanupHandler.getEnvName(this.lazyEnvironments, environmentId);
        Assertions.assertEquals((Object)"Test Environment", (Object)actualEnvironmentName);
    }

    @Test
    public void getEnvName_findEnvironmentNameByNotExistEnvironmentId_returnRuntimeException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            UUID errorId = UUID.randomUUID();
            this.bulkDataCleanupHandler.getEnvName(this.lazyEnvironments, errorId);
        });
    }
}

