/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.drop;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.CommonResults;
import org.qubership.atp.tdm.model.DropResults;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkDropMailSender;
import org.qubership.atp.tdm.websocket.bulkaction.drop.BulkDataDropHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataDropHandlerTest
extends AbstractTestDataTest {
    @Autowired
    ExecutorService executorService;
    @Autowired
    BulkDropMailSender bulkDropMailSender;
    WebSocketSession session;
    BulkDataDropHandler bulkDataDropHandler;

    @BeforeEach
    public void setUp() throws Exception {
        this.bulkDataDropHandler = new BulkDataDropHandler(this.executorService, this.catalogRepository, this.environmentsService, this.testDataService, this.bulkDropMailSender, this.currentTime, this.lockManager, this.tdmMdcHelper);
    }

    @Test
    public void runBulkAction_dropTable_bulkActionIsCorrect() throws Exception {
        final UUID projectId = UUID.randomUUID();
        final UUID systemId = UUID.randomUUID();
        long processId = System.currentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        final String tableName = "tdm_run_balk_drop_table";
        final String tableTitle = "TDM Run Balk Drop Table";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        DropResults executeResults = new DropResults(){
            {
                this.setTableName(tableName);
            }
        };
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)executeResults);
        List futures = this.bulkDataDropHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult actualBulkActionResultFuture = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertEquals((Object)expectedBulkActionResult, (Object)actualBulkActionResultFuture);
        this.catalogRepository.deleteByTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
    }

    @Test
    public void runBulkAction_dropTable_cleanupTestDataTableCatalog() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = System.currentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        final String tableName = "tdm_run_balk_drop_clean_catalog";
        final String tableTitle = "TDM Run Balk Drop Clean Catalog";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        DropResults executeResults = new DropResults(){
            {
                this.setTableName(tableName);
            }
        };
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)executeResults);
        List futures = this.bulkDataDropHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult bulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertNull((Object)this.catalogRepository.findByTableName(tableName));
        this.catalogRepository.deleteByTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
    }

    @Test
    public void runBulkAction_dropTable_returnException() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = System.currentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_run_balk_exception";
        final String tableTitle = "TDM Run Balk Exception";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        List futures = this.bulkDataDropHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult bulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertEquals((Object)tableName, (Object)bulkActionResult.getTableName());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }
}

