/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.tdm.model.TestDataOccupyStatistic;
import org.qubership.atp.tdm.model.table.TestDataOccupyReportGroupBy;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface OccupyStatisticRepository
extends JpaRepository<TestDataOccupyStatistic, UUID> {
    @Query(value="SELECT DISTINCT ON(table_name) row_id, table_name, occupied_by, occupied_date, project_id, system_id, table_title, created_when FROM test_data_occupy_statistic WHERE project_id = :projectId ORDER BY table_name", nativeQuery=true)
    public List<TestDataOccupyStatistic> findAllByProjectId(@Param(value="projectId") UUID var1);

    @Query(value="SELECT DISTINCT ON(table_name) row_id, table_name, occupied_by, occupied_date, project_id, system_id, table_title, created_when FROM test_data_occupy_statistic WHERE project_id = :projectId AND system_id = :systemId ORDER BY table_name", nativeQuery=true)
    public List<TestDataOccupyStatistic> findAllByProjectIdAndSystemId(@Param(value="projectId") UUID var1, @Param(value="systemId") UUID var2);

    @Transactional
    @Modifying
    @Query(value="DELETE FROM test_data_occupy_statistic WHERE row_id IN (:rowIds)", nativeQuery=true)
    public void deleteAllByRowId(@Param(value="rowIds") List<UUID> var1);

    @Query(value="SELECT NEW org.qubership.atp.tdm.model.table.TestDataOccupyReportGroupBy(c.occupiedBy, c.occupiedDate, c.tableName, COUNT(*)) FROM TestDataOccupyStatistic as c WHERE c.projectId = :projectId AND c.occupiedDate >= :date GROUP BY c.occupiedBy, c.occupiedDate, c.tableName ORDER BY c.tableName")
    public List<TestDataOccupyReportGroupBy> findAllByProjectIdAndOccupiedDateAndCountGroupBy(@Param(value="projectId") UUID var1, @Param(value="date") LocalDateTime var2);
}

