/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.rest.ResponseMessage;
import org.qubership.atp.tdm.model.rest.ResponseType;
import org.qubership.atp.tdm.model.rest.requests.AddInfoToRowRequest;
import org.qubership.atp.tdm.model.rest.requests.GetRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyFullRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyRowRequest;
import org.qubership.atp.tdm.model.rest.requests.ReleaseRowRequest;
import org.qubership.atp.tdm.model.rest.requests.UpdateRowRequest;
import org.qubership.atp.tdm.repo.AtpActionRepository;
import org.qubership.atp.tdm.service.AtpActionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AtpActionServiceImpl
implements AtpActionService {
    private static final Logger log = LoggerFactory.getLogger(AtpActionServiceImpl.class);
    private static final String OCCUPIED_BY_USER = "ATP_User";
    private static final Pattern TEMP_ENV_TIMESTAMP_PATTERN = Pattern.compile(" [0-9]{1,4}-[0-9]{1,2}-[0-9]{1,2}T[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}.*");
    private final EnvironmentsService environmentsService;
    private final AtpActionRepository repository;
    private String tdmUrl = "";
    @Value(value="${atp.tdm.url}")
    private String tdmAddress;
    @Value(value="${feign.atp.catalogue.url}")
    private String catalogueUrl;
    @Value(value="${atp.service.internal}")
    private boolean atpGatewayEnabled;

    @Autowired
    public AtpActionServiceImpl(@Nonnull EnvironmentsService environmentsService, @Nonnull AtpActionRepository repository) {
        this.environmentsService = environmentsService;
        this.repository = repository;
    }

    @Override
    public List<ResponseMessage> getMultipleColumnTestData(@NotNull String projectName, @Nullable String envName, @Nullable String systemName, @NotNull String tableTitle, @NotNull List<GetRowRequest> multipleColumnRowRequest) {
        log.info("ATP Action. Getting multiple column test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        String link = this.formResultLink(environmentContext.getProjectId(), environmentContext.getEnvId(), environmentContext.getSystemId());
        List<ResponseMessage> response = this.repository.getMultipleColumnTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, multipleColumnRowRequest, link);
        log.info("ATP Action. Stop multiple column test data. Table Title: {}.", (Object)tableTitle);
        return response;
    }

    @Override
    public ResponseMessage insertTestData(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<Map<String, Object>> records) {
        log.info("ATP Action. Inserting test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        String link = this.formResultLink(environmentContext.getProjectId(), environmentContext.getEnvId(), environmentContext.getSystemId());
        ResponseMessage response = this.repository.insertTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), environmentContext.getEnvId(), tableTitle, records, link);
        log.info("ATP action. Data for table: {} inserted with status: {}.", (Object)tableTitle, (Object)response.getType());
        return response;
    }

    @Override
    public List<ResponseMessage> occupyTestData(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<OccupyRowRequest> occupyRowRequests) {
        log.info("ATP Action. Occupation of test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        String link = this.formResultLink(environmentContext.getProjectId(), environmentContext.getEnvId(), environmentContext.getSystemId());
        return this.repository.occupyTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, OCCUPIED_BY_USER, occupyRowRequests, link);
    }

    @Override
    public List<ResponseMessage> occupyTestDataFullRow(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<OccupyFullRowRequest> occupyFullRowRequests) {
        log.info("ATP Action. Occupation of test data to return several rows. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        String link = this.formResultLink(environmentContext.getProjectId(), environmentContext.getEnvId(), environmentContext.getSystemId());
        return this.repository.occupyTestDataFullRow(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, OCCUPIED_BY_USER, occupyFullRowRequests, link);
    }

    @Override
    public List<ResponseMessage> releaseTestData(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<ReleaseRowRequest> releaseRowRequests) {
        log.info("ATP Action. Release of test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        return this.repository.releaseTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, releaseRowRequests);
    }

    @Override
    public List<ResponseMessage> releaseFullTestData(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle) {
        log.info("ATP Action. Release of test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        return this.repository.releaseFullTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle);
    }

    @Override
    public List<ResponseMessage> updateTestData(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<UpdateRowRequest> updateRowRequests) {
        log.info("ATP Action. Updating test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        return this.repository.updateTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, updateRowRequests);
    }

    @Override
    public List<ResponseMessage> getTestData(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<GetRowRequest> getRowRequests) {
        log.info("ATP Action. Getting test data. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        return this.repository.getTestData(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, getRowRequests);
    }

    @Override
    public List<ResponseMessage> addInfoToRow(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle, List<AddInfoToRowRequest> addInfoToRowRequests) {
        log.info("ATP Action. Add info to row in test data table. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
        return this.repository.addInfoToRow(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, addInfoToRowRequests);
    }

    @Override
    public List<ResponseMessage> refreshTables(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle) {
        try {
            log.info("ATP Action. Refreshing tables. Table Title: {}", (Object)tableTitle);
            EnvironmentContext environmentContext = this.getEnvironmentContext(projectName, envName, systemName);
            return this.repository.refreshTables(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle, this.tdmUrl);
        }
        catch (Exception e) {
            String message = "ATP Action. Failed to refresh table with title:" + tableTitle + ". Root cause: " + e.getMessage();
            log.error(message, (Throwable)e);
            return Collections.singletonList(new ResponseMessage(ResponseType.ERROR, message));
        }
    }

    @Override
    public List<ResponseMessage> truncateTable(@Nonnull String projectId, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle) {
        log.info("ATP Action. Truncate table. Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(UUID.fromString(projectId), envName, systemName);
        return this.repository.truncateTable(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle);
    }

    @Override
    public List<ResponseMessage> runCleanupForTable(@Nonnull String projectId, @Nullable String envName, @Nullable String systemName, @Nonnull String tableTitle) {
        log.info("ATP Action. Run cleanup, Table Title: {}", (Object)tableTitle);
        EnvironmentContext environmentContext = this.getEnvironmentContext(UUID.fromString(projectId), envName, systemName);
        return this.repository.runCleanupForTable(environmentContext.getProjectId(), environmentContext.getSystemId(), tableTitle);
    }

    private EnvironmentContext getEnvironmentContext(@Nonnull String projectName, @Nullable String envName, @Nullable String systemName) {
        log.info("Loading data from the environments tool. Project: [{}], Env: [{}], System: [{}]", new Object[]{projectName, envName, systemName});
        LazyProject lazyProject = this.environmentsService.getLazyProjectByName(projectName);
        UUID projectId = lazyProject.getId();
        return this.getEnvironmentContextByProjectId(projectId, envName, systemName);
    }

    private EnvironmentContext getEnvironmentContext(@Nonnull UUID projectId, @Nullable String envName, @Nullable String systemName) {
        return this.getEnvironmentContextByProjectId(projectId, envName, systemName);
    }

    private EnvironmentContext getEnvironmentContextByProjectId(@Nonnull UUID projectId, @Nullable String envName, @Nullable String systemName) {
        UUID systemId = null;
        UUID envId = null;
        if (Objects.nonNull(envName) && Objects.nonNull(systemName)) {
            Matcher matcher = TEMP_ENV_TIMESTAMP_PATTERN.matcher(envName);
            if (matcher.find()) {
                log.info("Removing timestamp from envName");
                envName = matcher.replaceAll("");
                log.info("Env: [{}]", (Object)envName);
            }
            LazyEnvironment lazyEnvironment = this.environmentsService.getLazyEnvironmentByName(projectId, envName);
            envId = lazyEnvironment.getId();
            LazySystem lazySystemByName = this.environmentsService.getLazySystemByName(projectId, lazyEnvironment.getId(), systemName);
            systemId = lazySystemByName.getId();
        }
        log.info("Data from the environments tool is loaded.");
        return new EnvironmentContext(projectId, envId, systemId);
    }

    private String formResultLink(@Nonnull UUID projectName, @Nullable UUID envName, @Nullable UUID systemName) {
        if (envName == null) {
            return this.tdmUrl + "/project/" + projectName;
        }
        return this.tdmUrl + "/project/" + projectName + "/tdm/TEST%20DATA/" + envName + "/" + systemName;
    }

    @PostConstruct
    public void init() {
        this.tdmUrl = this.atpGatewayEnabled ? this.catalogueUrl : this.tdmAddress;
    }

    private class EnvironmentContext {
        private UUID projectId;
        private UUID envId;
        private UUID systemId;

        public UUID getProjectId() {
            return this.projectId;
        }

        public UUID getEnvId() {
            return this.envId;
        }

        public UUID getSystemId() {
            return this.systemId;
        }

        public void setProjectId(UUID projectId) {
            this.projectId = projectId;
        }

        public void setEnvId(UUID envId) {
            this.envId = envId;
        }

        public void setSystemId(UUID systemId) {
            this.systemId = systemId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnvironmentContext)) {
                return false;
            }
            EnvironmentContext other = (EnvironmentContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$projectId = this.getProjectId();
            UUID other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
                return false;
            }
            UUID this$envId = this.getEnvId();
            UUID other$envId = other.getEnvId();
            if (this$envId == null ? other$envId != null : !((Object)this$envId).equals(other$envId)) {
                return false;
            }
            UUID this$systemId = this.getSystemId();
            UUID other$systemId = other.getSystemId();
            return !(this$systemId == null ? other$systemId != null : !((Object)this$systemId).equals(other$systemId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnvironmentContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
            UUID $envId = this.getEnvId();
            result = result * 59 + ($envId == null ? 43 : ((Object)$envId).hashCode());
            UUID $systemId = this.getSystemId();
            result = result * 59 + ($systemId == null ? 43 : ((Object)$systemId).hashCode());
            return result;
        }

        public String toString() {
            return "AtpActionServiceImpl.EnvironmentContext(projectId=" + this.getProjectId() + ", envId=" + this.getEnvId() + ", systemId=" + this.getSystemId() + ")";
        }

        public EnvironmentContext(UUID projectId, UUID envId, UUID systemId) {
            this.projectId = projectId;
            this.envId = envId;
            this.systemId = systemId;
        }
    }
}

