/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchCleanupConfigException;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkCleanupMailSender;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.service.CleanupService;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.qubership.atp.tdm.websocket.bulkaction.BulkActionsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataCleanupHandler
extends BulkActionsHandler {
    private static final Logger log = LoggerFactory.getLogger(BulkDataCleanupHandler.class);
    private final CleanupService cleanupService;
    private final CleanupConfigRepository cleanupConfigRepository;

    public BulkDataCleanupHandler(@Qualifier(value="websocket") ExecutorService executorService, @Nonnull CatalogRepository catalogRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull CleanupService cleanupService, @Nonnull CleanupConfigRepository cleanupConfigRepository, @Nonnull BulkCleanupMailSender mailSender, @Nonnull CurrentTime currentTime, @Nonnull LockManager lockManager, TdmMdcHelper helper) {
        super(executorService, catalogRepository, environmentsService, mailSender, currentTime, lockManager, helper);
        this.cleanupConfigRepository = cleanupConfigRepository;
        this.cleanupService = cleanupService;
    }

    @Override
    public List<Future<BulkActionResult>> runBulkAction(@Nonnull WebSocketSession session, @Nonnull ExecutorService executor, @Nonnull List<LazyEnvironment> lazyEnvironments, @Nonnull BulkActionConfig config, long processId) {
        log.info("Bulk cleanup has been initiated, id: {}, config: {}", (Object)processId, (Object)config);
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndSystemIdAndCleanupConfigIdIsNotNull(config.getProjectId(), config.getSystemId()).stream().filter(c -> ((TestDataCleanupConfig)this.cleanupConfigRepository.findById(c.getCleanupConfigId()).orElseThrow(() -> new TdmSearchCleanupConfigException(c.getCleanupConfigId().toString()))).isEnabled()).collect(Collectors.toList());
        Map<UUID, Optional> testDataCleanUpConfigs = catalogList.stream().collect(Collectors.toMap(TestDataTableCatalog::getCleanupConfigId, c -> this.cleanupConfigRepository.findById(c.getCleanupConfigId()), (a, b) -> b));
        log.trace("Found: {} tables with cleanup config.", (Object)catalogList.size());
        ArrayList<Future<BulkActionResult>> futures = new ArrayList<Future<BulkActionResult>>();
        Map mdcMap = MDC.getCopyOfContextMap();
        catalogList.forEach(tableCatalog -> {
            Future<BulkActionResult> future = executor.submit(() -> {
                MdcUtils.setContextMap((Map)mdcMap);
                String envName = this.getEnvName(lazyEnvironments, tableCatalog.getEnvironmentId());
                try {
                    this.mdcHelper.putConfigFields((TestDataTableCatalog)tableCatalog);
                    CleanupResults cleanupResults = this.cleanupService.runCleanup(tableCatalog.getTableName(), (TestDataCleanupConfig)((Optional)testDataCleanUpConfigs.get(tableCatalog.getCleanupConfigId())).orElseThrow(() -> new TdmSearchCleanupConfigException()));
                    BulkActionResult bulkActionResult = new BulkActionResult(tableCatalog.getTableTitle(), tableCatalog.getTableName(), envName, cleanupResults);
                    return bulkActionResult;
                }
                catch (Exception e) {
                    BulkActionResult bulkActionResult = new BulkActionResult(tableCatalog.getTableTitle(), tableCatalog.getTableName(), envName, e);
                    return bulkActionResult;
                }
                finally {
                    this.mdcHelper.removeConfigFields();
                }
            });
            futures.add(future);
        });
        return futures;
    }
}

