/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.helpers;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpRequestParseHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestParseHelper.class);

    public UUID getRequestUuidHeader(HttpServletRequest request, String headerName, boolean required) {
        String headerValue = request.getHeader(headerName);
        if (!StringUtils.isEmpty((Object)headerValue)) {
            return UUID.fromString(headerValue);
        }
        if (required) {
            log.error("Required header '{}' value is empty", (Object)headerName);
            throw new IllegalArgumentException("Required header '" + headerName + "' is empty");
        }
        return null;
    }

    public String getBrowserAgent(String userAgent) {
        String browserAgent = "unknown browser";
        String agent = userAgent.toLowerCase();
        if (agent.contains("edg")) {
            browserAgent = "Edge";
        } else if (agent.contains("firefox")) {
            browserAgent = "Mozilla";
        } else if (agent.contains("opera") || agent.contains("presto") || agent.contains("opr")) {
            browserAgent = "Opera";
        } else if (agent.contains("apple") && agent.contains("safari") && agent.contains("mobile")) {
            browserAgent = "Safari";
        } else if (agent.contains("msie")) {
            browserAgent = "IE";
        } else if (agent.contains("chrome")) {
            browserAgent = "Chrome";
        } else if (agent.contains("gecko")) {
            browserAgent = "browser on core Gecko";
        } else if (agent.contains("konqueror")) {
            browserAgent = "Browser on core Konqueror";
        }
        return browserAgent;
    }
}

