/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.logging.gelf.log4j;

import biz.paluch.logging.gelf.log4j.GelfLogAppender;
import java.net.UnknownHostException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.qubership.atp.integration.configuration.logging.log4j.AtpLog4jPatternLayout;

public class FailSafeGelfLogbackAppenderLog4j
extends GelfLogAppender {
    private static final String PATTERN = "%d{YYYY-MM-dd HH:mm:ss.SS} [%p] \"%t\" [%c#M] %m%n";
    private static final String INFO_MESSAGE = "Switching to fail safe console appender";
    private Logger rootLogger = Logger.getRootLogger();
    private ConsoleAppender consoleAppender;

    public void reportError(String message, Exception exception) {
        if (exception instanceof UnknownHostException) {
            this.initFailSafeConsoleAppender();
        } else {
            super.reportError(message, exception);
        }
    }

    private void initFailSafeConsoleAppender() {
        AtpLog4jPatternLayout layout = new AtpLog4jPatternLayout();
        layout.setConversionPattern(PATTERN);
        this.consoleAppender = new ConsoleAppender((Layout)layout, "System.out");
        this.consoleAppender.setEncoding("utf-8");
        this.consoleAppender.activateOptions();
        this.rootLogger.addAppender((Appender)this.consoleAppender);
        this.rootLogger.info((Object)INFO_MESSAGE);
    }

    protected void append(LoggingEvent event) {
        if (event != null) {
            super.append(AtpLog4jPatternLayout.getMaskedLoggingEvent(event));
        }
    }
}

