/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.kafka.KafkaTracingUtils;
import org.springframework.cloud.sleuth.instrument.kafka.SleuthKafkaSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.kafka.listener.MessageListener;

class TracingMessageListenerMethodInterceptor<T extends MessageListener>
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(TracingMessageListenerMethodInterceptor.class);
    private final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Getter<ConsumerRecord<?, ?>> extractor;

    TracingMessageListenerMethodInterceptor(Tracer tracer, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.extractor = extractor;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!"onMessage".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Object record = this.record(arguments);
        if (record == null) {
            return invocation.proceed();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Wrapping onMessage call");
        }
        Span span = KafkaTracingUtils.buildSpan(SleuthKafkaSpan.KAFKA_ON_MESSAGE_SPAN, (ConsumerRecord)record, this.propagator, this.extractor);
        try {
            Object object;
            block15: {
                Tracer.SpanInScope ws = this.tracer.withSpan(span);
                try {
                    object = invocation.proceed();
                    if (ws == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        String message = e.getMessage();
                        if (message == null) {
                            message = e.getClass().getSimpleName();
                        }
                        span.tag("error", message);
                        throw e;
                    }
                }
                ws.close();
            }
            return object;
        }
        finally {
            span.end();
        }
    }

    private Object record(Object[] arguments) {
        for (Object object : arguments) {
            if (!(object instanceof ConsumerRecord)) continue;
            return object;
        }
        return null;
    }
}

