/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.representation.TokenIntrospectionResponse;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.authorization.client.resource.PolicyResource;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.TokenCallable;

public class ProtectionResource {
    private final TokenCallable pat;
    private final Http http;
    private final Configuration configuration;
    private ServerConfiguration serverConfiguration;

    public ProtectionResource(Http http, ServerConfiguration serverConfiguration, Configuration configuration, TokenCallable pat) {
        if (pat == null) {
            throw new RuntimeException("No access token was provided when creating client for Protection API.");
        }
        this.http = http;
        this.serverConfiguration = serverConfiguration;
        this.configuration = configuration;
        this.pat = pat;
    }

    public ProtectedResource resource() {
        return new ProtectedResource(this.http, this.serverConfiguration, this.configuration, this.pat);
    }

    public PermissionResource permission() {
        return new PermissionResource(this.http, this.serverConfiguration, this.pat);
    }

    public PolicyResource policy(String resourceId) {
        return new PolicyResource(resourceId, this.http, this.serverConfiguration, this.pat);
    }

    public TokenIntrospectionResponse introspectRequestingPartyToken(String rpt) {
        return this.http.post(this.serverConfiguration.getIntrospectionEndpoint()).authentication().client().form().param("token_type_hint", "requesting_party_token").param("token", rpt).response().json(TokenIntrospectionResponse.class).execute();
    }
}

