/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import java.util.Set;
import java.util.UUID;
import javax.servlet.Filter;
import org.apache.http.client.HttpClient;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextFactoryBean;
import org.keycloak.adapters.springsecurity.KeycloakConfiguration;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticatedActionsFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter;
import org.qubership.atp.auth.springbootstarter.config.AtpKeycloakWebSecurityConfigurerAdapter;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.holders.DataContextHolder;
import org.qubership.atp.auth.springbootstarter.provider.impl.UserProvider;
import org.qubership.atp.auth.springbootstarter.security.filters.AnonymousSupportKeycloakAuthenticatedActionsFilter;
import org.qubership.atp.auth.springbootstarter.security.permissions.EntityAccessEnforcement;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.auth.springbootstarter.services.UserGroupService;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

@KeycloakConfiguration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Profile(value={"default"})
public class SecurityConfiguration
extends AtpKeycloakWebSecurityConfigurerAdapter {
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${atp-auth.headers.content-security-policy:default-src 'self' *}")
    private String contentSecurityPolicy;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        KeycloakAuthenticationProvider keycloakAuthenticationProvider = this.keycloakAuthenticationProvider();
        SimpleAuthorityMapper converter = new SimpleAuthorityMapper();
        converter.setConvertToUpperCase(true);
        keycloakAuthenticationProvider.setGrantedAuthoritiesMapper((GrantedAuthoritiesMapper)converter);
        auth.authenticationProvider((AuthenticationProvider)keycloakAuthenticationProvider);
    }

    @Override
    @Bean
    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new NullAuthenticatedSessionStrategy();
    }

    @Override
    @Bean
    protected KeycloakAuthenticatedActionsFilter keycloakAuthenticatedActionsFilter() {
        return new AnonymousSupportKeycloakAuthenticatedActionsFilter();
    }

    @Bean
    @Primary
    public AdapterDeploymentContext sslAdapterDeploymentContext(final HttpClient sslHttpClient) throws Exception {
        AdapterDeploymentContextFactoryBean factoryBean = new AdapterDeploymentContextFactoryBean(this.keycloakConfigResolver);
        factoryBean.afterPropertiesSet();
        final AdapterDeploymentContext deploymentContext = factoryBean.getObject();
        return new AdapterDeploymentContext(){

            public KeycloakDeployment resolveDeployment(HttpFacade facade) {
                KeycloakDeployment keycloakDeployment = deploymentContext.resolveDeployment(facade);
                keycloakDeployment.setClient(sslHttpClient);
                return keycloakDeployment;
            }
        };
    }

    @Bean
    public FilterRegistrationBean keycloakAuthenticationProcessingFilterRegistrationBean(KeycloakAuthenticationProcessingFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean(value={"entityAccess"})
    public PolicyEnforcement entityAccess(UsersService usersService, UserGroupService userGroupService, DataContextHolder<Set<String>> userRolesContextHolder) {
        return new EntityAccessEnforcement(usersService, userGroupService, userRolesContextHolder, this.serviceName);
    }

    @Bean(value={"userInfoProvider"})
    public Provider<UserInfo> userInfoProvider() {
        return new UserProvider();
    }

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/assets/**"})).antMatchers(HttpMethod.OPTIONS, new String[]{"/**"});
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.headers().xssProtection().xssProtectionEnabled(false).and().contentSecurityPolicy(this.contentSecurityPolicy).and().frameOptions().sameOrigin().and()).csrf().disable()).authorizeRequests().antMatchers(new String[]{"/ws/api"})).permitAll().antMatchers(new String[]{"/api/public/**"})).permitAll().antMatchers(new String[]{"/rest/deployment/**"})).permitAll().antMatchers(new String[]{"/*/api/**", "/api/**"})).authenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    @Bean(value={"userGroupService"})
    public UserGroupService userGroupService(DataContextHolder<UUID> userIdContextHolder, UsersService usersService, DataContextHolder<Set<String>> userRolesContextHolder) {
        return new UserGroupService(userIdContextHolder, usersService, userRolesContextHolder);
    }
}

