/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.discovery.util.ExceptionsMetric;
import com.netflix.discovery.util.ServoUtil;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollectingEurekaHttpClient
extends EurekaHttpClientDecorator {
    private static final Logger logger = LoggerFactory.getLogger(MetricsCollectingEurekaHttpClient.class);
    private final EurekaHttpClient delegate;
    private final Map<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> metricsByRequestType;
    private final ExceptionsMetric exceptionsMetric;
    private final boolean shutdownMetrics;

    public MetricsCollectingEurekaHttpClient(EurekaHttpClient delegate) {
        this(delegate, MetricsCollectingEurekaHttpClient.initializeMetrics(), new ExceptionsMetric("eurekaClient.transport.exceptions"), true);
    }

    private MetricsCollectingEurekaHttpClient(EurekaHttpClient delegate, Map<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> metricsByRequestType, ExceptionsMetric exceptionsMetric, boolean shutdownMetrics) {
        this.delegate = delegate;
        this.metricsByRequestType = metricsByRequestType;
        this.exceptionsMetric = exceptionsMetric;
        this.shutdownMetrics = shutdownMetrics;
    }

    @Override
    protected <R> EurekaHttpResponse<R> execute(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor) {
        EurekaHttpClientRequestMetrics requestMetrics = this.metricsByRequestType.get((Object)requestExecutor.getRequestType());
        Stopwatch stopwatch = requestMetrics.latencyTimer.start();
        try {
            EurekaHttpResponse<R> httpResponse = requestExecutor.execute(this.delegate);
            ((Counter)requestMetrics.countersByStatus.get((Object)MetricsCollectingEurekaHttpClient.mappedStatus(httpResponse))).increment();
            EurekaHttpResponse<R> eurekaHttpResponse = httpResponse;
            return eurekaHttpResponse;
        }
        catch (Exception e) {
            requestMetrics.connectionErrors.increment();
            this.exceptionsMetric.count(e);
            throw e;
        }
        finally {
            stopwatch.stop();
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdownMetrics) {
            MetricsCollectingEurekaHttpClient.shutdownMetrics(this.metricsByRequestType);
            this.exceptionsMetric.shutdown();
        }
    }

    public static EurekaHttpClientFactory createFactory(final EurekaHttpClientFactory delegateFactory) {
        final Map<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> metricsByRequestType = MetricsCollectingEurekaHttpClient.initializeMetrics();
        final ExceptionsMetric exceptionMetrics = new ExceptionsMetric("eurekaClient.transport.exceptions");
        return new EurekaHttpClientFactory(){

            @Override
            public EurekaHttpClient newClient() {
                return new MetricsCollectingEurekaHttpClient(delegateFactory.newClient(), metricsByRequestType, exceptionMetrics, false);
            }

            @Override
            public void shutdown() {
                MetricsCollectingEurekaHttpClient.shutdownMetrics(metricsByRequestType);
                exceptionMetrics.shutdown();
            }
        };
    }

    public static TransportClientFactory createFactory(final TransportClientFactory delegateFactory) {
        final Map<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> metricsByRequestType = MetricsCollectingEurekaHttpClient.initializeMetrics();
        final ExceptionsMetric exceptionMetrics = new ExceptionsMetric("eurekaClient.transport.exceptions");
        return new TransportClientFactory(){

            @Override
            public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
                return new MetricsCollectingEurekaHttpClient(delegateFactory.newClient(endpoint), metricsByRequestType, exceptionMetrics, false);
            }

            @Override
            public void shutdown() {
                MetricsCollectingEurekaHttpClient.shutdownMetrics(metricsByRequestType);
                exceptionMetrics.shutdown();
            }
        };
    }

    private static Map<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> initializeMetrics() {
        EnumMap<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> result = new EnumMap<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics>(EurekaHttpClientDecorator.RequestType.class);
        try {
            for (EurekaHttpClientDecorator.RequestType requestType : EurekaHttpClientDecorator.RequestType.values()) {
                result.put(requestType, new EurekaHttpClientRequestMetrics(requestType.name()));
            }
        }
        catch (Exception e) {
            logger.warn("Metrics initialization failure", (Throwable)e);
        }
        return result;
    }

    private static void shutdownMetrics(Map<EurekaHttpClientDecorator.RequestType, EurekaHttpClientRequestMetrics> metricsByRequestType) {
        for (EurekaHttpClientRequestMetrics metrics : metricsByRequestType.values()) {
            metrics.shutdown();
        }
    }

    private static EurekaHttpClientRequestMetrics.Status mappedStatus(EurekaHttpResponse<?> httpResponse) {
        int category = httpResponse.getStatusCode() / 100;
        switch (category) {
            case 1: {
                return EurekaHttpClientRequestMetrics.Status.x100;
            }
            case 2: {
                return EurekaHttpClientRequestMetrics.Status.x200;
            }
            case 3: {
                return EurekaHttpClientRequestMetrics.Status.x300;
            }
            case 4: {
                return EurekaHttpClientRequestMetrics.Status.x400;
            }
            case 5: {
                return EurekaHttpClientRequestMetrics.Status.x500;
            }
        }
        return EurekaHttpClientRequestMetrics.Status.Unknown;
    }

    static class EurekaHttpClientRequestMetrics {
        private final Timer latencyTimer;
        private final Counter connectionErrors;
        private final Map<Status, Counter> countersByStatus;

        EurekaHttpClientRequestMetrics(String resourceName) {
            this.countersByStatus = EurekaHttpClientRequestMetrics.createStatusCounters(resourceName);
            this.latencyTimer = new BasicTimer(MonitorConfig.builder((String)"eurekaClient.transport.latency").withTag("id", resourceName).withTag("class", MetricsCollectingEurekaHttpClient.class.getSimpleName()).build(), TimeUnit.MILLISECONDS);
            ServoUtil.register(this.latencyTimer);
            this.connectionErrors = new BasicCounter(MonitorConfig.builder((String)"eurekaClient.transport.connectionErrors").withTag("id", resourceName).withTag("class", MetricsCollectingEurekaHttpClient.class.getSimpleName()).build());
            ServoUtil.register(this.connectionErrors);
        }

        void shutdown() {
            ServoUtil.unregister(new Monitor[]{this.latencyTimer, this.connectionErrors});
            ServoUtil.unregister(this.countersByStatus.values());
        }

        private static Map<Status, Counter> createStatusCounters(String resourceName) {
            EnumMap<Status, Counter> result = new EnumMap<Status, Counter>(Status.class);
            for (Status status : Status.values()) {
                BasicCounter counter = new BasicCounter(MonitorConfig.builder((String)"eurekaClient.transport.request").withTag("id", resourceName).withTag("class", MetricsCollectingEurekaHttpClient.class.getSimpleName()).withTag("status", status.name()).build());
                ServoUtil.register(counter);
                result.put(status, (Counter)counter);
            }
            return result;
        }

        static enum Status {
            x100,
            x200,
            x300,
            x400,
            x500,
            Unknown;

        }
    }
}

