/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.table.conditions.search;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public enum SearchConditionType {
    CONTAINS("Contains"),
    START_WITH("Start With", "startWith"),
    EQUALS("Equals"),
    FROM("From"),
    TO("To");

    private final List<String> values;

    private SearchConditionType(String ... values) {
        this.values = Arrays.asList(values);
    }

    public List<String> getValues() {
        return this.values;
    }

    public static SearchConditionType find(@Nonnull String value) {
        for (SearchConditionType type : SearchConditionType.values()) {
            if (!type.getValues().stream().anyMatch(value::equalsIgnoreCase)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown search condition type: " + value);
    }
}

