/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.exceptions.internal.TdmStatisticsException;
import org.qubership.atp.tdm.model.TestDataOccupyStatistic;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.statistics.ConsumedStatistics;
import org.qubership.atp.tdm.model.statistics.ConsumedStatisticsItem;
import org.qubership.atp.tdm.model.statistics.DateStatistics;
import org.qubership.atp.tdm.model.statistics.DateStatisticsItem;
import org.qubership.atp.tdm.model.statistics.GeneralStatisticsItem;
import org.qubership.atp.tdm.model.statistics.OutdatedStatistics;
import org.qubership.atp.tdm.model.statistics.OutdatedStatisticsInner;
import org.qubership.atp.tdm.model.statistics.OutdatedStatisticsItem;
import org.qubership.atp.tdm.model.statistics.StatisticsItem;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReport;
import org.qubership.atp.tdm.repo.ProjectInformationRepository;
import org.qubership.atp.tdm.repo.StatisticsRepository;
import org.qubership.atp.tdm.repo.impl.extractors.ConsumedStatisticsExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.GeneralStatisticsExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.OutdatedStatisticsExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.TestDataExtractorProvider;
import org.qubership.atp.tdm.utils.DataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class StatisticsRepositoryImpl
implements StatisticsRepository {
    private static final Logger log = LoggerFactory.getLogger(StatisticsRepositoryImpl.class);
    private static final String NA = "N/A";
    private final JdbcTemplate jdbcTemplate;
    private final TestDataExtractorProvider extractorProvider;
    private final ProjectInformationRepository projectInformationRepository;

    @Autowired
    public StatisticsRepositoryImpl(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull TestDataExtractorProvider extractorProvider, @Nonnull ProjectInformationRepository projectInformationRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.extractorProvider = extractorProvider;
        this.projectInformationRepository = projectInformationRepository;
    }

    @Override
    public List<GeneralStatisticsItem> getTestDataAvailability(@Nonnull List<TestDataTableCatalog> catalogList, @Nonnull UUID projectId) {
        ArrayList<GeneralStatisticsItem> listStatisticsItems = new ArrayList<GeneralStatisticsItem>();
        String timeZone = this.getTimeZone(projectId);
        Map<String, String> timeStampsMap = DataUtils.generateTimeStampDailyRange(timeZone);
        catalogList.forEach(item -> {
            GeneralStatisticsItem statisticsItem = this.getGeneralStatisticsItem((TestDataTableCatalog)item, timeStampsMap);
            if (Objects.nonNull(statisticsItem)) {
                UUID system = item.getSystemId();
                if (system != null) {
                    statisticsItem.setSystem(system.toString());
                }
                listStatisticsItems.add(statisticsItem);
            }
        });
        listStatisticsItems.sort(Comparator.comparing(StatisticsItem::getContext));
        return listStatisticsItems;
    }

    @Override
    public ConsumedStatistics getTestDataConsumption(@Nonnull List<TestDataOccupyStatistic> occupyStatisticList, @Nonnull UUID projectId, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        ConsumedStatistics consumedStatistics = new ConsumedStatistics();
        consumedStatistics.setDates(DataUtils.getStatisticsInterval(dateFrom, dateTo));
        ArrayList<ConsumedStatisticsItem> listStatisticsItems = new ArrayList<ConsumedStatisticsItem>();
        occupyStatisticList.forEach(occupyStatisticItem -> {
            ConsumedStatisticsItem statisticsItem = new ConsumedStatisticsItem(occupyStatisticItem.getTableTitle());
            ConsumedStatisticsExtractor extractor = this.extractorProvider.consumedStatisticsExtractor();
            List dbOutput = (List)this.jdbcTemplate.query("SELECT date, SUM(count) as count FROM ( SELECT date, count FROM ( SELECT TO_CHAR(occupied_date, 'YYYY-MM-dd') as date, COUNT(*) as count FROM test_data_occupy_statistic WHERE LOWER(table_name) = ? AND (occupied_date BETWEEN ?::date AND ?::date) GROUP BY date ORDER BY date) as existing ) as statistics GROUP BY date ORDER BY date", (ResultSetExtractor)extractor, new Object[]{occupyStatisticItem.getTableName().toLowerCase(), dateFrom.toString(), dateTo.toString()});
            List<Long> consumed = this.calculateStatistic(dbOutput, dateFrom, dateTo, statisticsItem, (TestDataOccupyStatistic)occupyStatisticItem);
            statisticsItem.setConsumed(consumed);
            listStatisticsItems.add(statisticsItem);
        });
        listStatisticsItems.sort(Comparator.comparing(StatisticsItem::getContext));
        consumedStatistics.setItems(listStatisticsItems);
        return consumedStatistics;
    }

    private List<Long> calculateStatistic(List<Map<LocalDate, Long>> dbOutput, LocalDate dateFrom, LocalDate dateTo, StatisticsItem statisticsItem, TestDataOccupyStatistic occupyStatisticItem) {
        ArrayList<Long> consumed = new ArrayList<Long>();
        switch (DataUtils.statisticsInterval) {
            case YEARS: {
                do {
                    long count = 0L;
                    for (Map<LocalDate, Long> outIt : dbOutput) {
                        for (Map.Entry<LocalDate, Long> entry : outIt.entrySet()) {
                            if (dateFrom.getYear() != entry.getKey().getYear()) continue;
                            count += entry.getValue().longValue();
                        }
                    }
                    consumed.add(count);
                } while (!(dateFrom = dateFrom.plusYears(1L)).isAfter(dateTo));
                break;
            }
            case WEEKS: {
                do {
                    long count = 0L;
                    for (Map<LocalDate, Long> outIt : dbOutput) {
                        for (Map.Entry<LocalDate, Long> entry : outIt.entrySet()) {
                            if (dateFrom.getYear() != entry.getKey().getYear() || dateFrom.getMonth() != entry.getKey().getMonth() || !entry.getKey().isEqual(dateFrom) && !entry.getKey().isAfter(dateFrom) || !entry.getKey().isBefore(dateFrom.plusWeeks(1L))) continue;
                            count += entry.getValue().longValue();
                        }
                    }
                    consumed.add(count);
                } while (!(dateFrom = dateFrom.plusWeeks(1L)).isAfter(dateTo));
                break;
            }
            case DAYS: {
                do {
                    long count = 0L;
                    for (Map<LocalDate, Long> outIt : dbOutput) {
                        for (Map.Entry<LocalDate, Long> entry : outIt.entrySet()) {
                            if (dateFrom.getYear() != entry.getKey().getYear() || dateFrom.getMonth() != entry.getKey().getMonth() || dateFrom.getDayOfMonth() != entry.getKey().getDayOfMonth()) continue;
                            count += entry.getValue().longValue();
                        }
                    }
                    consumed.add(count);
                } while (!(dateFrom = dateFrom.plusDays(1L)).isAfter(dateTo));
                break;
            }
            default: {
                do {
                    long count = 0L;
                    for (Map<LocalDate, Long> outIt : dbOutput) {
                        for (Map.Entry<LocalDate, Long> entry : outIt.entrySet()) {
                            if (dateFrom.getYear() != entry.getKey().getYear() || dateFrom.getMonth() != entry.getKey().getMonth()) continue;
                            count += entry.getValue().longValue();
                        }
                    }
                    consumed.add(count);
                } while (!(dateFrom = dateFrom.plusMonths(1L)).isAfter(dateTo));
            }
        }
        UUID system = occupyStatisticItem.getSystemId();
        if (system != null) {
            statisticsItem.setSystem(system.toString());
        }
        return consumed;
    }

    @Override
    public OutdatedStatistics getTestDataOutdatedConsumption(@Nonnull List<TestDataTableCatalog> catalogList, @Nonnull UUID projectId, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo, int expirationDate) {
        OutdatedStatistics outdatedStatistics = new OutdatedStatistics();
        outdatedStatistics.setDates(DataUtils.getStatisticsInterval(dateFrom, dateTo));
        ArrayList<OutdatedStatisticsItem> listStatisticsItems = new ArrayList<OutdatedStatisticsItem>();
        catalogList.forEach(occupyStatisticItem -> {
            List dbOutput;
            LocalDate iterDate = dateFrom;
            OutdatedStatisticsItem statisticsItem = new OutdatedStatisticsItem(occupyStatisticItem.getTableTitle());
            ArrayList<Long> created = new ArrayList<Long>();
            ArrayList<Long> consumed = new ArrayList<Long>();
            ArrayList<Long> outdated = new ArrayList<Long>();
            try {
                OutdatedStatisticsExtractor extractor = this.extractorProvider.outdatedStatisticsExtractor();
                String query = String.format("SELECT date, SUM(created) AS created, SUM(consumed) AS consumed, SUM(outdated) AS outdated FROM ((SELECT TO_CHAR(\"CREATED_WHEN\", 'YYYY-MM-dd') AS date, COUNT(*) as created, 0 consumed, 0 outdated FROM %s WHERE \"SELECTED\" = false AND (\"CREATED_WHEN\" BETWEEN ?::date AND ?::date) GROUP BY date ORDER BY date) UNION ALL ( SELECT TO_CHAR(occupied_date, 'YYYY-MM-dd') as date, 0 created, COUNT(*) as consumed, 0 outdated FROM test_data_occupy_statistic WHERE LOWER(table_name) = ? AND occupied_date is not null GROUP BY date ORDER BY date) UNION ALL ( SELECT TO_CHAR(occupied_date, 'YYYY-MM-dd') as date,0 created, 0 consumed, COUNT(*) AS outdated FROM test_data_occupy_statistic WHERE LOWER(table_name) = ? AND OCCUPIED_DATE >= ?::date GROUP BY date ORDER BY date )) AS test GROUP BY date ", occupyStatisticItem.getTableName().toLowerCase());
                dbOutput = (List)this.jdbcTemplate.query(query, (ResultSetExtractor)extractor, new Object[]{dateFrom.toString(), dateTo.toString(), occupyStatisticItem.getTableName().toLowerCase(), occupyStatisticItem.getTableName().toLowerCase(), dateFrom.plusDays(expirationDate).toString()});
            }
            catch (Exception e) {
                log.error(String.format("An error occurred while getting outdated statistic for table: %s", occupyStatisticItem.getTableName()), (Throwable)e);
                throw new TdmStatisticsException(occupyStatisticItem.getTableName());
            }
            if (Objects.nonNull(dbOutput)) {
                switch (DataUtils.statisticsInterval) {
                    case YEARS: {
                        do {
                            long countCreated = 0L;
                            long countConsumed = 0L;
                            long countOutdated = 0L;
                            for (OutdatedStatisticsInner outdatedStatisticsItem : dbOutput) {
                                if (iterDate.getYear() != outdatedStatisticsItem.getDate().getYear()) continue;
                                countCreated += outdatedStatisticsItem.getCreated().longValue();
                                countConsumed += outdatedStatisticsItem.getConsumed().longValue();
                                countOutdated += outdatedStatisticsItem.getOutdated().longValue();
                            }
                            created.add(countCreated);
                            consumed.add(countConsumed);
                            outdated.add(countOutdated);
                        } while (!(iterDate = iterDate.plusYears(1L)).isAfter(dateTo));
                        break;
                    }
                    case WEEKS: {
                        do {
                            long countCreated = 0L;
                            long countConsumed = 0L;
                            long countOutdated = 0L;
                            for (OutdatedStatisticsInner outdatedStatisticsItem : dbOutput) {
                                if (iterDate.getYear() != outdatedStatisticsItem.getDate().getYear() || iterDate.getMonth() != outdatedStatisticsItem.getDate().getMonth() || !outdatedStatisticsItem.getDate().isEqual(iterDate) && !outdatedStatisticsItem.getDate().isAfter(iterDate) || !outdatedStatisticsItem.getDate().isBefore(iterDate.plusWeeks(1L))) continue;
                                countCreated += outdatedStatisticsItem.getCreated().longValue();
                                countConsumed += outdatedStatisticsItem.getConsumed().longValue();
                                countOutdated += outdatedStatisticsItem.getOutdated().longValue();
                            }
                            created.add(countCreated);
                            consumed.add(countConsumed);
                            outdated.add(countOutdated);
                        } while (!(iterDate = iterDate.plusWeeks(1L)).isAfter(dateTo));
                        break;
                    }
                    case DAYS: {
                        do {
                            long countCreated = 0L;
                            long countConsumed = 0L;
                            long countOutdated = 0L;
                            for (OutdatedStatisticsInner outdatedStatisticsItem : dbOutput) {
                                if (iterDate.getYear() != outdatedStatisticsItem.getDate().getYear() || iterDate.getMonth() != outdatedStatisticsItem.getDate().getMonth() || iterDate.getDayOfMonth() != outdatedStatisticsItem.getDate().getDayOfMonth()) continue;
                                countCreated += outdatedStatisticsItem.getCreated().longValue();
                                countConsumed += outdatedStatisticsItem.getConsumed().longValue();
                                countOutdated += outdatedStatisticsItem.getOutdated().longValue();
                            }
                            created.add(countCreated);
                            consumed.add(countConsumed);
                            outdated.add(countOutdated);
                        } while (!(iterDate = iterDate.plusDays(1L)).isAfter(dateTo));
                        break;
                    }
                    default: {
                        do {
                            long countCreated = 0L;
                            long countConsumed = 0L;
                            long countOutdated = 0L;
                            for (OutdatedStatisticsInner outdatedStatisticsItem : dbOutput) {
                                if (iterDate.getYear() != outdatedStatisticsItem.getDate().getYear() || iterDate.getMonth() != outdatedStatisticsItem.getDate().getMonth()) continue;
                                countCreated += outdatedStatisticsItem.getCreated().longValue();
                                countConsumed += outdatedStatisticsItem.getConsumed().longValue();
                                countOutdated += outdatedStatisticsItem.getOutdated().longValue();
                            }
                            created.add(countCreated);
                            consumed.add(countConsumed);
                            outdated.add(countOutdated);
                        } while (!(iterDate = iterDate.plusMonths(1L)).isAfter(dateTo));
                    }
                }
                UUID system = occupyStatisticItem.getSystemId();
                if (system != null) {
                    statisticsItem.setSystem(system.toString());
                }
                statisticsItem.setCreated(created);
                statisticsItem.setConsumed(consumed);
                statisticsItem.setOutdated(outdated);
                listStatisticsItems.add(statisticsItem);
            } else {
                log.warn("Outdated data in table:[{}] not found.", (Object)occupyStatisticItem.getTableName());
            }
        });
        listStatisticsItems.sort(Comparator.comparing(StatisticsItem::getContext));
        outdatedStatistics.setItems(listStatisticsItems);
        return outdatedStatistics;
    }

    @Override
    public DateStatistics getTestDataCreatedWhen(@Nonnull List<TestDataOccupyStatistic> occupyStatisticList, @Nonnull UUID projectId, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        DateStatistics dateStatistics = new DateStatistics();
        dateStatistics.setDates(DataUtils.getStatisticsInterval(dateFrom, dateTo));
        ArrayList<DateStatisticsItem> listStatisticsItems = new ArrayList<DateStatisticsItem>();
        occupyStatisticList.forEach(occupyStatisticItem -> {
            DateStatisticsItem statisticsItem = new DateStatisticsItem(occupyStatisticItem.getTableTitle());
            ConsumedStatisticsExtractor extractor = this.extractorProvider.consumedStatisticsExtractor();
            List dbOutput = (List)this.jdbcTemplate.query("SELECT TO_CHAR(CREATED_WHEN, 'YYYY-MM-dd') as date, COUNT(*) as count FROM test_data_occupy_statistic WHERE LOWER(table_name) = ? AND CREATED_WHEN BETWEEN ?::date AND ?::date GROUP BY CREATED_WHEN ORDER BY CREATED_WHEN", (ResultSetExtractor)extractor, new Object[]{occupyStatisticItem.getTableName().toLowerCase(), dateFrom.toString(), dateTo.toString()});
            List<Long> consumed = this.calculateStatistic(dbOutput, dateFrom, dateTo, statisticsItem, (TestDataOccupyStatistic)occupyStatisticItem);
            statisticsItem.setCreated(consumed);
            listStatisticsItems.add(statisticsItem);
        });
        listStatisticsItems.sort(Comparator.comparing(StatisticsItem::getContext));
        dateStatistics.setItems(listStatisticsItems);
        return dateStatistics;
    }

    @Override
    public List<StatisticsReport> getTestDataMonitoringStatistics(@Nonnull List<TestDataTableCatalog> catalogList, @Nonnull UUID projectId) {
        ArrayList<StatisticsReport> statisticsReport = new ArrayList<StatisticsReport>();
        String timeZone = this.getTimeZone(projectId);
        Map<String, String> timeStampsMap = DataUtils.generateTimeStampDailyRange(timeZone);
        catalogList.forEach(item -> {
            GeneralStatisticsItem statisticsItem = this.getGeneralStatisticsItem((TestDataTableCatalog)item, timeStampsMap);
            String system = Objects.isNull(item.getSystemId()) ? NA : String.valueOf(item.getSystemId());
            statisticsReport.add(new StatisticsReport(NA, system, statisticsItem));
        });
        return statisticsReport;
    }

    @Override
    public List<String> alterOccupiedDateColumn(List<String> tableNames) {
        log.info("Adding missing column \"OCCUPIED_DATE\"");
        ArrayList<String> result = new ArrayList<String>();
        for (String tableName : tableNames) {
            log.info("Processing table: " + tableName);
            this.jdbcTemplate.update(String.format("ALTER TABLE %s ADD COLUMN IF NOT EXISTS \"OCCUPIED_DATE\" TIMESTAMP", tableName));
            int updated = this.jdbcTemplate.update(String.format("UPDATE %s SET \"OCCUPIED_DATE\" = CURRENT_TIMESTAMP WHERE \"SELECTED\" = true AND \"OCCUPIED_DATE\" IS NULL", tableName));
            if (updated <= 0) continue;
            String message = "OCCUPIED_DATE Column was updated in the table: " + tableName + " . Affected rows: " + updated;
            log.info(message);
            result.add(message);
        }
        log.info("Adding column insert finished.");
        return result;
    }

    private String getTimeZone(UUID projectId) {
        return this.projectInformationRepository.getProjectInformationTableByProjectId(projectId).getTimeZone();
    }

    private GeneralStatisticsItem getGeneralStatisticsItem(TestDataTableCatalog item, Map<String, String> map) {
        GeneralStatisticsExtractor extractor = this.extractorProvider.generalStatisticsExtractor(item.getTableTitle());
        GeneralStatisticsItem statisticsItem = (GeneralStatisticsItem)this.jdbcTemplate.query(String.format("SELECT * FROM (SELECT COUNT(*) as available FROM %s WHERE \"SELECTED\" = false) available, (SELECT COUNT(*) as occupied FROM %s WHERE \"SELECTED\" = true) occupied,(SELECT COUNT(*) FROM %s\nWHERE \"SELECTED\" = true\nAND \"OCCUPIED_DATE\" >= '%s'::TIMESTAMP WITH TIME ZONE\nAND \"OCCUPIED_DATE\" <= '%s'::TIMESTAMP WITH TIME ZONE) occupiedToday,(SELECT COUNT(*) as total FROM %s ) total", item.getTableName().toLowerCase(), item.getTableName().toLowerCase(), item.getTableName().toLowerCase(), map.get("startTimeStamp"), map.get("endTimeStamp"), item.getTableName().toLowerCase()), (ResultSetExtractor)extractor);
        return statisticsItem;
    }
}

