/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.internal.TdmAvailableStatisticActiveColumnException;
import org.qubership.atp.tdm.exceptions.internal.TdmAvailableStatisticColumnException;
import org.qubership.atp.tdm.exceptions.internal.TdmAvailableStatisticEnvironmentIdException;
import org.qubership.atp.tdm.exceptions.internal.TdmAvailableStatisticSystemIdException;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchAvailableMonitoringConfigException;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchAvailableStatisticConfigException;
import org.qubership.atp.tdm.model.TestDataOccupyStatistic;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.scheduler.AvailableDataStatisticsMailJob;
import org.qubership.atp.tdm.model.scheduler.StatisticsMailJob;
import org.qubership.atp.tdm.model.scheduler.UsersStatisticsMailJob;
import org.qubership.atp.tdm.model.statistics.AvailableDataStatisticsConfig;
import org.qubership.atp.tdm.model.statistics.ConsumedStatistics;
import org.qubership.atp.tdm.model.statistics.ConsumedStatisticsItem;
import org.qubership.atp.tdm.model.statistics.DateStatistics;
import org.qubership.atp.tdm.model.statistics.DateStatisticsItem;
import org.qubership.atp.tdm.model.statistics.GeneralStatisticsItem;
import org.qubership.atp.tdm.model.statistics.OccupiedDataByUsersStatistics;
import org.qubership.atp.tdm.model.statistics.OutdatedStatistics;
import org.qubership.atp.tdm.model.statistics.OutdatedStatisticsItem;
import org.qubership.atp.tdm.model.statistics.StatisticsEnvironment;
import org.qubership.atp.tdm.model.statistics.StatisticsItem;
import org.qubership.atp.tdm.model.statistics.TestAvailableDataMonitoring;
import org.qubership.atp.tdm.model.statistics.TestDataTableMonitoring;
import org.qubership.atp.tdm.model.statistics.TestDataTableUsersMonitoring;
import org.qubership.atp.tdm.model.statistics.UserGeneralStatisticsItem;
import org.qubership.atp.tdm.model.statistics.UsersOccupyStatisticRequest;
import org.qubership.atp.tdm.model.statistics.UsersOccupyStatisticResponse;
import org.qubership.atp.tdm.model.statistics.available.AvailableDataByColumnStats;
import org.qubership.atp.tdm.model.statistics.available.TableAvailableDataStats;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReport;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportElement;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportEnvironment;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportObject;
import org.qubership.atp.tdm.model.statistics.report.UsersStatisticsReportElement;
import org.qubership.atp.tdm.model.statistics.report.UsersStatisticsReportObject;
import org.qubership.atp.tdm.model.table.TestDataOccupyReportGroupBy;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.model.table.conditions.search.SearchConditionType;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.OccupyStatisticRepository;
import org.qubership.atp.tdm.repo.StatisticsRepository;
import org.qubership.atp.tdm.repo.TableColumnValuesRepository;
import org.qubership.atp.tdm.repo.TestAvailableDataMonitoringRepository;
import org.qubership.atp.tdm.repo.TestDataMonitoringRepository;
import org.qubership.atp.tdm.repo.TestDataUsersMonitoringRepository;
import org.qubership.atp.tdm.repo.impl.SystemColumns;
import org.qubership.atp.tdm.service.SchedulerService;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.utils.AvailableStatisticUtils;
import org.qubership.atp.tdm.utils.DateFormatters;
import org.qubership.atp.tdm.utils.UsersOccupyStatisticUtils;
import org.qubership.atp.tdm.utils.ValidateCronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    private static final List<String> INTERNAL_COLUMNS = new ArrayList<String>(Arrays.asList("OCCUPIED_DATE", "ROW_ID", "SELECTED", "OCCUPIED_BY"));
    @PersistenceContext
    private EntityManager entityManager;
    private static final String SCHEDULE_GROUP = "statistics";
    private static final String SCHEDULE_USERS_GROUP = "user-statistics";
    private static final String SCHEDULE_AVAILABLE_DATA_GROUP = "available-data-statistics";
    private static final String ALL_ENVIRONMENTS = "across all";
    private static final String NA = "N/A";
    private static final String CSV_EXT = ".csv";
    private final StatisticsRepository statisticsRepository;
    private final TestDataMonitoringRepository monitoringRepository;
    private final TestDataUsersMonitoringRepository usersMonitoringRepository;
    private final TestAvailableDataMonitoringRepository availableDataMonitoringRepository;
    private final TableColumnValuesRepository tableColumnValuesRepository;
    private final OccupyStatisticRepository occupyStatisticRepository;
    private final SchedulerService schedulerService;
    private final EnvironmentsService environmentsService;
    private final TestDataService testDataService;
    private final CatalogRepository catalogRepository;
    private final Integer threshold;

    @Autowired
    public StatisticsServiceImpl(@Nonnull StatisticsRepository statisticsRepository, @Nonnull TestDataMonitoringRepository monitoringRepository, @Nonnull TestDataUsersMonitoringRepository userMonitoringRepository, @Nonnull SchedulerService schedulerService, @Nonnull EnvironmentsService environmentsService, @Lazy TestDataService testDataService, @Nonnull CatalogRepository catalogRepository, @Nonnull OccupyStatisticRepository occupyStatisticRepository, @Nonnull TestAvailableDataMonitoringRepository availableDataMonitoringRepository, @Nonnull TableColumnValuesRepository tableColumnValuesRepository, @Value(value="${test.data.initial.threshold}") Integer threshold) {
        this.statisticsRepository = statisticsRepository;
        this.monitoringRepository = monitoringRepository;
        this.usersMonitoringRepository = userMonitoringRepository;
        this.schedulerService = schedulerService;
        this.environmentsService = environmentsService;
        this.catalogRepository = catalogRepository;
        this.testDataService = testDataService;
        this.occupyStatisticRepository = occupyStatisticRepository;
        this.availableDataMonitoringRepository = availableDataMonitoringRepository;
        this.tableColumnValuesRepository = tableColumnValuesRepository;
        this.threshold = threshold;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public List<GeneralStatisticsItem> getTestDataAvailability(@Nonnull UUID projectId, @Nullable UUID systemId) {
        log.info("Get test data availability for project: {}, systemId: {}", (Object)projectId, (Object)systemId);
        List<TestDataTableCatalog> catalogList = Objects.nonNull(systemId) ? this.catalogRepository.findAllByProjectIdAndSystemId(projectId, systemId) : this.catalogRepository.findAllByProjectId(projectId);
        List<GeneralStatisticsItem> data = this.statisticsRepository.getTestDataAvailability(catalogList, projectId);
        this.setEnvironmentsNames(projectId, data);
        if (Objects.nonNull(systemId)) {
            log.info("Test data availability successfully received.");
            return data;
        }
        ArrayList<GeneralStatisticsItem> listItems = new ArrayList<GeneralStatisticsItem>();
        List<String> contextList = data.stream().map(StatisticsItem::getContext).distinct().collect(Collectors.toList());
        contextList.forEach(contextValue -> {
            ArrayList<GeneralStatisticsItem> details = new ArrayList<GeneralStatisticsItem>();
            GeneralStatisticsItem item = new GeneralStatisticsItem((String)contextValue, 0L, 0L, 0L, 0L);
            data.forEach(dataItem -> {
                if (contextValue.equals(dataItem.getContext())) {
                    long available = item.getAvailable() + dataItem.getAvailable();
                    long occupied = item.getOccupied() + dataItem.getOccupied();
                    long total = item.getTotal() + dataItem.getTotal();
                    item.setAvailable(available);
                    item.setOccupied(occupied);
                    item.setTotal(total);
                    details.add((GeneralStatisticsItem)dataItem);
                }
            });
            item.setSystem(ALL_ENVIRONMENTS);
            item.setEnvironment(ALL_ENVIRONMENTS);
            item.setDetails(details);
            listItems.add(item);
        });
        log.info("Test data availability successfully received.");
        return listItems;
    }

    @Override
    public ConsumedStatistics getTestDataConsumption(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        log.info("Get consumed test data for project: {}, system: {}, from: {}, to: {}", new Object[]{projectId, systemId, dateFrom, dateTo});
        ArrayList<ConsumedStatisticsItem> listItems = new ArrayList<ConsumedStatisticsItem>();
        List<TestDataOccupyStatistic> occupyStatisticList = Objects.nonNull(systemId) ? this.occupyStatisticRepository.findAllByProjectIdAndSystemId(projectId, systemId) : this.occupyStatisticRepository.findAllByProjectId(projectId);
        ConsumedStatistics data = this.statisticsRepository.getTestDataConsumption(occupyStatisticList, projectId, dateFrom, dateTo);
        this.setEnvironmentsNames(projectId, data.getItems());
        if (Objects.isNull(systemId)) {
            List<String> contextList = data.getItems().stream().map(StatisticsItem::getContext).distinct().collect(Collectors.toList());
            contextList.forEach(contextValue -> {
                int datesNumber = data.getDates().size();
                ArrayList<ConsumedStatisticsItem> details = new ArrayList<ConsumedStatisticsItem>();
                ConsumedStatisticsItem item = new ConsumedStatisticsItem((String)contextValue, (List<Long>)new ArrayList<Long>(Collections.nCopies(datesNumber, 0L)));
                data.getItems().forEach(dataItem -> {
                    if (contextValue.equals(dataItem.getContext())) {
                        details.add((ConsumedStatisticsItem)dataItem);
                        for (int i = 0; i < datesNumber; ++i) {
                            long consumed = item.getConsumed().get(i) + dataItem.getConsumed().get(i);
                            item.getConsumed().set(i, consumed);
                        }
                    }
                });
                item.setSystem(ALL_ENVIRONMENTS);
                item.setEnvironment(ALL_ENVIRONMENTS);
                item.setDetails(details);
                listItems.add(item);
            });
            data.setItems(listItems);
        }
        log.info("Test data consumption successfully received.");
        return data;
    }

    private void setEnvironmentsNames(@Nonnull UUID projectId, @Nonnull List<? extends StatisticsEnvironment> elements) {
        List lazyEnvironments = this.environmentsService.getLazyEnvironments(projectId);
        this.setEnvironmentsNames(lazyEnvironments, elements);
    }

    private void setEnvironmentsNames(@Nonnull List<LazyEnvironment> environments, @Nonnull List<? extends StatisticsEnvironment> elements) {
        log.info("Setting environments names.");
        elements.forEach(statElement -> {
            if (!NA.equals(statElement.getSystem())) {
                for (LazyEnvironment environment : environments) {
                    Optional<String> system = environment.getSystems().stream().filter(s -> s.equals(statElement.getSystem())).findFirst();
                    if (!system.isPresent()) continue;
                    statElement.setEnvironment(environment.getName());
                    statElement.setSystem(this.environmentsService.getLazySystemById(UUID.fromString(system.get())).getName());
                    break;
                }
            }
        });
        log.info("Environments names successfully set.");
    }

    @Override
    public OutdatedStatistics getTestDataConsumptionWhitOutdated(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo, int expirationDate) {
        log.info("Get consumed test data for project: {}, system: {}, from: {}, to: {}", new Object[]{projectId, systemId, dateFrom, dateTo});
        ArrayList<OutdatedStatisticsItem> listItems = new ArrayList<OutdatedStatisticsItem>();
        List<TestDataTableCatalog> catalogList = Objects.nonNull(systemId) ? this.catalogRepository.findAllByProjectIdAndSystemId(projectId, systemId) : this.catalogRepository.findAllByProjectId(projectId);
        OutdatedStatistics data = this.statisticsRepository.getTestDataOutdatedConsumption(catalogList, projectId, dateFrom, dateTo, expirationDate);
        this.setEnvironmentsNames(projectId, data.getItems());
        if (Objects.isNull(systemId)) {
            List<String> contextList = data.getItems().stream().map(StatisticsItem::getContext).distinct().collect(Collectors.toList());
            contextList.forEach(contextValue -> {
                int datesNumber = data.getDates().size();
                ArrayList<OutdatedStatisticsItem> details = new ArrayList<OutdatedStatisticsItem>();
                OutdatedStatisticsItem item = new OutdatedStatisticsItem((String)contextValue, (List<Long>)new ArrayList<Long>(Collections.nCopies(datesNumber, 0L)), (List<Long>)new ArrayList<Long>(Collections.nCopies(datesNumber, 0L)), (List<Long>)new ArrayList<Long>(Collections.nCopies(datesNumber, 0L)));
                data.getItems().forEach(dataItem -> {
                    if (contextValue.equals(dataItem.getContext())) {
                        details.add((OutdatedStatisticsItem)dataItem);
                        for (int i = 0; i < datesNumber; ++i) {
                            long created = item.getCreated().get(i) + dataItem.getCreated().get(i);
                            long consumed = item.getConsumed().get(i) + dataItem.getConsumed().get(i);
                            long outdated = item.getOutdated().get(i) + dataItem.getOutdated().get(i);
                            item.getCreated().set(i, created);
                            item.getConsumed().set(i, consumed);
                            item.getOutdated().set(i, outdated);
                        }
                    }
                });
                item.setSystem(ALL_ENVIRONMENTS);
                item.setEnvironment(ALL_ENVIRONMENTS);
                item.setDetails(details);
                listItems.add(item);
            });
            data.setItems(listItems);
        }
        log.info("Test data consumption successfully received.");
        return data;
    }

    @Override
    public DateStatistics getTestDataCreatedWhen(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        log.info("Get created when test data for project: {}, system: {}, from: {}, to: {}", new Object[]{projectId, systemId, dateFrom, dateTo});
        ArrayList<DateStatisticsItem> listItems = new ArrayList<DateStatisticsItem>();
        List<TestDataTableCatalog> catalogExistingList = Objects.nonNull(systemId) ? this.catalogRepository.findAllByProjectIdAndSystemId(projectId, systemId) : this.catalogRepository.findAllByProjectId(projectId);
        List<TestDataOccupyStatistic> catalogDeletedList = Objects.nonNull(systemId) ? this.occupyStatisticRepository.findAllByProjectIdAndSystemId(projectId, systemId) : this.occupyStatisticRepository.findAllByProjectId(projectId);
        DateStatistics dataExisting = this.testDataService.getTableByCreatedWhen(catalogExistingList, dateFrom, dateTo);
        DateStatistics dataDeleted = this.statisticsRepository.getTestDataCreatedWhen(catalogDeletedList, projectId, dateFrom, dateTo);
        this.setEnvironmentsNames(projectId, dataExisting.getItems());
        this.setEnvironmentsNames(projectId, dataDeleted.getItems());
        DateStatistics dateStatistics = DateStatistics.concatDateStatistics(dataExisting, dataDeleted);
        if (Objects.isNull(systemId)) {
            List<String> contextList = dateStatistics.getItems().stream().map(StatisticsItem::getContext).distinct().collect(Collectors.toList());
            contextList.forEach(contextValue -> {
                int datesNumber = dateStatistics.getDates().size();
                ArrayList<DateStatisticsItem> details = new ArrayList<DateStatisticsItem>();
                DateStatisticsItem item = new DateStatisticsItem((String)contextValue, (List<Long>)new ArrayList<Long>(Collections.nCopies(datesNumber, 0L)));
                dateStatistics.getItems().forEach(dataItem -> {
                    if (contextValue.equals(dataItem.getContext())) {
                        details.add((DateStatisticsItem)dataItem);
                        for (int i = 0; i < datesNumber; ++i) {
                            long created = item.getCreated().get(i) + dataItem.getCreated().get(i);
                            item.getCreated().set(i, created);
                        }
                    }
                });
                item.setSystem(ALL_ENVIRONMENTS);
                item.setEnvironment(ALL_ENVIRONMENTS);
                item.setDetails(details);
                listItems.add(item);
            });
            dateStatistics.setItems(listItems);
        }
        return dateStatistics;
    }

    @Override
    public TestDataTableMonitoring getMonitoringSchedule(@Nonnull UUID projectId) {
        return this.monitoringRepository.findById(projectId).orElse(new TestDataTableMonitoring());
    }

    @Override
    public void saveMonitoringSchedule(@Nonnull TestDataTableMonitoring monitoringItem) {
        log.info("Saving statistics schedule: {}", (Object)monitoringItem);
        ValidateCronExpression.validate(monitoringItem.getCronExpression());
        this.monitoringRepository.save(monitoringItem);
        this.reschedule(monitoringItem);
        log.info("The statistics schedule successfully saved.");
    }

    @Override
    public void deleteMonitoringSchedule(@Nonnull TestDataTableMonitoring monitoringItem) {
        log.info("Deleting statistics schedule: {}", (Object)monitoringItem);
        this.monitoringRepository.delete(monitoringItem);
        this.schedulerService.deleteJob(new JobKey(String.valueOf(monitoringItem.getProjectId()), SCHEDULE_GROUP));
        log.info("The statistics schedule successfully deleted.");
    }

    @Override
    public TestDataTableUsersMonitoring getUsersMonitoringSchedule(@Nonnull UUID projectId) {
        return this.usersMonitoringRepository.findById(projectId).orElse(new TestDataTableUsersMonitoring());
    }

    @Override
    public void saveUsersMonitoringSchedule(@Nonnull TestDataTableUsersMonitoring monitoringItem) {
        log.info("Saving statistics users schedule: {}", (Object)monitoringItem);
        ValidateCronExpression.validate(monitoringItem.getCronExpression());
        this.usersMonitoringRepository.save(monitoringItem);
        this.rescheduleUsers(monitoringItem);
        log.info("The statistics users schedule successfully saved.");
    }

    @Override
    public void deleteUsersMonitoringSchedule(@Nonnull TestDataTableUsersMonitoring monitoringItem) {
        log.info("Deleting statistics users schedule: {}", (Object)monitoringItem);
        this.usersMonitoringRepository.delete(monitoringItem);
        this.schedulerService.deleteJob(new JobKey(String.valueOf(monitoringItem.getProjectId()), SCHEDULE_USERS_GROUP));
        log.info("The statistics users schedule successfully deleted.");
    }

    @Override
    public String getNextScheduledRun(@Nonnull String cronExpression) throws ParseException {
        log.info("Calculate next scheduled run, cron expression: {}", (Object)cronExpression);
        CronExpression cron = new CronExpression(cronExpression);
        String nextScheduledRun = cron.getNextValidTimeAfter(new Date()).toString();
        log.info("Next scheduled run calculated: {}", (Object)nextScheduledRun);
        return nextScheduledRun;
    }

    @Override
    public StatisticsReportObject getTestDataMonitoringStatistics(@Nonnull UUID projectId, int threshold) {
        log.info("Get consumed test data monitoring statistic for project: {}, threshold: {}", (Object)projectId, (Object)threshold);
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectId(projectId);
        List<StatisticsReport> statistics = this.statisticsRepository.getTestDataMonitoringStatistics(catalogList, projectId);
        String projectName = this.environmentsService.getLazyProjectById(projectId).getName();
        List environments = this.environmentsService.getLazyEnvironments(projectId);
        this.setEnvironmentsNames(environments, statistics);
        StatisticsReportObject report = this.getTestDataMonitoringStatistics(projectName, threshold, statistics);
        log.info("Consumed test data monitoring statistic successfully received.");
        return report;
    }

    private StatisticsReportObject getTestDataMonitoringStatistics(@Nonnull String projectName, int threshold, @Nonnull List<StatisticsReport> reportStatistics) {
        StatisticsReportObject reportObject = new StatisticsReportObject();
        reportObject.setProjectName(projectName);
        ArrayList<StatisticsReportElement> upToThreshold = new ArrayList<StatisticsReportElement>();
        ArrayList<StatisticsReportElement> downToThreshold = new ArrayList<StatisticsReportElement>();
        List<String> environments = reportStatistics.stream().map(StatisticsEnvironment::getEnvironment).distinct().collect(Collectors.toList());
        environments.forEach(env -> {
            List<String> filterSystem = reportStatistics.stream().filter(el -> env.equals(el.getEnvironment())).map(StatisticsEnvironment::getSystem).distinct().collect(Collectors.toList());
            filterSystem.forEach(system -> {
                List<StatisticsReport> data = reportStatistics.stream().filter(el -> env.equals(el.getEnvironment()) && system.equals(el.getSystem())).collect(Collectors.toList());
                ArrayList<GeneralStatisticsItem> up = new ArrayList<GeneralStatisticsItem>();
                ArrayList<GeneralStatisticsItem> down = new ArrayList<GeneralStatisticsItem>();
                data.forEach(it -> {
                    if (it.getStatistics().getAvailable() >= (long)threshold) {
                        up.add(it.getStatistics());
                    } else {
                        down.add(it.getStatistics());
                    }
                });
                StatisticsReportEnvironment environment = new StatisticsReportEnvironment((String)env, (String)system);
                if (!up.isEmpty()) {
                    up.sort(Comparator.comparing(StatisticsItem::getContext));
                    upToThreshold.add(new StatisticsReportElement(environment, up));
                }
                if (!down.isEmpty()) {
                    down.sort(Comparator.comparing(StatisticsItem::getContext));
                    downToThreshold.add(new StatisticsReportElement(environment, down));
                }
            });
        });
        if (!upToThreshold.isEmpty()) {
            reportObject.setUpToThreshold(upToThreshold);
        }
        if (!downToThreshold.isEmpty()) {
            reportObject.setDownToThreshold(downToThreshold);
        }
        return reportObject;
    }

    @Override
    public void removeUnused() {
        this.monitoringRepository.findAll().stream().map(TestDataTableMonitoring::getProjectId).forEach(id -> {
            if (this.catalogRepository.findAllByProjectId((UUID)id).isEmpty()) {
                this.monitoringRepository.deleteById(id);
            }
        });
    }

    @Override
    public List<String> alterOccupiedDateColumn() {
        return this.statisticsRepository.alterOccupiedDateColumn(this.catalogRepository.findAll().stream().map(TestDataTableCatalog::getTableName).collect(Collectors.toList()));
    }

    @Override
    public void saveOccupyStatistic(@Nonnull TestDataOccupyStatistic testDataOccupyStatistic) {
        this.occupyStatisticRepository.save(testDataOccupyStatistic);
    }

    @Override
    public void deleteAllOccupyStatisticByRowId(@Nonnull List<UUID> rows) {
        this.occupyStatisticRepository.deleteAllByRowId(rows);
    }

    @Override
    public void fillCreatedWhenStatistics(@Nonnull String tableName, @Nonnull TestDataTableCatalog catalog) {
        TestDataTable testDataTable = this.getCreatedWhenTestDataInfo(tableName);
        this.fillCreatedWhenStatistics(tableName, catalog, testDataTable);
    }

    @Override
    public void fillCreatedWhenStatistics(@Nonnull String tableName, @Nonnull TestDataTableCatalog catalog, @Nonnull List<UUID> rows) {
        TestDataTable testDataTable = this.getCreatedWhenTestDataInfo(tableName, rows);
        this.fillCreatedWhenStatistics(tableName, catalog, testDataTable);
    }

    private void fillCreatedWhenStatistics(@Nonnull String tableName, @Nonnull TestDataTableCatalog catalog, @Nonnull TestDataTable testDataTable) {
        log.info("Save created when statistics for table:[{}]", (Object)tableName);
        List statistics = testDataTable.getData().stream().map(row -> {
            LocalDateTime createdWhen = LocalDateTime.parse(String.valueOf(row.get(SystemColumns.CREATED_WHEN.getName())), DateFormatters.FULL_DATE_FORMATTER);
            UUID rowId = UUID.fromString(String.valueOf(row.get(SystemColumns.ROW_ID.getName())));
            return new TestDataOccupyStatistic(rowId, catalog.getProjectId(), catalog.getSystemId(), tableName, catalog.getTableTitle(), null, null, createdWhen);
        }).collect(Collectors.toList());
        this.occupyStatisticRepository.saveAll(statistics);
        log.info("Created when statistics for table:[{}] successfully saved.", (Object)tableName);
    }

    private TestDataTable getCreatedWhenTestDataInfo(@Nonnull String tableName) {
        return this.testDataService.getTestData(tableName, Arrays.asList(SystemColumns.ROW_ID.getName(), SystemColumns.CREATED_WHEN.getName()), null);
    }

    private TestDataTable getCreatedWhenTestDataInfo(@Nonnull String tableName, @Nonnull List<UUID> rows) {
        List<String> rowsStr = rows.stream().map(UUID::toString).collect(Collectors.toList());
        List<TestDataTableFilter> filters = Collections.singletonList(new TestDataTableFilter(SystemColumns.ROW_ID.getName(), SearchConditionType.EQUALS.toString(), rowsStr, false));
        return this.testDataService.getTestData(tableName, Arrays.asList(SystemColumns.ROW_ID.getName(), SystemColumns.CREATED_WHEN.getName()), filters);
    }

    @Override
    public UsersStatisticsReportObject getUsersStatisticsReport(@Nonnull TestDataTableUsersMonitoring testDataTableUsersMonitoring) {
        UUID projectId = testDataTableUsersMonitoring.getProjectId();
        int daysCount = testDataTableUsersMonitoring.getDaysCount();
        String shortNameProject = this.environmentsService.getLazyProjectById(projectId).getName();
        List<TestDataOccupyReportGroupBy> testDataOccupy = this.occupyStatisticRepository.findAllByProjectIdAndOccupiedDateAndCountGroupBy(projectId, LocalDateTime.now().minusDays(daysCount));
        if (!testDataOccupy.isEmpty()) {
            ArrayList<UsersStatisticsReportElement> userElements = new ArrayList<UsersStatisticsReportElement>();
            Map catalogMap = this.catalogRepository.findAllByProjectId(projectId).stream().collect(Collectors.toMap(TestDataTableCatalog::getTableName, Function.identity()));
            List<String> userNames = testDataOccupy.stream().map(TestDataOccupyReportGroupBy::getOccupiedBy).distinct().collect(Collectors.toList());
            userNames.forEach(userName -> {
                UsersStatisticsReportElement usersStatisticsReportElement = new UsersStatisticsReportElement();
                ArrayList<UserGeneralStatisticsItem> listItems = new ArrayList<UserGeneralStatisticsItem>();
                usersStatisticsReportElement.setUser((String)userName);
                usersStatisticsReportElement.setDates(this.getDateFormatFromDaysCount(daysCount));
                List testDataOccupyForUserName = testDataOccupy.stream().filter(t -> t.getOccupiedBy().equals(userName)).collect(Collectors.toList());
                List<String> tableNames = testDataOccupyForUserName.stream().map(TestDataOccupyReportGroupBy::getTableName).distinct().collect(Collectors.toList());
                tableNames.forEach(tableName -> {
                    String systemName;
                    String envName;
                    List testDataOccupyForTableName = testDataOccupyForUserName.stream().filter(t -> t.getTableName().equals(tableName)).collect(Collectors.toList());
                    TestDataTableCatalog tableCatalog = (TestDataTableCatalog)catalogMap.get(tableName);
                    try {
                        envName = this.environmentsService.getEnvNameById(tableCatalog.getEnvironmentId());
                    }
                    catch (Exception e) {
                        log.error("Environment name for id: {} - don't found in EnvService", (Object)tableCatalog.getEnvironmentId());
                        envName = tableCatalog.getEnvironmentId().toString();
                    }
                    try {
                        systemName = this.environmentsService.getLazySystemById(tableCatalog.getSystemId()).getName();
                    }
                    catch (Exception e) {
                        log.error("System name for id: {} - don't found in EnvService", (Object)tableCatalog.getSystemId());
                        systemName = tableCatalog.getSystemId().toString();
                    }
                    ArrayList<Long> counts = new ArrayList<Long>();
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    List<LocalDateTime> dates = this.getDateFromDaysCount(daysCount);
                    dates.forEach(date -> {
                        Long count = testDataOccupyForTableName.stream().filter(t -> t.getOccupiedDate().format(dateTimeFormatter).equals(date.format(dateTimeFormatter))).findFirst().orElse(new TestDataOccupyReportGroupBy(null, null, null, 0L)).getCount();
                        counts.add(count);
                    });
                    UserGeneralStatisticsItem userStatisticsItem = new UserGeneralStatisticsItem(envName, systemName, tableCatalog.getTableTitle(), counts);
                    listItems.add(userStatisticsItem);
                });
                usersStatisticsReportElement.setItems(listItems);
                userElements.add(usersStatisticsReportElement);
            });
            return new UsersStatisticsReportObject(shortNameProject, userElements);
        }
        return new UsersStatisticsReportObject(shortNameProject, null);
    }

    private List<LocalDateTime> getDateFromDaysCount(int daysCount) {
        ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
        list.add(LocalDateTime.now());
        for (int i = 1; i <= daysCount; ++i) {
            LocalDateTime buf = LocalDateTime.now().minusDays(i);
            list.add(buf);
        }
        return list.stream().sorted().collect(Collectors.toList());
    }

    private List<String> getDateFormatFromDaysCount(int daysCount) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd MMM");
        return this.getDateFromDaysCount(daysCount).stream().map(s -> s.format(dateTimeFormatter)).collect(Collectors.toList());
    }

    private void rescheduleUsers(@Nonnull TestDataTableUsersMonitoring monitoringItem) {
        log.info("Processing users monitoring statistics schedule request");
        JobDetail job = JobBuilder.newJob(UsersStatisticsMailJob.class).withIdentity(String.valueOf(monitoringItem.getProjectId()), SCHEDULE_USERS_GROUP).build();
        this.schedulerService.reschedule(job, monitoringItem, SCHEDULE_USERS_GROUP);
        String triggerStatus = monitoringItem.isEnabled() ? "ON" : "OFF";
        log.info("Job for project {} and group {} has been scheduled. Trigger status:{}", new Object[]{monitoringItem.getProjectId(), SCHEDULE_USERS_GROUP, triggerStatus});
    }

    private void rescheduleAvailableData(@Nonnull TestAvailableDataMonitoring monitoringItem) {
        log.info("Processing available data monitoring statistics schedule request");
        String identityName = monitoringItem.getSystemId().toString() + ";" + monitoringItem.getEnvironmentId().toString();
        JobDetail job = JobBuilder.newJob(AvailableDataStatisticsMailJob.class).withIdentity(identityName, SCHEDULE_AVAILABLE_DATA_GROUP).build();
        this.schedulerService.reschedule(job, monitoringItem, SCHEDULE_AVAILABLE_DATA_GROUP, identityName);
        String triggerStatus = monitoringItem.isScheduled() ? "ON" : "OFF";
        log.info("Job with identity name {} and group {} has been scheduled. Trigger status:{}", new Object[]{identityName, SCHEDULE_AVAILABLE_DATA_GROUP, triggerStatus});
    }

    private void reschedule(@Nonnull TestDataTableMonitoring monitoringItem) {
        log.info("Processing monitoring statistics schedule request");
        JobDetail job = JobBuilder.newJob(StatisticsMailJob.class).withIdentity(String.valueOf(monitoringItem.getProjectId()), SCHEDULE_GROUP).build();
        this.schedulerService.reschedule(job, monitoringItem, SCHEDULE_GROUP);
        String triggerStatus = monitoringItem.isEnabled() ? "ON" : "OFF";
        log.info("Job for project {} and group {} has been scheduled. Trigger status:{}", new Object[]{monitoringItem.getProjectId(), SCHEDULE_GROUP, triggerStatus});
    }

    public void startStatisticsMonitoring() {
        log.info("Starting jobs for stored statistic configurations.");
        List monitoringList = this.monitoringRepository.findAll();
        monitoringList.forEach(this::reschedule);
        log.info("Stored statistic jobs successfully started.");
    }

    public void startUsersStatisticsMonitoring() {
        log.info("Starting jobs for users statistic configurations.");
        List usersMonitoringList = this.usersMonitoringRepository.findAll();
        usersMonitoringList.forEach(this::rescheduleUsers);
        log.info("Stored users statistic jobs successfully started.");
    }

    public void startAvailableDataStatsMonitoring() {
        log.info("Starting jobs for users statistic configurations.");
        List monitoringList = this.availableDataMonitoringRepository.findAll();
        monitoringList.forEach(this::rescheduleAvailableData);
        log.info("Stored users statistic jobs successfully started.");
    }

    @Override
    public UsersOccupyStatisticResponse getOccupiedDataByUsers(@Nonnull UsersOccupyStatisticRequest request) {
        log.info("Getting occupied data by users. Request: [{}]", (Object)request);
        long daysBetween = ChronoUnit.DAYS.between(LocalDate.parse(request.getDateFrom()), LocalDate.parse(request.getDateTo()));
        Preconditions.checkArgument((daysBetween > 0L ? 1 : 0) != 0, (Object)"Date from is greater than date to.");
        String generatedQuery = UsersOccupyStatisticUtils.generateRequest(request, this.environmentsService);
        Query query = this.entityManager.createNativeQuery(generatedQuery);
        UsersOccupyStatisticUtils.setPagination(query, request);
        List queryResult = query.getResultList();
        Map<String, TestDataTableCatalog> tables = this.catalogRepository.findAllByProjectId(request.getProjectId()).stream().collect(Collectors.toMap(TestDataTableCatalog::getTableName, Function.identity()));
        List<OccupiedDataByUsersStatistics> tableValues = UsersOccupyStatisticUtils.mapObjectsToEntity(queryResult, LocalDate.parse(request.getDateFrom()));
        this.fillEnvironmentsAndSystems(tableValues, tables);
        int countOfRows = ((BigInteger)this.entityManager.createNativeQuery(String.format("SELECT COUNT(*) FROM (%s) AS foo", generatedQuery)).getResultList().get(0)).intValue();
        return new UsersOccupyStatisticResponse(tableValues, countOfRows);
    }

    private void fillEnvironmentsAndSystems(List<OccupiedDataByUsersStatistics> occupiedTables, Map<String, TestDataTableCatalog> tables) {
        occupiedTables.forEach(tableValue -> {
            TestDataTableCatalog tableTemp = (TestDataTableCatalog)tables.get(tableValue.getTableName());
            if (tableTemp != null) {
                String systemName = "Not found";
                String environmentName = "Not found";
                try {
                    tableValue.setSystem(this.environmentsService.getLazySystemById(tableTemp.getSystemId()).getName());
                }
                catch (Exception e) {
                    tableValue.setSystem(systemName);
                }
                try {
                    tableValue.setEnvironment(this.environmentsService.getEnvNameById(tableTemp.getEnvironmentId()));
                }
                catch (Exception e) {
                    tableValue.setEnvironment(environmentName);
                }
            }
        });
    }

    @Override
    public File getCsvReportByUsers(UUID projectId, int days) throws IOException {
        LocalDate dateTo = LocalDate.now();
        LocalDate dateFrom = dateTo.minusDays(days);
        UsersOccupyStatisticResponse response = this.getOccupiedDataByUsers(new UsersOccupyStatisticRequest(projectId, 0L, 100L, null, null, dateFrom.toString(), dateTo.toString()));
        String projectName = this.environmentsService.getLazyProjectById(projectId).getName();
        String period = LocalDate.now().minusDays(days) + "-" + LocalDate.now();
        File csvFile = new File(Files.createTempFile("[Statistic by User][" + projectName + "][" + period + "]", CSV_EXT, new FileAttribute[0]).toString());
        try (FileWriter fileWriter = new FileWriter(csvFile);){
            List<String> datesBetween = UsersOccupyStatisticUtils.getDatesBetween(dateFrom, dateTo);
            datesBetween = datesBetween.stream().map(LocalDate::parse).map(date -> date.format(DateTimeFormatter.ISO_LOCAL_DATE)).collect(Collectors.toList());
            StringBuilder csvHeader = new StringBuilder("User Name,Table,System,Environment,");
            String datesString = String.join((CharSequence)",", datesBetween);
            csvHeader.append(datesString).append(",\n");
            fileWriter.write(csvHeader.toString());
            for (OccupiedDataByUsersStatistics table : response.getData()) {
                TreeSet<LocalDate> keys = new TreeSet<LocalDate>(table.getData().keySet());
                StringBuilder valuesString = new StringBuilder();
                keys.forEach(date -> valuesString.append(table.getData().get(date)).append(","));
                StringBuilder build = new StringBuilder();
                build.append(table.getUserName()).append(",").append(table.getContext()).append(",").append((String)StringUtils.defaultIfEmpty((CharSequence)table.getSystem(), (CharSequence)"Not found")).append(",").append((String)StringUtils.defaultIfEmpty((CharSequence)table.getEnvironment(), (CharSequence)"Not found")).append(",");
                build.append((CharSequence)valuesString);
                build.append("\n");
                fileWriter.write(build.toString());
            }
        }
        catch (IOException e) {
            log.error("Error write csv file for report by users", (Throwable)e);
            throw e;
        }
        return csvFile;
    }

    @Override
    public AvailableDataStatisticsConfig getAvailableStatsConfig(@Nonnull UUID systemId, @Nonnull UUID environmentId) {
        log.info("Getting available statistic configuration for environmentId {} and systemId {}", (Object)environmentId, (Object)systemId);
        AvailableDataStatisticsConfig statsConfig = new AvailableDataStatisticsConfig(systemId, environmentId);
        statsConfig.setColumnKeys(this.getAllColumnNamesBySystemId(systemId));
        TestAvailableDataMonitoring optionalMonitoringConfig = this.availableDataMonitoringRepository.findByEnvironmentIdAndSystemId(environmentId, systemId);
        if (optionalMonitoringConfig != null) {
            List<String> tableNames = this.catalogRepository.findBySystemId(systemId).stream().map(table -> table.getTableName().toLowerCase()).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((CharSequence)optionalMonitoringConfig.getDescription())) {
                statsConfig.setDescription(optionalMonitoringConfig.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)optionalMonitoringConfig.getActiveColumn())) {
                statsConfig.setActiveColumnKey(optionalMonitoringConfig.getActiveColumn());
            }
            if (!CollectionUtils.isEmpty(tableNames)) {
                statsConfig.setTablesColumns(this.tableColumnValuesRepository.findTableColumnValuesByTableNameIn(tableNames));
            }
        }
        log.debug("Received config {}", (Object)statsConfig);
        return statsConfig;
    }

    @Override
    public void saveAvailableStatsConfig(@Nonnull AvailableDataStatisticsConfig config) {
        log.info("Saving available stats config {}", (Object)config);
        if (config.getEnvironmentId() == null) {
            log.error("Cannot save available available stats config: environmentId is null!");
            throw new TdmAvailableStatisticEnvironmentIdException();
        }
        if (config.getSystemId() == null) {
            log.error("Cannot save available available stats config: systemId is null!");
            throw new TdmAvailableStatisticSystemIdException();
        }
        TestAvailableDataMonitoring monitoringConfig = this.availableDataMonitoringRepository.findByEnvironmentIdAndSystemId(config.getEnvironmentId(), config.getSystemId());
        if (monitoringConfig == null) {
            monitoringConfig = new TestAvailableDataMonitoring(config.getSystemId(), config.getEnvironmentId());
        }
        if (!config.getColumnKeys().contains(config.getActiveColumnKey())) {
            log.error(String.format("The selected column [%s] is not included in the list of valid columns.", config.getActiveColumnKey()));
            throw new TdmAvailableStatisticColumnException(config.getActiveColumnKey());
        }
        if (!StringUtils.isNotEmpty((CharSequence)config.getActiveColumnKey())) {
            log.error("Active column key cannot be null.");
            throw new TdmAvailableStatisticActiveColumnException();
        }
        monitoringConfig.setActiveColumn(config.getActiveColumnKey());
        if (StringUtils.isNotEmpty((CharSequence)config.getDescription())) {
            monitoringConfig.setDescription(config.getDescription());
        } else {
            monitoringConfig.setDescription("Description is empty");
        }
        if (CollectionUtils.isEmpty(config.getTablesColumns())) {
            throw new NullPointerException("Tables columns cannot be empty.");
        }
        log.trace("Deleting available data monitoring for environmentId {} and systemId {}", (Object)config.getEnvironmentId(), (Object)config.getSystemId());
        this.availableDataMonitoringRepository.deleteTestAvailableDataMonitoringsByEnvironmentIdAndSystemId(config.getEnvironmentId(), config.getSystemId());
        this.schedulerService.deleteJob(new JobKey(String.valueOf(config.getSystemId()), SCHEDULE_AVAILABLE_DATA_GROUP));
        log.trace("Saving monitoring config {}", (Object)monitoringConfig);
        this.availableDataMonitoringRepository.save(monitoringConfig);
        List<String> tableNames = this.catalogRepository.findAllByEnvironmentIdAndSystemId(config.getEnvironmentId(), config.getSystemId()).stream().map(table -> table.getTableName().toLowerCase()).collect(Collectors.toList());
        log.trace("Deleting all table by names in tableColumnValuesRepository. Table names: {}", tableNames);
        this.tableColumnValuesRepository.deleteAllByTableNameIn(tableNames);
        log.trace("Saving table column values by config {}", (Object)config);
        this.tableColumnValuesRepository.saveAll(config.getTablesColumns());
        log.debug("Available stats config was saved {}", (Object)config);
    }

    private List<String> getAllColumnNamesBySystemId(@Nonnull UUID systemId) {
        log.debug("Getting all column names by systemId {}", (Object)systemId);
        List<String> allColumnsBySystemId = this.testDataService.getAllColumnNamesBySystemId(systemId);
        allColumnsBySystemId.removeAll(INTERNAL_COLUMNS);
        log.debug("Received list of column names by systemId {}", allColumnsBySystemId);
        return allColumnsBySystemId;
    }

    @Override
    public AvailableDataByColumnStats getAvailableDataInColumn(@Nonnull UUID systemId, @Nonnull UUID environmentId) {
        log.info("Getting available data in column by environmentId {} and systemId {}", (Object)environmentId, (Object)systemId);
        AvailableDataByColumnStats statistic = new AvailableDataByColumnStats();
        AvailableDataStatisticsConfig config = this.getAvailableStatsConfig(systemId, environmentId);
        statistic.setDescription(config.getDescription());
        if (CollectionUtils.isEmpty(config.getTablesColumns())) {
            throw new TdmSearchAvailableStatisticConfigException();
        }
        config.getTablesColumns().stream().forEach(columnValues -> {
            TableAvailableDataStats tableStats = new TableAvailableDataStats();
            tableStats.setTableName(columnValues.getTableName());
            tableStats.setTableTitle(columnValues.getTableTitle());
            List result = this.entityManager.createNativeQuery(AvailableStatisticUtils.availableDataQuery(columnValues, config.getActiveColumnKey())).getResultList();
            result.forEach(resultRow -> {
                String key = String.valueOf(resultRow[0]);
                if (columnValues.getValues().contains(key)) {
                    tableStats.getOptions().put(key, ((BigInteger)resultRow[1]).intValue());
                }
            });
            columnValues.getValues().stream().forEach(value -> tableStats.getOptions().putIfAbsent((String)value, 0));
            statistic.addTableStatistics(tableStats);
        });
        log.debug("Received available data statistic: {}", (Object)statistic);
        return statistic;
    }

    @Override
    public TestAvailableDataMonitoring getAvailableDataMonitoringConfig(@Nonnull UUID systemId, @Nonnull UUID environmentId) {
        log.info("Getting available data monitoring config by environmentId {} and systemId {}", (Object)environmentId, (Object)systemId);
        TestAvailableDataMonitoring monitoringItem = this.availableDataMonitoringRepository.findByEnvironmentIdAndSystemId(environmentId, systemId);
        if (monitoringItem == null) {
            throw new TdmSearchAvailableMonitoringConfigException();
        }
        log.debug("Available data monitoring config for envId {} and systemId {}: {}", new Object[]{environmentId, systemId, monitoringItem});
        return monitoringItem;
    }

    @Override
    public void saveAvailableDataMonitoringConfig(@Nonnull TestAvailableDataMonitoring monitoringConfig) throws Exception {
        log.info("Saving available data monitoring config {}", (Object)monitoringConfig);
        if (this.getAvailableDataMonitoringConfig(monitoringConfig.getSystemId(), monitoringConfig.getEnvironmentId()) == null) {
            log.error("Error getting monitoring configuration. You need to Setup available data report.");
            throw new TdmSearchAvailableMonitoringConfigException();
        }
        CronExpression.validateExpression((String)monitoringConfig.getSchedule());
        ValidateCronExpression.validate(monitoringConfig.getSchedule());
        this.availableDataMonitoringRepository.save(monitoringConfig);
        this.rescheduleAvailableData(monitoringConfig);
        log.info("Available data monitoring was rescheduled.");
    }

    @Override
    public void deleteAvailableDataMonitoringConfig(@Nonnull UUID systemId, @Nonnull UUID environmentId) {
        log.info("Deleting available data statistics schedule for system ID: {}", (Object)systemId);
        TestAvailableDataMonitoring config = this.getAvailableDataMonitoringConfig(systemId, environmentId);
        config.setSchedule("");
        config.setScheduled(false);
        config.setRecipients("");
        this.availableDataMonitoringRepository.save(config);
        this.schedulerService.deleteJob(new JobKey(String.valueOf(systemId), SCHEDULE_AVAILABLE_DATA_GROUP));
        log.info("The statistics available data schedule successfully deleted.");
    }
}

