/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.BaseCreateQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

public class CreateViewQuery
extends BaseCreateQuery<CreateViewQuery> {
    private SelectQuery _selectQuery;
    private boolean _withCheckOption;

    public CreateViewQuery(Table table) {
        this((Object)table);
    }

    public CreateViewQuery(Object tableStr) {
        super(Converter.toCustomTableSqlObject(tableStr));
    }

    @Override
    public DropQuery getDropQuery() {
        return new DropQuery(DropQuery.Type.VIEW, this._object);
    }

    @Override
    public CreateViewQuery addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public CreateViewQuery setSelectQuery(SelectQuery selectQuery) {
        this._selectQuery = selectQuery;
        return this;
    }

    public CreateViewQuery setWithCheckOption(boolean withCheckOption) {
        this._withCheckOption = withCheckOption;
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        vContext.collectNestedQuerySchemaObjects(this._selectQuery);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._selectQuery == null) {
            throw new ValidationException("missing select query");
        }
        SqlObjectList<SqlObject> selectColumns = this._selectQuery.getColumns();
        if (!this._columns.isEmpty() && this._columns.size() != selectColumns.size() && !this._selectQuery.hasAllColumns()) {
            throw new ValidationException("mismatched columns and select columns for view");
        }
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append("CREATE VIEW ").append(this._object);
        if (!this._columns.isEmpty()) {
            app.append(" (").append(this._columns).append(")");
        }
        app.append(" AS ").append(this._selectQuery);
        if (this._withCheckOption) {
            app.append(" WITH CHECK OPTION");
        }
    }
}

