/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import liquibase.pro.packaged.aq;
import liquibase.pro.packaged.ar;
import liquibase.pro.packaged.ay;
import liquibase.pro.packaged.cV;
import liquibase.pro.packaged.cg;
import liquibase.pro.packaged.cj;
import liquibase.pro.packaged.cm;
import liquibase.pro.packaged.dj;
import liquibase.pro.packaged.lK;
import liquibase.pro.packaged.lL;
import liquibase.pro.packaged.lW;

public final class lJ {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final lK[] NO_CTORS = new lK[0];
    private static final Iterator<?> EMPTY_ITERATOR = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<cj> findSuperTypes(cj cj2, Class<?> clazz, boolean bl2) {
        if (cj2 == null || cj2.hasRawClass(clazz) || cj2.hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<cj> arrayList = new ArrayList<cj>(8);
        lJ._addSuperTypes(cj2, clazz, arrayList, bl2);
        return arrayList;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        if (clazz == null || clazz == clazz2 || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(8);
        lJ._addRawSuperTypes(clazz, clazz2, arrayList, bl2);
        return arrayList;
    }

    public static List<Class<?>> findSuperClasses(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        LinkedList linkedList = new LinkedList();
        if (clazz != null && clazz != clazz2) {
            if (bl2) {
                linkedList.add(clazz);
            }
            while ((clazz = clazz.getSuperclass()) != null && clazz != clazz2) {
                linkedList.add(clazz);
            }
        }
        return linkedList;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return lJ.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        lJ._addRawSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(cj cj2, Class<?> clazz, Collection<cj> collection, boolean bl2) {
        while (cj2 != null) {
            Class<?> clazz2 = cj2.getRawClass();
            if (clazz2 == clazz || clazz2 == Object.class) {
                return;
            }
            if (bl2) {
                if (collection.contains(cj2)) {
                    return;
                }
                collection.add(cj2);
            }
            Iterator<cj> iterator = cj2.getInterfaces().iterator();
            while (iterator.hasNext()) {
                lJ._addSuperTypes(iterator.next(), clazz, collection, true);
            }
            bl2 = true;
            cj2 = cj2.getSuperClass();
        }
        return;
    }

    private static void _addRawSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl2) {
        while (clazz != clazz2 && clazz != null && clazz != Object.class) {
            if (bl2) {
                if (collection.contains(clazz)) {
                    return;
                }
                collection.add(clazz);
            }
            Class<?>[] classArray = lJ._interfaces(clazz);
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                lJ._addRawSuperTypes(classArray[i2], clazz2, collection, true);
            }
            bl2 = true;
            clazz = clazz.getSuperclass();
        }
        return;
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (clazz.isEnum()) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl2) {
        try {
            if (lJ.hasEnclosingMethod(clazz)) {
                return "local/anonymous";
            }
            if (!bl2 && !Modifier.isStatic(clazz.getModifiers()) && lJ.getEnclosingClass(clazz) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        try {
            if (lJ.hasEnclosingMethod(clazz)) {
                return null;
            }
            if (!Modifier.isStatic(clazz.getModifiers())) {
                return lJ.getEnclosingClass(clazz);
            }
        }
        catch (SecurityException securityException) {}
        return null;
    }

    public static boolean isProxyType(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("net.sf.cglib.proxy.") || ((String)object).startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        return (clazz.getModifiers() & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        return (member.getModifiers() & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isBogusClass(Class<?> clazz) {
        return clazz == Void.class || clazz == Void.TYPE || clazz == dj.class;
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && lJ.getEnclosingClass(clazz) != null;
    }

    public static boolean isObjectOrPrimitive(Class<?> clazz) {
        return clazz == CLS_OBJECT || clazz.isPrimitive();
    }

    public static boolean hasClass(Object object, Class<?> clazz) {
        return object != null && object.getClass() == clazz;
    }

    public static void verifyMustOverride(Class<?> clazz, Object object, String string) {
        if (object.getClass() != clazz) {
            throw new IllegalStateException(String.format("Sub-class %s (of class %s) must override method '%s'", object.getClass().getName(), clazz.getName(), string));
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable throwIfError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfRTE(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfIOE(Throwable throwable) {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        return throwable;
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable throwRootCauseIfIOE(Throwable throwable) {
        return lJ.throwIfIOE(lJ.getRootCause(throwable));
    }

    public static void throwAsIAE(Throwable throwable) {
        Throwable throwable2 = throwable;
        lJ.throwAsIAE(throwable2, throwable2.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        lJ.throwIfRTE(throwable);
        lJ.throwIfError(throwable);
        throw new IllegalArgumentException(string, throwable);
    }

    public static <T> T throwAsMappingException(cg serializable, IOException iOException) {
        if (iOException instanceof cm) {
            throw (cm)iOException;
        }
        serializable = cm.from(serializable, iOException.getMessage());
        ((Throwable)serializable).initCause(iOException);
        throw serializable;
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        lJ.throwAsIAE(lJ.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        lJ.throwAsIAE(lJ.getRootCause(throwable), string);
    }

    public static void closeOnFailAndThrowAsIOE(aq aq2, Exception exception) {
        aq2.disable(ar.AUTO_CLOSE_JSON_CONTENT);
        try {
            aq2.close();
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
        lJ.throwIfIOE(exception);
        lJ.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static void closeOnFailAndThrowAsIOE(aq aq2, Closeable closeable, Exception exception) {
        if (aq2 != null) {
            aq2.disable(ar.AUTO_CLOSE_JSON_CONTENT);
            try {
                aq2.close();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception3) {
                exception.addSuppressed(exception3);
            }
        }
        lJ.throwIfIOE(exception);
        lJ.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl2) {
        Constructor<T> constructor = lJ.findConstructor(clazz, bl2);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            constructor = exception;
            lJ.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + ((Throwable)((Object)constructor)).getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl2) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl2) {
                lJ.checkAndFixAccess(constructor, bl2);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            lJ.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception2.getMessage());
        }
        return null;
    }

    public static Class<?> classOf(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public static Class<?> rawClass(cj cj2) {
        if (cj2 == null) {
            return null;
        }
        return cj2.getRawClass();
    }

    public static <T> T nonNull(T t2, T t3) {
        if (t2 == null) {
            return t3;
        }
        return t2;
    }

    public static String nullOrToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String quotedOr(Object object, String string) {
        if (object == null) {
            return string;
        }
        return String.format("\"%s\"", object);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        return lJ.nameOf(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public static String classNameOf(Object object) {
        if (object == null) {
            return "[null]";
        }
        return lJ.nameOf(object.getClass());
    }

    public static String nameOf(Class<?> object) {
        if (object == null) {
            return "[null]";
        }
        int n2 = 0;
        while (((Class)object).isArray()) {
            ++n2;
            object = ((Class)object).getComponentType();
        }
        Object object2 = object = ((Class)object).isPrimitive() ? ((Class)object).getSimpleName() : ((Class)object).getName();
        if (n2 > 0) {
            object = new StringBuilder((String)object);
            do {
                ((StringBuilder)object).append("[]");
            } while (--n2 > 0);
            object = ((StringBuilder)object).toString();
        }
        return lJ.backticked((String)object);
    }

    public static String nameOf(lW lW2) {
        if (lW2 == null) {
            return "[null]";
        }
        return lJ.backticked(lW2.getName());
    }

    public static String backticked(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('`').append(string).append('`').toString();
    }

    public static String exceptionMessage(Throwable throwable) {
        if (throwable instanceof ay) {
            return ((ay)throwable).getOriginalMessage();
        }
        return throwable.getMessage();
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        lJ.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean bl2) {
        AnnotatedElement annotatedElement = (AccessibleObject)((Object)member);
        try {
            if (bl2 || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
                ((AccessibleObject)annotatedElement).setAccessible(true);
            }
            return;
        }
        catch (SecurityException securityException) {
            if (!((AccessibleObject)annotatedElement).isAccessible()) {
                annotatedElement = member.getDeclaringClass();
                throw new IllegalArgumentException("Cannot access " + member + " (from class " + ((Class)annotatedElement).getName() + "; failed to set access: " + securityException.getMessage());
            }
            return;
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return lJ.findEnumType((Enum)enumSet.iterator().next());
        }
        return lL.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return lJ.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return lL.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> clazz) {
        if ((clazz = clazz.getClass()).getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> clazz, Class<T> clazz2) {
        for (Field field : lJ.getDeclaredFields(clazz)) {
            if (!field.isEnumConstant() || field.getAnnotation(clazz2) == null) continue;
            String string = field.getName();
            for (Enum<?> enum_ : clazz.getEnumConstants()) {
                if (!string.equals(enum_.name())) continue;
                return enum_;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object == null || lJ.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(cV.class) != null;
    }

    public static String getPackageName(Class<?> annotatedElement) {
        if ((annotatedElement = ((Class)annotatedElement).getPackage()) == null) {
            return null;
        }
        return ((Package)annotatedElement).getName();
    }

    public static boolean hasEnclosingMethod(Class<?> clazz) {
        return !lJ.isObjectOrPrimitive(clazz) && clazz.getEnclosingMethod() != null;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> clazz) {
        if (lJ.isObjectOrPrimitive(clazz)) {
            return NO_ANNOTATIONS;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Method[] getClassMethods(Class<?> clazz) {
        try {
            return lJ.getDeclaredMethods(clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw noClassDefFoundError;
            }
            try {
                clazz = classLoader.loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                noClassDefFoundError.addSuppressed(classNotFoundException);
                throw noClassDefFoundError;
            }
            return clazz.getDeclaredMethods();
        }
    }

    public static lK[] getConstructors(Class<?> constructorArray) {
        if (constructorArray.isInterface() || lJ.isObjectOrPrimitive(constructorArray)) {
            return NO_CTORS;
        }
        constructorArray = constructorArray.getDeclaredConstructors();
        int n2 = constructorArray.length;
        lK[] lKArray = new lK[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lKArray[i2] = new lK(constructorArray[i2]);
        }
        return lKArray;
    }

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        if (lJ.isObjectOrPrimitive(clazz)) {
            return null;
        }
        return clazz.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return clazz.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        if (lJ.isObjectOrPrimitive(clazz)) {
            return null;
        }
        return clazz.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }
}

