/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.config;

import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.config.WhiteSpaceProcessing;

public final class DiffXConfig {
    private boolean isNamespaceAware = true;
    private boolean reportPrefixDifferences = false;
    private WhiteSpaceProcessing whitespace = WhiteSpaceProcessing.COMPARE;
    private boolean preserveWhiteSpace = true;
    private TextGranularity granularity = TextGranularity.WORD;

    public DiffXConfig() {
    }

    public DiffXConfig(TextGranularity granularity) {
        if (granularity == null) {
            throw new NullPointerException("The granularity cannot be configured to be not be null.");
        }
        this.granularity = granularity;
    }

    public DiffXConfig(WhiteSpaceProcessing whitespace, TextGranularity granularity) {
        if (granularity == null) {
            throw new NullPointerException("The granularity cannot be configured to be not be null.");
        }
        if (whitespace == null) {
            throw new NullPointerException("The whitespace processing cannot be configured to be not be null.");
        }
        this.granularity = granularity;
        this.whitespace = whitespace;
    }

    public void setGranularity(TextGranularity granularity) {
        if (granularity == null) {
            throw new NullPointerException("The granularity cannot be configured to be not be null.");
        }
        this.granularity = granularity;
    }

    public void setWhiteSpaceProcessing(WhiteSpaceProcessing whitespace) {
        if (whitespace == null) {
            throw new NullPointerException("The whitespace cannot be configured to be not be null.");
        }
        this.whitespace = whitespace;
    }

    public void setNamespaceAware(boolean aware) {
        this.isNamespaceAware = aware;
        if (!aware) {
            this.reportPrefixDifferences = true;
        }
    }

    public void setReportPrefixDifferences(boolean report) {
        this.reportPrefixDifferences = report;
        if (!report) {
            this.isNamespaceAware = true;
        }
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public boolean isReportPrefixDifferences() {
        return this.reportPrefixDifferences;
    }

    public TextGranularity getGranularity() {
        return this.granularity;
    }

    public WhiteSpaceProcessing getWhiteSpaceProcessing() {
        return this.whitespace;
    }

    public boolean isIgnoreWhiteSpace() {
        return this.whitespace != WhiteSpaceProcessing.COMPARE;
    }

    public boolean isPreserveWhiteSpace() {
        return this.preserveWhiteSpace;
    }

    @Deprecated
    public void setIgnoreWhiteSpace(boolean ignore) {
        this.whitespace = !ignore ? WhiteSpaceProcessing.COMPARE : (this.preserveWhiteSpace ? WhiteSpaceProcessing.PRESERVE : WhiteSpaceProcessing.IGNORE);
    }

    @Deprecated
    public void setPreserveWhiteSpace(boolean preserve) {
        this.preserveWhiteSpace = preserve;
        if (this.whitespace != WhiteSpaceProcessing.COMPARE) {
            this.whitespace = preserve ? WhiteSpaceProcessing.PRESERVE : WhiteSpaceProcessing.IGNORE;
        }
    }
}

