/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class AttributeEventImpl
extends DiffXEventBase
implements AttributeEvent {
    private final String name;
    private final String value;
    private final int hashCode;

    public AttributeEventImpl(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (value == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = name;
        this.value = value;
        this.hashCode = AttributeEventImpl.toHashCode(name, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURI() {
        return null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(DiffXEvent e) {
        if (e.getClass() != this.getClass()) {
            return false;
        }
        AttributeEventImpl bae = (AttributeEventImpl)e;
        return bae.name.equals(this.name) && bae.value.equals(this.value);
    }

    public String toString() {
        return "attribute: " + this.name + "=" + this.value;
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        xml.attribute(this.name, this.value);
    }

    @Override
    public StringBuffer toXML(StringBuffer xml) throws NullPointerException {
        xml.append(' ');
        xml.append(this.name);
        xml.append("=\"");
        xml.append(ESC.toAttributeValue(this.value));
        xml.append('\"');
        return xml;
    }

    private static int toHashCode(String name, String value) {
        int hash = 23;
        hash = hash * 37 + (name != null ? name.hashCode() : 0);
        hash = hash * 37 + (value != null ? value.hashCode() : 0);
        return hash;
    }
}

