/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.tdm.controllers.api;

import org.qubership.atp.tdm.controllers.api.dto.refresh.RefreshResultsDto;
import org.qubership.atp.tdm.controllers.api.dto.refresh.TestDataRefreshConfigDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:59:11.597365407Z[Etc/UTC]")
@Validated
@Tag(name = "DataRefreshController", description = "Data Refresh Controller")
public interface DataRefreshControllerApi {

    /**
     * GET /api/tdm/data/refresh/next/run : Get next run&#39;s date / time details.
     *
     * @param cronExpression cronExpression (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getNextScheduledRun",
        summary = "Get next run's date / time details.",
        tags = { "data-refresh-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/tdm/data/refresh/next/run",
        produces = { "application/json" }
    )
    ResponseEntity<String> getNextScheduledRun(
        @NotNull @Parameter(name = "cronExpression", description = "cronExpression", required = true) @Valid @RequestParam(value = "cronExpression", required = true) String cronExpression
    );


    /**
     * GET /api/tdm/data/refresh/config/{id} : Get refresh configuration for specified dataset / table ID.
     *
     * @param id id (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getRefreshConfig",
        summary = "Get refresh configuration for specified dataset / table ID.",
        tags = { "data-refresh-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestDataRefreshConfigDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/tdm/data/refresh/config/{id}",
        produces = { "application/json" }
    )
    ResponseEntity<TestDataRefreshConfigDto> getRefreshConfig(
        @Parameter(name = "id", description = "id", required = true) @PathVariable("id") UUID id
    );


    /**
     * POST /api/tdm/data/refresh/run : Force run data refresh.
     *
     * @param tableName tableName (required)
     * @param queryTimeout queryTimeout (required)
     * @param allEnv allEnv (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "runDataRefresh",
        summary = "Force run data refresh.",
        tags = { "data-refresh-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = RefreshResultsDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/tdm/data/refresh/run",
        produces = { "application/json" }
    )
    ResponseEntity<List<RefreshResultsDto>> runDataRefresh(
        @NotNull @Parameter(name = "tableName", description = "tableName", required = true) @Valid @RequestParam(value = "tableName", required = true) String tableName,
        @NotNull @Parameter(name = "queryTimeout", description = "queryTimeout", required = true) @Valid @RequestParam(value = "queryTimeout", required = true) Integer queryTimeout,
        @NotNull @Parameter(name = "allEnv", description = "allEnv", required = true) @Valid @RequestParam(value = "allEnv", required = true) Boolean allEnv
    );


    /**
     * POST /api/tdm/data/refresh/config : Save / update data refresh settings.
     *
     * @param tableName tableName (required)
     * @param queryTimeout queryTimeout (required)
     * @param testDataRefreshConfigDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "saveRefreshConfig",
        summary = "Save / update data refresh settings.",
        tags = { "data-refresh-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestDataRefreshConfigDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/tdm/data/refresh/config",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<TestDataRefreshConfigDto> saveRefreshConfig(
        @NotNull @Parameter(name = "tableName", description = "tableName", required = true) @Valid @RequestParam(value = "tableName", required = true) String tableName,
        @NotNull @Parameter(name = "queryTimeout", description = "queryTimeout", required = true) @Valid @RequestParam(value = "queryTimeout", required = true) Integer queryTimeout,
        @Parameter(name = "TestDataRefreshConfigDto", description = "") @Valid @RequestBody(required = false) TestDataRefreshConfigDto testDataRefreshConfigDto
    );

}
